/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.xml;

import com.querydsl.core.QueryException;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.importierer.api.FileImporter;
import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbank.importierer.api.InvalidImportFileException;
import de.planetensuche.datenbank.importierer.merge.CheckAndMerge;
import de.planetensuche.datenbank.importierer.merge.PsObjectMergeException;
import de.planetensuche.datenbank.importierer.threads.AbstractBasisImport;
import de.planetensuche.datenbank.importierer.threads.ImportListener;
import de.planetensuche.datenbank.importierer.validator.CatalogNamesValidator;
import de.planetensuche.datenbank.importierer.validator.InvalidCatalogException;
import de.planetensuche.datenbank.importierer.xml.DateiValidator;
import de.planetensuche.datenbank.importierer.xml.PsObjektInputDto;
import de.planetensuche.datenbank.importierer.xml.PsObjektListenGruppierer;
import de.planetensuche.datenbank.importierer.xml.PsObjektTransformer;
import de.planetensuche.datenbank.importierer.xml.SaxHelfer;
import de.planetensuche.datenbank.importierer.xml.elemente.ElementCommandLocator;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbank.reorganisieren.Aufraeumthread;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdom2.Element;
import org.xml.sax.SAXException;

public final class ImportthreadXML
extends AbstractBasisImport
implements FileImporter {
    private final IImportDialog importDialog;
    private final ISprachcontainer i18n;
    private final IStart start;
    private final DateiValidator dateiValidator;
    private final SaxHelfer saxHelfer;
    private ImportListener listener;
    private boolean entdeckerEinfuegen;
    private boolean entdeckungsmethodenEinfuegen;
    private boolean ergaenzen;
    private final CopyOnWriteArrayList<String> erfolgreichGespeicherteObjekte;
    private final CopyOnWriteArrayList<String> nichtEingefuegteObjekte;
    private final List<String> uebersprungeneObjekte;
    private boolean zeigeFortschritt = true;
    private final ITimestampDAO timestampDAO;
    private final IDAOhighService daoHighService;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final PlanetensucheObjektPrueferDAO daoHigh;
    private final IEntdeckerRepository entdeckerRepository;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final Katalogerkenner katalogerkenner;
    private final CheckAndMerge merger;
    private final IDatenbankverbinder datenbankverbinder;

    public ImportthreadXML(File file, IImportDialog iImportDialog, ParameterDto parameterDto, IStart iStart, InjectionDto injectionDto, IDatenbankverbinder iDatenbankverbinder) {
        this.setDatei(file);
        this.importDialog = iImportDialog;
        this.i18n = parameterDto.getSprache();
        this.start = iStart;
        this.timestampDAO = injectionDto.getTimestampDAO();
        this.daoHighService = injectionDto.getDaoHighService();
        this.planetensucheObjektRepository = injectionDto.getPlanetensucheObjektRepository();
        this.daoHigh = injectionDto.getDao();
        this.entdeckerRepository = injectionDto.getEntdeckerRepository();
        this.entdeckungsmethodenRepository = injectionDto.getEntdeckungsmethodenRepository();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.datenbankverbinder = iDatenbankverbinder;
        this.katalogerkenner = injectionDto.getKatalogerkenner();
        CatalogNamesValidator catalogNamesValidator = new CatalogNamesValidator(this.katalogerkenner);
        this.merger = new CheckAndMerge(this.planetensucheObjektRepository, this.daoHigh, catalogNamesValidator, this.katalogerkenner);
        if (this.importDialog != null) {
            this.ergaenzen = iImportDialog.objekteErgaenzen();
        }
        this.dateiValidator = new DateiValidator();
        this.saxHelfer = new SaxHelfer();
        this.erfolgreichGespeicherteObjekte = new CopyOnWriteArrayList();
        this.nichtEingefuegteObjekte = new CopyOnWriteArrayList();
        this.uebersprungeneObjekte = new ArrayList<String>(100);
    }

    public void registerListener(ImportListener importListener) {
        this.listener = importListener;
    }

    public void setZeigeFortschritt(boolean bl) {
        this.zeigeFortschritt = bl;
    }

    public boolean warImportFehlerfrei() {
        return this.nichtEingefuegteObjekte.isEmpty();
    }

    public List<String> getUebersprungeneObjekte() {
        return this.uebersprungeneObjekte;
    }

    public CopyOnWriteArrayList<String> getErfolgreichGespeicherteObjekte() {
        return this.erfolgreichGespeicherteObjekte;
    }

    @Override
    public void run() {
        this.executeSync();
    }

    public boolean executeSync() throws HeadlessException {
        if (this.importDialog == null) {
            return this.importAutoUpdate();
        }
        if (this.getDatei() != null) {
            this.importDialog.appendOutput(this.i18n.getString("db_m165_1") + " '" + this.getDatei().getName() + "' " + this.i18n.getString("db_m165_2"));
            this.importDialog.setStatus(0);
            int n = JOptionPane.showConfirmDialog((JFrame)((Object)this.importDialog), this.i18n.getString("db_m173"), this.i18n.getString("db_m173_titel"), 0, 3);
            if (n == 0) {
                this.entdeckerEinfuegen = true;
            }
            if ((n = JOptionPane.showConfirmDialog((JFrame)((Object)this.importDialog), this.i18n.getString("db_m174"), this.i18n.getString("db_m174_titel"), 0, 3)) == 0) {
                this.entdeckungsmethodenEinfuegen = true;
            }
            if (this.importXML()) {
                this.importDialog.appendOutput(this.i18n.getString("db_m170"));
                this.importDialog.setStatus(100);
                JOptionPane.showMessageDialog((JFrame)((Object)this.importDialog), this.i18n.getString("db_m175"), this.i18n.getString("db_m174_titel"), 1);
                return true;
            }
            this.importDialog.appendOutput(this.i18n.getString("db_m172"));
            this.importDialog.setStatus(0);
            JOptionPane.showMessageDialog((JFrame)((Object)this.importDialog), this.i18n.getString("db_f35"), this.i18n.getString("db_f34_titel"), 0);
        } else {
            this.logger.warn("Fehler wegen leeren Aufrufparametern!");
        }
        return false;
    }

    boolean importAutoUpdate() {
        this.entdeckerEinfuegen = true;
        this.entdeckungsmethodenEinfuegen = true;
        return this.importXML();
    }

    @Override
    public boolean importiereCsvDatei() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void aktualisiereFortschrittsbalken(int n, int n2, long l) {
        this.importDialog.setStatus(n * 100 / n2);
        this.importDialog.setRestzeit((System.currentTimeMillis() - l) / (long)(n + 1) * (long)(n2 - (n + 1)) / 1000L);
    }

    private boolean importXML() {
        Schema schema;
        if (this.importDialog != null) {
            this.importDialog.setStartButtonEnabled(false);
            this.importDialog.setCursurWait(true);
        }
        StreamSource streamSource = new StreamSource(this.getDatei());
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource streamSource2 = new StreamSource(new File(new File("").getAbsolutePath() + File.separator + "database" + File.separator + "planetensuche_schema.xsd"));
        try {
            schema = schemaFactory.newSchema(streamSource2);
        }
        catch (SAXException sAXException) {
            this.logger.error(sAXException);
            if (this.listener != null) {
                this.listener.exceptionOccured(sAXException);
            }
            return false;
        }
        this.dateiValidator.checkXMLVersion(this.getDatei());
        boolean bl = this.abbruchWegenFehlerhaftemDokument(schema, streamSource);
        this.logger.debug("abbruchWegenFehlerhaftemDokument? " + bl);
        if (bl) {
            this.logger.warn("cancel xml import because of invalid document");
            if (this.importDialog == null) {
                System.out.println("cancel xml import because of invalid document");
            }
            return false;
        }
        try {
            List<Element> list = this.saxHelfer.getAllElementsFromXmlFile(this.getDatei(), this.listener);
            String string = this.i18n.getString("db_m505", list.size());
            this.logger.info(string);
            if (this.importDialog == null) {
                System.out.println(string);
            }
            long l = System.currentTimeMillis();
            this.pruefeAufDoppelteObjektnamen(list);
            long l2 = System.currentTimeMillis() - l;
            this.logger.debug("auf doppelte objektnamen pr\u00fcfen dauerte " + l2 + " ms");
            long l3 = System.currentTimeMillis();
            PsObjektListenGruppierer psObjektListenGruppierer = new PsObjektListenGruppierer();
            List<List<Element>> list2 = psObjektListenGruppierer.teileListeNachImportReihenfolge(list);
            long l4 = System.currentTimeMillis() - l3;
            this.logger.debug("objekte gruppieren dauerte " + l4 + " ms");
            this.importAllElements(list2);
            return true;
        }
        catch (Exception exception) {
            this.logger.error("Allgemeiner Fehler", exception);
            if (this.importDialog != null) {
                this.importDialog.appendOutput(this.i18n.getString("db_f34_titel") + "...");
                this.importDialog.appendOutput(exception.toString());
                this.importDialog.setStartButtonEnabled(true);
                this.importDialog.setCursurWait(false);
            } else {
                System.out.println(this.i18n.getString("db_f34_titel") + "...");
                if (this.listener != null) {
                    this.listener.exceptionOccured(exception);
                }
                this.start.exitApp();
            }
            return false;
        }
    }

    private void importAllElements(List<List<Element>> list) throws SQLException, InterruptedException {
        Object object;
        int n = this.count(list);
        this.logger.debug("number of objects after group by: " + n);
        if (n == 0) {
            throw new IllegalStateException("no objects available for XML import");
        }
        this.setGesamteZeilenanzahl(n);
        String string = this.i18n.getString("db_m443") + " " + n + " " + this.i18n.getString("db_m443_rest");
        this.logger.info(string);
        if (this.importDialog == null) {
            System.out.println(string);
        } else {
            this.importDialog.appendOutput(string);
        }
        ElementCommandLocator elementCommandLocator = new ElementCommandLocator(this.ergaenzen);
        PsObjektTransformer psObjektTransformer = new PsObjektTransformer(elementCommandLocator, this.daoHigh, this.objektnamenRepository, this.planetensucheObjektRepository, this.entdeckungsmethodenRepository, this.timestampDAO, this.daoHighService);
        long l = System.currentTimeMillis();
        AtomicInteger atomicInteger = new AtomicInteger();
        for (List<Element> list2 : list) {
            if (this.isInterrupted()) break;
            object = new ArrayList<Callable<PsObjektInputDto>>();
            for (Element element : list2) {
                object.add(() -> {
                    try {
                        PsObjektInputDto psObjektInputDto = psObjektTransformer.transformPsObjekt(element, this.ergaenzen, this.entdeckungsmethodenEinfuegen);
                        return psObjektInputDto;
                    }
                    catch (Exception exception) {
                        this.logger.error("Fehler im Transformer", exception);
                        throw exception;
                    }
                });
            }
            ExecutorService executorService = list2.size() >= 1000 ? Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() - 1) : Executors.newSingleThreadExecutor();
            List object22 = executorService.invokeAll(object);
            executorService.shutdown();
            AtomicInteger atomicInteger2 = new AtomicInteger(0);
            object22.stream().forEach(future -> {
                int n2;
                PsObjektInputDto psObjektInputDto = null;
                try {
                    psObjektInputDto = (PsObjektInputDto)future.get();
                    if (!psObjektInputDto.isReferenzFehler()) {
                        this.savePsObjectXML(psObjektInputDto.getPsObjekt(), psObjektInputDto.getNamen(), psObjektInputDto.getEntdecker(), psObjektInputDto.getBilder(), psObjektInputDto.getTs());
                    } else {
                        String string = psObjektInputDto.getNamen().get(0);
                        if (this.importDialog != null) {
                            this.importDialog.appendOutput(this.i18n.getString("db_f39_1").replaceFirst("</html>", "") + string + this.i18n.getString("db_f39_2") + psObjektInputDto.getElternObjektName() + "'.</html>");
                        } else {
                            this.logger.info(this.i18n.getString("db_f39_1") + string + this.i18n.getString("db_f39_2") + psObjektInputDto.getElternObjektName() + "'.");
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
                catch (QueryException | ExecutionException exception) {
                    this.logger.error(exception);
                }
                this.incrementAktuelleZeile();
                if (psObjektInputDto != null && (n2 = this.showImportProgressAndReturnPercentageDone(atomicInteger.incrementAndGet(), n, atomicInteger2.get(), l, psObjektInputDto.getPsObjekt(), psObjektInputDto.getNamen().get(0))) != atomicInteger2.get()) {
                    atomicInteger2.set(n2);
                }
            });
            executorService.shutdownNow();
        }
        long l2 = System.currentTimeMillis() - l;
        this.loggeUndZeigeZusammenfassung(l2, n);
        if (this.importDialog != null) {
            this.importDialog.setStartButtonEnabled(true);
            this.importDialog.setCursurWait(false);
        } else if (this.listener != null) {
            this.listener.afterImport();
        } else {
            object = new Aufraeumthread(true, true, this.datenbankverbinder);
            if (((Aufraeumthread)object).dbAufraeumenStarten()) {
                this.logger.info("ok!");
            } else {
                this.logger.info(this.i18n.getString("db_f4_titel") + "!");
            }
            this.start.exitApp();
        }
    }

    private void loggeUndZeigeZusammenfassung(long l, int n) throws SQLException {
        long l2 = Math.round(1.0 * (double)l / (double)n);
        String string = "Import-Dauer: " + l + " ms f\u00fcr " + n + " Objekte (" + l2 + " ms pro Objekt)";
        this.loggeUndZeigeText(string);
        if (this.erfolgreichGespeicherteObjekte.size() > 20) {
            this.loggeUndZeigeText("erfolgreich importierte Objekte: " + this.erfolgreichGespeicherteObjekte.size());
        } else {
            this.loggeUndZeigeText("erfolgreich importierte Objekte: " + this.erfolgreichGespeicherteObjekte.size() + " " + String.valueOf(this.erfolgreichGespeicherteObjekte));
        }
        if (this.uebersprungeneObjekte.size() > 20) {
            this.loggeUndZeigeText("uebersprungene Objekte: " + this.uebersprungeneObjekte.size());
        } else {
            this.loggeUndZeigeText("uebersprungene Objekte: " + this.uebersprungeneObjekte.size() + " " + String.valueOf(this.uebersprungeneObjekte));
        }
        this.loggeUndZeigeText("fehlerhafte Objekte: " + this.nichtEingefuegteObjekte.size() + " " + String.valueOf(this.nichtEingefuegteObjekte));
        this.loggeUndZeigeText(this.nichtEingefuegteObjekte.toString());
        this.loggeUndZeigeText("Sterne insgesamt in DB: " + this.daoHighService.countKategorie(ObjektKategorie.STERNE.getKategorienName()));
        this.loggeUndZeigeText("Namen insgesamt in DB: " + this.objektnamenRepository.countNames());
    }

    private int showImportProgressAndReturnPercentageDone(int n, int n2, int n3, long l, PlanetensucheObjektPruefer planetensucheObjektPruefer, String string) {
        if (this.importDialog != null) {
            this.aktualisiereFortschrittsbalken(n, n2, l);
        } else if (this.zeigeFortschritt) {
            double d = (double)Math.round((double)n * 10000.0 / (double)n2) / 100.0;
            if (planetensucheObjektPruefer.getObjektNamen().isEmpty()) {
                var10_8 = " " + this.i18n.getString("db_m181") + " (" + string + ")";
                this.logger.info(d + var10_8);
            } else {
                var10_8 = " " + this.i18n.getString("db_m181") + " (" + planetensucheObjektPruefer.getObjektNamen().get(0) + ")";
                this.logger.info(d + var10_8);
            }
            int n4 = n * 100 / n2;
            if (n3 < n4) {
                System.out.println(n4 + " " + this.i18n.getString("db_m181"));
            }
            return n4;
        }
        return 0;
    }

    private void pruefeAufDoppelteObjektnamen(List<Element> list) {
        this.logger.debug(this.i18n.getString("db_m441"));
        if (this.importDialog == null) {
            this.logger.info(this.i18n.getString("db_m441"));
        } else {
            this.importDialog.appendOutput(this.i18n.getString("db_m441"));
        }
        HashSet<String> hashSet = new HashSet<String>(list.size() * 2);
        for (Element element : list) {
            List<Element> list2 = element.getChildren();
            for (Element element2 : list2) {
                if (!"name".equals(element2.getName())) continue;
                if (!hashSet.contains(element2.getValue())) {
                    hashSet.add(element2.getValue());
                    continue;
                }
                this.logger.warn("Objektname '" + element2.getValue() + "' ist doppelt!");
                throw new InvalidImportFileException(this.i18n.getString("db_f116") + " (" + element2.getValue() + ")");
            }
        }
        String string = "XML-" + this.i18n.getString("db_m442");
        this.logger.debug(string);
        if (this.importDialog == null) {
            this.logger.info(string);
        } else {
            this.importDialog.appendOutput(string);
        }
    }

    private boolean abbruchWegenFehlerhaftemDokument(Schema schema, Source source) {
        block12: {
            try {
                Validator validator = schema.newValidator();
                validator.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                if (this.importDialog != null) {
                    this.importDialog.appendOutput(this.i18n.getString("db_m178"));
                } else {
                    System.out.println(this.i18n.getString("db_m178"));
                }
                try {
                    validator.validate(source);
                    if (this.importDialog != null) {
                        this.importDialog.appendOutput(this.i18n.getString("db_m179"));
                        this.importDialog.appendOutput("");
                    } else {
                        System.out.println(this.i18n.getString("db_m179"));
                    }
                }
                catch (IOException iOException) {
                    this.logger.error(iOException);
                    if (this.importDialog != null) {
                        this.importDialog.appendOutput(this.i18n.getString("db_f37"));
                        this.importDialog.appendOutput("");
                        this.importDialog.appendOutput(iOException.toString());
                        this.importDialog.appendOutput("");
                        this.importDialog.setStartButtonEnabled(true);
                        this.importDialog.setCursurWait(false);
                        int n = JOptionPane.showConfirmDialog((JFrame)((Object)this.importDialog), this.i18n.getString("db_m180"), this.i18n.getString("db_m180_titel"), 0, 2);
                        if (n == 1) {
                            return true;
                        }
                        break block12;
                    }
                    System.out.println(this.i18n.getString("db_f37"));
                    System.out.println(iOException.toString());
                    return true;
                }
            }
            catch (SAXException sAXException) {
                this.logger.error(sAXException);
                if (this.importDialog != null) {
                    this.importDialog.appendOutput(this.i18n.getString("db_f38"));
                    this.importDialog.appendOutput("");
                    this.importDialog.appendOutput(sAXException.toString());
                    this.importDialog.appendOutput("");
                    int n = JOptionPane.showConfirmDialog((JFrame)((Object)this.importDialog), this.i18n.getString("db_m180"), this.i18n.getString("db_m180_titel"), 0, 2);
                    if (n == 1) {
                        return true;
                    }
                }
                System.out.println(this.i18n.getString("db_f38"));
                System.out.println(sAXException.toString());
                return true;
            }
        }
        return false;
    }

    private void loggeUndZeigeText(String string) {
        if (this.importDialog != null) {
            this.importDialog.appendOutput(string);
        } else {
            System.out.println(string);
        }
        this.logger.info(string);
    }

    private void savePsObjectXML(PlanetensucheObjektPruefer planetensucheObjektPruefer, List<String> list, List<String> list2, Set<String> set, Timestamp timestamp) throws InterruptedException {
        try {
            if (timestamp == null || this.importDialog == null || timestamp.before(planetensucheObjektPruefer.getStamp())) {
                list.addAll(planetensucheObjektPruefer.getObjektNamen());
                HashSet<String> hashSet = new HashSet<String>(list.size());
                hashSet.addAll(list);
                planetensucheObjektPruefer.setObjektNamen(hashSet);
                if (this.ergaenzen && planetensucheObjektPruefer.getEntdeckerMitNachnamenVornamen().isEmpty() || !this.ergaenzen) {
                    Map<String, String> map = planetensucheObjektPruefer.getEntdeckerMitNachnamenVornamen();
                    if (this.entdeckerEinfuegen) {
                        for (String object : list2) {
                            int n = object.indexOf(59);
                            if (n <= -1) continue;
                            String string = object.substring(0, n).trim();
                            String string2 = object.substring(n + 1, object.length()).trim();
                            map.put(string2, string);
                            Integer n2 = this.entdeckerRepository.getId(string2, string);
                            if (n2 != null) continue;
                            this.entdeckerRepository.save(string, string, string2, "", EntdeckerTyp.PERSON);
                        }
                    }
                    planetensucheObjektPruefer.setEntdeckerMitNachnamenVornamen(map);
                }
                if (this.ergaenzen) {
                    planetensucheObjektPruefer.getBilder().addAll(set);
                } else if (!this.ergaenzen) {
                    planetensucheObjektPruefer.setBilder(set);
                }
                boolean bl = Check.isFilled(this.objektnamenRepository.getIdsFuerNamen(hashSet));
                if (bl) {
                    if (this.objektnamenRepository.gehoertZuEinerDatenid(planetensucheObjektPruefer.getObjektNamen())) {
                        if (this.importDialog != null) {
                            if ((this.importDialog.objekteErsetzen() || this.importDialog.objekteUpdaten() || this.importDialog.objekteErgaenzen()) && !this.importDialog.test()) {
                                this.planetensucheObjektRepository.update(planetensucheObjektPruefer, true, this.katalogerkenner);
                            }
                        } else {
                            this.planetensucheObjektRepository.update(planetensucheObjektPruefer, false, this.katalogerkenner);
                        }
                        this.erfolgreichGespeicherteObjekte.add(planetensucheObjektPruefer.getObjektNamen().get(0));
                    } else if (this.importDialog == null || this.importDialog.objekteErsetzen()) {
                        this.logger.info("Objektnamen verweisen auf verschiedene Objekte und werden gemerged: " + ((Object)hashSet).toString());
                        var8_10 = this.objektnamenRepository.getIdsFuerNamen(hashSet);
                        IPlanetensucheObjekt iPlanetensucheObjekt = this.merger.checkAndMerge(var8_10);
                        this.erfolgreichGespeicherteObjekte.add(iPlanetensucheObjekt.getObjektNamen().get(0));
                    } else {
                        var8_10 = planetensucheObjektPruefer.getObjektNamen().get(0);
                        this.logger.warn("Die Namen '" + var8_10 + "' (" + planetensucheObjektPruefer.getObjektNamen().size() + ") verweisen auf verschiedene Objekte!");
                        this.nichtEingefuegteObjekte.add((String)((Object)var8_10));
                    }
                } else {
                    boolean bl2 = true;
                    if (this.importDialog != null) {
                        if (this.importDialog.objekteHinzufuegen() && !this.importDialog.test()) {
                            this.planetensucheObjektRepository.create(planetensucheObjektPruefer, bl2, this.katalogerkenner);
                        }
                    } else {
                        this.planetensucheObjektRepository.create(planetensucheObjektPruefer, bl2, this.katalogerkenner);
                    }
                    this.erfolgreichGespeicherteObjekte.add(planetensucheObjektPruefer.getObjektNamen().get(0));
                }
            } else {
                this.uebersprungeneObjekte.add(list.get(0));
            }
        }
        catch (PsObjectMergeException | InvalidCatalogException | IOException | IllegalArgumentException | SQLException exception) {
            this.logger.error(exception);
            this.nichtEingefuegteObjekte.add(planetensucheObjektPruefer.getObjektNamen().get(0));
        }
    }

    private int count(List<List<Element>> list) {
        int n = 0;
        for (List<Element> list2 : list) {
            n += list2.size();
        }
        return n;
    }
}

