/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.importierer.xml;

import com.querydsl.core.QueryException;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.importierer.xml.PsObjektInputDto;
import de.planetensuche.datenbank.importierer.xml.elemente.ElementCommand;
import de.planetensuche.datenbank.importierer.xml.elemente.ElementCommandLocator;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class PsObjektTransformer {
    private final ILogging logging;
    private final ElementCommandLocator commandLocator;
    private final PlanetensucheObjektPrueferDAO daoHigh;
    private final IObjektnamenRepository objektnamenRepository;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final ITimestampDAO timestampDAO;
    private final IDAOhighService daoHighService;

    private PsObjektTransformer() {
        this.logging = null;
        this.commandLocator = null;
        this.daoHigh = null;
        this.objektnamenRepository = null;
        this.planetensucheObjektRepository = null;
        this.entdeckungsmethodenRepository = null;
        this.timestampDAO = null;
        this.daoHighService = null;
    }

    public PsObjektTransformer(ElementCommandLocator elementCommandLocator, PlanetensucheObjektPrueferDAO planetensucheObjektPrueferDAO, IObjektnamenRepository iObjektnamenRepository, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository, ITimestampDAO iTimestampDAO, IDAOhighService iDAOhighService) {
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.commandLocator = elementCommandLocator;
        this.daoHigh = planetensucheObjektPrueferDAO;
        this.objektnamenRepository = iObjektnamenRepository;
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.timestampDAO = iTimestampDAO;
        this.daoHighService = iDAOhighService;
        if (this.daoHighService == null) {
            throw new IllegalArgumentException("daoHighService ist null");
        }
    }

    public PsObjektInputDto transformPsObjekt(Element element, boolean bl, boolean bl2) {
        List<Element> list = element.getChildren();
        PlanetensucheObjektPruefer planetensucheObjektPruefer = new PlanetensucheObjektPruefer(this.daoHigh);
        PsObjektInputDto psObjektInputDto = new PsObjektInputDto();
        boolean bl3 = false;
        try {
            for (Element element2 : list) {
                Object object;
                if ("name".equals(element2.getName())) {
                    String string;
                    Integer n;
                    psObjektInputDto.getNamen().add(element2.getValue());
                    if (!bl3 && bl && (n = this.objektnamenRepository.getIDFuerNamen(string = psObjektInputDto.getNamen().get(psObjektInputDto.getNamen().size() - 1), true)) != null) {
                        object = this.planetensucheObjektRepository.read(n);
                        planetensucheObjektPruefer = new PlanetensucheObjektPruefer(this.daoHigh, (IPlanetensucheObjekt)object);
                    }
                } else if ("entdecker".equals(element2.getName())) {
                    psObjektInputDto.getEntdecker().add(element2.getValue());
                } else if ("referenz".equals(element2.getName())) {
                    if ((bl && planetensucheObjektPruefer.getUmkreistObjekt().isEmpty() || !bl) && !planetensucheObjektPruefer.setUmkreistObjekt(element2.getValue())) {
                        psObjektInputDto.setElternObjektName(element2.getValue());
                        psObjektInputDto.setReferenzFehler(true);
                    }
                } else if ("notiz".equals(element2.getName())) {
                    if ((bl && planetensucheObjektPruefer.getNotiz().isEmpty() || !bl) && !psObjektInputDto.isReferenzFehler()) {
                        if (planetensucheObjektPruefer.getObjektNamen().isEmpty()) {
                            planetensucheObjektPruefer.setObjektNamen(new HashSet<String>(psObjektInputDto.getNamen()));
                        }
                        planetensucheObjektPruefer.setNotiz(element2.getValue());
                    }
                } else if ("bilder".equals(element2.getName())) {
                    if (bl && planetensucheObjektPruefer.getBilder().isEmpty() || !bl) {
                        psObjektInputDto.getBilder().add(element2.getValue());
                    }
                } else {
                    ElementCommand elementCommand = this.commandLocator.getCommandForElementName(element2.getName());
                    if (elementCommand != null && (bl && elementCommand.istWertUnbekannt(planetensucheObjektPruefer) || !bl)) {
                        elementCommand.setzteDaten(planetensucheObjektPruefer, element2);
                    }
                }
                boolean bl4 = PsObjektTransformer.isDeepSkyObject(element2);
                boolean bl5 = PsObjektTransformer.isSunSystemObject(element2);
                if (!"planeten".equals(element2.getName()) && !bl5 && !"braune_zwerge".equals(element2.getName()) && !"sterne".equals(element2.getName()) && !bl4) continue;
                object = element2.getName();
                object = ((String)object).toUpperCase();
                ObjektKategorie objektKategorie = this.ermittleKategorie((String)object);
                planetensucheObjektPruefer.setKategorie(objektKategorie.getKategorienName());
                planetensucheObjektPruefer.setObjekttyp(element2.getAttribute("objekttyp").getValue());
                List<Element> list2 = element2.getChildren();
                for (Element element3 : list2) {
                    ElementCommand elementCommand = this.commandLocator.getCommandForElementName(element3.getName());
                    if (elementCommand != null) {
                        elementCommand.setzteDaten(planetensucheObjektPruefer, element3);
                        continue;
                    }
                    if ("entdeckungsmethode".equals(element3.getName())) {
                        if (bl && (!bl || !planetensucheObjektPruefer.isEntdeckungsmethodeUnbekannt())) continue;
                        String string = element3.getAttributeValue("methode");
                        if (bl2 && !this.entdeckungsmethodenRepository.getEntdeckungsmethoden().contains(string)) {
                            this.entdeckungsmethodenRepository.save(string);
                        }
                        planetensucheObjektPruefer.setEntdeckungsmethode(string);
                        continue;
                    }
                    this.logging.error(new IllegalArgumentException("unbekanntes xml-tag '" + element3.getName() + "' unter '" + element2.getName() + "'"));
                }
            }
            this.ermittleObUpdateOderInsert(planetensucheObjektPruefer, psObjektInputDto);
        }
        catch (QueryException | NullPointerException | SQLException exception) {
            this.logging.error("Fehler beim Transformieren der Daten", exception);
        }
        psObjektInputDto.setPsObjekt(planetensucheObjektPruefer);
        return psObjektInputDto;
    }

    private void ermittleObUpdateOderInsert(PlanetensucheObjektPruefer planetensucheObjektPruefer, PsObjektInputDto psObjektInputDto) throws SQLException {
        boolean bl;
        if (Check.isEmpty(psObjektInputDto.getNamen())) {
            throw new IllegalArgumentException("Objekt ohne Bezeichnungen");
        }
        boolean bl2 = false;
        if (planetensucheObjektPruefer.getDatenid() != null) {
            bl2 = true;
        }
        Timestamp timestamp = null;
        boolean bl3 = bl = this.daoHighService.isObjektInDatenbankCache(psObjektInputDto.getNamen()) > 0;
        if (bl2 || bl) {
            String string;
            bl2 = true;
            Iterator<String> iterator = psObjektInputDto.getNamen().iterator();
            while (iterator.hasNext() && (timestamp = this.timestampDAO.getZuletztAktualisiert(string = iterator.next())) == null) {
            }
        }
        psObjektInputDto.setIsInDb(bl2);
        psObjektInputDto.setTs(timestamp);
    }

    private static boolean isSunSystemObject(Element element) {
        return "monde".equals(element.getName()) || "kometen".equals(element.getName()) || "asteroiden".equals(element.getName()) || "meteoriten_und_krater".equals(element.getName());
    }

    private static boolean isDeepSkyObject(Element element) {
        return "sternhaufen".equals(element.getName()) || "galaxien_und_nebel".equals(element.getName()) || "galaxienhaufen".equals(element.getName()) || "sonstiges".equals(element.getName());
    }

    private ObjektKategorie ermittleKategorie(String string) {
        ObjektKategorie objektKategorie = "GALAXIEN_UND_NEBEL".equals(string) ? ObjektKategorie.GALAXIE_NEBEL : ("BRAUNE_ZWERGE".equals(string) ? ObjektKategorie.BR_ZWERGE : ("METEORITEN_UND_KRATER".equals(string) ? ObjektKategorie.METEOR : ObjektKategorie.valueOf(string)));
        return objektKategorie;
    }
}

