/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.kataloge;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.ObjektKategorie;
import javax.validation.constraints.NotNull;

public enum KatalogKategorie {
    EXOPLANETEN("exoplaneten", ObjektKategorie.PLANETEN),
    BRAUNE_ZWERGE("braune_zwerge", ObjektKategorie.BR_ZWERGE),
    STERNE("sterne", ObjektKategorie.STERNE),
    DOPPELSTERNE("doppelsterne", ObjektKategorie.STERNE),
    VERAENDERLICHE("veraenderliche", ObjektKategorie.STERNE),
    GALAXIEN("galaxien", ObjektKategorie.GALAXIE_NEBEL),
    NEBEL("nebel", ObjektKategorie.GALAXIE_NEBEL),
    DEEP_SKY("deep_sky", ObjektKategorie.GALAXIE_NEBEL),
    STERNHAUFEN("sternhaufen", ObjektKategorie.STERNHAUFEN),
    GALAXIENHAUFEN("galaxienhaufen", ObjektKategorie.GALAXIENHAUFEN),
    DUNKELNEBEL("dunkelnebel", ObjektKategorie.SONSTIGES),
    ASTEROIDEN("asteroiden", ObjektKategorie.ASTEROIDEN),
    ALLES("alles", null);

    private final String kategorieName;
    private final ObjektKategorie objektKategorie;

    private KatalogKategorie(String string2, ObjektKategorie objektKategorie) {
        this.kategorieName = string2;
        this.objektKategorie = objektKategorie;
    }

    public static KatalogKategorie parse(@NotNull String string) {
        if (Check.isEmpty(string)) {
            throw new IllegalArgumentException("kategorie is null");
        }
        for (KatalogKategorie katalogKategorie : KatalogKategorie.values()) {
            if (!katalogKategorie.getKategorieName().equals(string)) continue;
            return katalogKategorie;
        }
        throw new IllegalArgumentException("the category '" + string + "' is unknown");
    }

    public ObjektKategorie getObjektKategorie() {
        return this.objektKategorie;
    }

    public String getKategorieName() {
        return this.kategorieName;
    }
}

