/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.kataloge;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.CatalogNames;
import de.planetensuche.datenbank.KatalogService;
import de.planetensuche.datenbank.kataloge.KnownCatalogDetectorService;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenKlassifiziererService;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public final class Katalogerkenner
implements ObjektnamenKlassifiziererService,
KnownCatalogDetectorService {
    private final List<String> trenner = Arrays.asList(" ", "\\+", "-");
    private final BiMap<String, Pattern> catalogNameAndPattern = HashBiMap.create();

    public Katalogerkenner() throws IOException {
        this.leseKatalogdatei();
    }

    private void leseKatalogdatei() throws IOException {
        List<String> list = new KatalogService().ladeKatalogDatei();
        for (String string : list) {
            String[] stringArray = string.split(",");
            if (stringArray == null || stringArray.length <= 4) continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 4; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                if (i + 1 >= stringArray.length) continue;
                stringBuilder.append(",");
            }
            String string2 = stringBuilder.toString();
            Pattern pattern = Pattern.compile(string2);
            String string3 = stringArray[0];
            this.catalogNameAndPattern.put(string3, pattern);
        }
    }

    @Override
    public boolean isBayerFlamsteedGcvs2(String string) {
        return this.isBayerName(string) || this.isFlamesteedName(string) || this.matchCatalogPattern("GCVS2", string);
    }

    public String getKatalogNameFromObjectName(String string) {
        for (String optional2 : this.trenner) {
            String[] stringArray = string.split(optional2);
            if (stringArray == null || stringArray.length <= 1) continue;
            Object object = null;
            Pattern pattern = (Pattern)this.catalogNameAndPattern.get(stringArray[0]);
            if (pattern != null && pattern.matcher(string).matches()) {
                object = stringArray[0];
            } else if (pattern == null && stringArray.length > 2 || string.startsWith("Gaia ")) {
                var7_8 = stringArray[0] + " " + stringArray[1];
                pattern = (Pattern)this.catalogNameAndPattern.get(var7_8);
                if (pattern != null && pattern.matcher(string).matches()) {
                    object = var7_8;
                }
            } else if ("IC".equals(stringArray[0]) && stringArray.length > 2) {
                var7_8 = "IC-Stars";
                object = ((Pattern)this.catalogNameAndPattern.get(var7_8)).matcher(string).matches() ? var7_8 : null;
            } else if ("NGC".equals(stringArray[0])) {
                var7_8 = switch (stringArray.length) {
                    case 2 -> "NGC";
                    case 3, 4 -> "NGC-Stars";
                    case 5 -> stringArray[0] + " " + stringArray[1] + " " + stringArray[2];
                    default -> "NGC";
                };
                Pattern pattern2 = (Pattern)this.catalogNameAndPattern.get(var7_8);
                object = pattern2 != null && pattern2.matcher(string).matches() ? var7_8 : null;
            } else if ("Mel".equals(stringArray[0]) && stringArray.length > 2) {
                var7_8 = "Mel Cl";
                object = ((Pattern)this.catalogNameAndPattern.get(var7_8)).matcher(string).matches() ? var7_8 : null;
            } else if (("Cr".equalsIgnoreCase(stringArray[0]) || "Collinder".equals(stringArray[0])) && stringArray.length > 2) {
                var7_8 = "Cr Cl";
                object = ((Pattern)this.catalogNameAndPattern.get(var7_8)).matcher(string).matches() ? var7_8 : null;
            } else if (("Tr".equals(stringArray[0]) || "Trumpler".equals(stringArray[0])) && stringArray.length > 2) {
                var7_8 = "Tr-sterne";
                object = ((Pattern)this.catalogNameAndPattern.get(var7_8)).matcher(string).matches() ? var7_8 : null;
            } else if (("ST".equals(stringArray[0]) || "Stock".equals(stringArray[0])) && stringArray.length > 2) {
                var7_8 = "Stock-stars";
                Object object2 = object = ((Pattern)this.catalogNameAndPattern.get(var7_8)).matcher(string).matches() ? var7_8 : null;
            }
            if (object == null) continue;
            return object;
        }
        Optional<String> optional3 = this.checkSpecialCases(string);
        if (optional3.isPresent()) {
            return (String)optional3.get();
        }
        Optional<String> optional = this.catalogNameAndPattern.keySet().parallelStream().filter(string2 -> string.startsWith(string2 + " ") || string.startsWith(string2 + "-") || string.startsWith(string2 + "+")).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    private Optional<String> checkSpecialCases(String string) {
        if (this.isBayerName(string)) {
            return Optional.of("Bayer");
        }
        if (this.isFlamesteedName(string)) {
            return Optional.of("Flamesteed");
        }
        if (this.matchCatalogPattern("GCVS2", string)) {
            return Optional.of("GCVS2");
        }
        if (this.matchCatalogPattern("GCVS", string)) {
            return Optional.of("GCVS");
        }
        if (this.matchCatalogPattern("PH", string)) {
            return Optional.of("PH");
        }
        return Optional.empty();
    }

    public boolean isPatternAvailable(String string) {
        return this.catalogNameAndPattern.get(string) != null;
    }

    public boolean matchCatalogPattern(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return false;
        }
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get(string);
        if (pattern == null) {
            throw new IllegalArgumentException("no catalog regEx found for catalog name '" + string + "'");
        }
        return pattern.matcher(string2).matches();
    }

    String getPatternForCatalogName(String string) {
        return ((Pattern)this.catalogNameAndPattern.get(string)).pattern();
    }

    @Override
    public boolean isKnownCatalog(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        String string2 = this.getKatalogNameFromObjectName(string);
        if (Check.isEmpty(string2)) {
            return false;
        }
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get(string2);
        if (pattern == null) {
            return false;
        }
        boolean bl = pattern.matcher(string).matches();
        return bl;
    }

    @Override
    public boolean isCommonName(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("Eigenname");
        boolean bl = pattern.matcher(string).matches();
        return bl;
    }

    public boolean isBayerName(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("Bayer");
        boolean bl = pattern.matcher(string).matches();
        return bl;
    }

    public boolean isFlamesteedName(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("Flamesteed");
        boolean bl = pattern.matcher(string).matches();
        return bl;
    }

    public boolean isCommonCatalog(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("HR");
        Pattern pattern2 = (Pattern)this.catalogNameAndPattern.get("HD");
        Pattern pattern3 = (Pattern)this.catalogNameAndPattern.get("HIP");
        Pattern pattern4 = (Pattern)this.catalogNameAndPattern.get("SAO");
        boolean bl = this.isBonnerDurchmusterung(string) || this.isCoboraDurchmusterung(string) || this.isCapePhotographicDurchmusterungKatalog(string);
        boolean bl2 = this.isBayerName(string) || this.isFlamesteedName(string);
        boolean bl3 = bl2 || bl || pattern2.matcher(string).matches() || pattern3.matcher(string).matches() || pattern.matcher(string).matches() || pattern4.matcher(string).matches();
        return bl3;
    }

    public boolean isHenryDraperCatalogue(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("HD");
        return pattern.matcher(string).matches();
    }

    public boolean isHipparcosCatalogue(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("HIP");
        return pattern.matcher(string).matches();
    }

    public boolean isHarvardCatalogue(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("HR");
        return pattern.matcher(string).matches();
    }

    public boolean isBonnerDurchmusterung(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("BD");
        return pattern.matcher(string).matches();
    }

    public boolean isCoboraDurchmusterung(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("CD");
        return pattern.matcher(string).matches();
    }

    public boolean isDurchmusterungsKatalog(String string) {
        return this.isBonnerDurchmusterung(string) || this.isCoboraDurchmusterung(string) || this.isCapePhotographicDurchmusterungKatalog(string);
    }

    public boolean isGlieseJahreissKatalog(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("GJ");
        return pattern.matcher(string).matches();
    }

    public boolean isGlieseKatalog(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("Gl");
        return pattern.matcher(string).matches();
    }

    public boolean isGiclasDwarfKatalog(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("GD");
        return pattern.matcher(string).matches();
    }

    public boolean isCapePhotographicDurchmusterungKatalog(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("CPD");
        return pattern.matcher(string).matches();
    }

    public boolean isTwoMicronAllSkySurvey(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("2MASS");
        return pattern.matcher(string).matches();
    }

    public boolean isMicrolensingObservationsInAstrophysics(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("MOA");
        return pattern.matcher(string).matches();
    }

    public boolean isOpticalGravitationalLensingExperiment(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("OGLE");
        return pattern.matcher(string).matches();
    }

    public boolean isKeplerAnyCatalog(String string) {
        return this.isKeplerNameCatalog(string) || this.isKeplerObjectOfInterest(string) || this.isKeplerInputCatalog(string) || this.isKepler2Project(string);
    }

    public boolean isExoplanetTransitProject(String string) {
        return this.isExoplanetTransitProjectGroundBase(string) || this.isExoplanetTransitProjectSpace(string);
    }

    public boolean isExoplanetTransitProjectSpace(String string) {
        boolean bl = this.isSagittariusWindowEclipsingExtrasolarPlanetSearch(string) || this.isKeplerAnyCatalog(string) || this.isConvectionRotationAndPlanetaryTransitsCatalog(string) || this.isTess(string) || this.isPhProject(string);
        return bl;
    }

    public boolean isExoplanetTransitProjectGroundBase(String string) {
        boolean bl = this.isWideAreaSearchForPlanets(string) || this.isKilodegreeExtremelyLittleTelescopeProject(string) || this.isKpsOrGpx(string);
        return bl;
    }

    public boolean isKpsOrGpx(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("KPS");
        Pattern pattern2 = (Pattern)this.catalogNameAndPattern.get("GPX");
        return pattern.matcher(string).matches() || pattern2.matcher(string).matches();
    }

    public boolean isTess(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("TOI");
        return pattern.matcher(string).matches();
    }

    public boolean isWideAreaSearchForPlanets(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("WASP");
        return pattern.matcher(string).matches();
    }

    public boolean isConvectionRotationAndPlanetaryTransitsCatalog(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("CoRoT");
        return pattern.matcher(string).matches();
    }

    public boolean isKeplerNameCatalog(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("Kepler");
        return pattern.matcher(string).matches();
    }

    public boolean isKeplerInputCatalog(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("KIC");
        return pattern.matcher(string).matches();
    }

    public boolean isKeplerObjectOfInterest(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("KOI");
        return pattern.matcher(string).matches();
    }

    public boolean isKepler2Project(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("K2");
        return pattern.matcher(string).matches();
    }

    public boolean isXoProject(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("XO");
        return pattern.matcher(string).matches();
    }

    public boolean isKilodegreeExtremelyLittleTelescopeProject(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("KELT");
        return pattern.matcher(string).matches();
    }

    public boolean isHungarianAutomatedTelescope(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("HAT-P");
        return pattern.matcher(string).matches();
    }

    public boolean isHungarianAutomatedTelescopeSouth(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("HATS");
        return pattern.matcher(string).matches();
    }

    public boolean isSagittariusWindowEclipsingExtrasolarPlanetSearch(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("SWEEPS");
        return pattern.matcher(string).matches();
    }

    public boolean isTransatlanticExoplanetSurvey(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("TrES");
        return pattern.matcher(string).matches();
    }

    public boolean isYses(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("YSES");
        return pattern.matcher(string).matches();
    }

    public boolean isExoplanetenProjekt(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        boolean bl = this.isHungarianAutomatedTelescope(string) || this.isHungarianAutomatedTelescopeSouth(string);
        boolean bl2 = this.isExoplanetTransitProject(string) || this.isTransatlanticExoplanetSurvey(string) || this.isXoProject(string) || bl || this.isYses(string);
        return bl2;
    }

    public boolean isVariableStar(String string) {
        for (String string2 : CatalogNames.VARIABLE_STAR_CATALOGS) {
            Pattern pattern = (Pattern)this.catalogNameAndPattern.get(string2.trim());
            if (pattern == null || !pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isMehrfachsternKatalog(String string) {
        for (String string2 : CatalogNames.getAnyDoubleStarCatalog()) {
            Pattern pattern = (Pattern)this.catalogNameAndPattern.get(string2.trim());
            if (pattern == null || !pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isPhProject(String string) {
        Pattern pattern = (Pattern)this.catalogNameAndPattern.get("PH");
        return pattern.matcher(string).matches();
    }
}

