/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.menuekataloge;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbank.menuekataloge.KatalogdatenTo;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.StatusfensterHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class KatalogZaehlerService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public void ermittle(Observer observer, List<String> list, Map<String, String> map, IDatenbankverbinder iDatenbankverbinder, Katalogerkenner katalogerkenner, StatusfensterHandler statusfensterHandler) {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        ConcurrentHashMap<String, AtomicInteger> concurrentHashMap2 = new ConcurrentHashMap<String, AtomicInteger>();
        KatalogdatenTo katalogdatenTo = new KatalogdatenTo();
        list.forEach(string -> {
            concurrentHashMap2.put((String)string, new AtomicInteger());
            concurrentHashMap.putIfAbsent(string, "");
        });
        list.remove("Bayer");
        list.remove("Flamesteed");
        list.remove("GCVS2");
        list.remove("HD");
        list.add(0, "HD");
        list.remove("HIP");
        list.add(1, "HIP");
        list.remove("BD");
        list.add(2, "BD");
        list.remove("SAO");
        list.add(3, "SAO");
        list.remove("PPM");
        list.add(4, "PPM");
        list.remove("Gaia DR2");
        list.add(5, "Gaia DR2");
        list.remove("TIC");
        list.add(6, "TIC");
        list.remove("Eigenname");
        AtomicInteger atomicInteger2 = new AtomicInteger();
        QNamen qNamen = QNamen.namen1;
        List list2 = ((SQLQuery)((SQLQuery)iDatenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).where(qNamen.isbayerflamsteedgcvs2.isTrue())).fetch();
        list2.parallelStream().forEach(string -> {
            if (katalogerkenner.isBayerName((String)string)) {
                this.addExampleIfMissing(concurrentHashMap, "Bayer", true, (String)string);
                AtomicInteger atomicInteger = (AtomicInteger)concurrentHashMap2.get("Bayer");
                atomicInteger.incrementAndGet();
            } else if (katalogerkenner.isFlamesteedName((String)string)) {
                this.addExampleIfMissing(concurrentHashMap, "Flamesteed", true, (String)string);
                AtomicInteger atomicInteger = (AtomicInteger)concurrentHashMap2.get("Flamesteed");
                atomicInteger.incrementAndGet();
            } else {
                this.addExampleIfMissing(concurrentHashMap, "GCVS2", true, (String)string);
                AtomicInteger atomicInteger = (AtomicInteger)concurrentHashMap2.get("GCVS2");
                atomicInteger.incrementAndGet();
            }
        });
        AtomicInteger atomicInteger3 = new AtomicInteger(0);
        ArrayList arrayList = new ArrayList();
        List list3 = ((SQLQuery)((SQLQuery)iDatenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).where(qNamen.isbayerflamsteedgcvs2.isFalse())).fetch();
        list3.parallelStream().forEach(string -> {
            boolean bl = false;
            for (String string2 : list) {
                bl = katalogerkenner.isPatternAvailable(string2) ? katalogerkenner.matchCatalogPattern(string2, (String)string) : string.startsWith(string2 + " ") || string.startsWith(string2 + "-") || string.startsWith(string2 + "+");
                this.addExampleIfMissing(concurrentHashMap, string2, bl, (String)string);
                if (!bl) continue;
                AtomicInteger atomicInteger3 = (AtomicInteger)concurrentHashMap2.get(string2);
                atomicInteger3.incrementAndGet();
                break;
            }
            if (!bl) {
                if (katalogerkenner.isCommonName((String)string)) {
                    AtomicInteger atomicInteger4 = (AtomicInteger)concurrentHashMap2.get("Eigenname");
                    atomicInteger4.incrementAndGet();
                    if (Check.isEmpty(concurrentHashMap.get("Eigenname"))) {
                        concurrentHashMap.put("Eigenname", string);
                    }
                } else {
                    if (katalogerkenner.isBayerFlamsteedGcvs2((String)string)) {
                        this.logger.warn("object '" + string + "' is a bayer/flamsteed/gcvs2 but is not flagged in DB");
                    } else {
                        arrayList.add(string);
                    }
                    atomicInteger3.incrementAndGet();
                }
            }
            int n = (int)((double)atomicInteger2.addAndGet(1) * 100.0 / (double)(list3.size() + list2.size()));
            if (statusfensterHandler.getProgress() != n) {
                statusfensterHandler.setProgress(n);
            }
        });
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            this.logger.debug("unbekannte objektbezeichnung konnte keinem katalog zugeordnet werden und ist auch kein eigenenname: " + string2);
        }
        this.logger.info("number of not recognized object names that will be ignored: " + atomicInteger3.get());
        katalogdatenTo.getBeispielFuerAbk().putAll(concurrentHashMap);
        concurrentHashMap2.forEach((string, atomicInteger) -> katalogdatenTo.getAnzahlFuerAbk().put((String)string, atomicInteger.get()));
        observer.update(null, katalogdatenTo);
    }

    private void addExampleIfMissing(ConcurrentHashMap<String, String> concurrentHashMap, String string, boolean bl, String string2) {
        boolean bl2 = Check.isFilled(concurrentHashMap.get(string));
        if (!bl2 && bl) {
            concurrentHashMap.put(string, string2);
        }
    }
}

