/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.menuekataloge;

import com.google.inject.Injector;
import de.planetensuche.core.Check;
import de.planetensuche.datenbank.KatalogService;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.kataloge.KatalogKategorie;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbank.menuekataloge.KatalogZaehlerService;
import de.planetensuche.datenbank.menuekataloge.KatalogdatenTo;
import de.planetensuche.datenbank.menuekataloge.KatalogeUebersichtDialog;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.StatusfensterHandler;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;

public final class KatalogeControler
implements Observer {
    private final ILogging logging;
    private final ISprachcontainer i18n;
    private KatalogeUebersichtDialog dialog;
    private final ParameterDto param;
    private StatusfensterHandler statusFenster;
    private final Map<String, String> beschreibungZuKatalogAbkuerzung;
    private final Map<String, String> katalogbeispielZuAbkuerzung;
    private final Map<String, KatalogKategorie> kategorieZuAbkuerzung;
    private List<List<String>> allLinesAndColumns;
    private int numberOfLinesWithExamples = 0;
    private final Katalogerkenner katalogerkennerService;
    private final IDatenbankverbinder datenbankverbinder;

    public KatalogeControler(ParameterDto parameterDto, Injector injector, Katalogerkenner katalogerkenner) {
        this.param = parameterDto;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.i18n = this.param.getSprache();
        this.beschreibungZuKatalogAbkuerzung = new LinkedHashMap<String, String>();
        this.katalogbeispielZuAbkuerzung = new HashMap<String, String>();
        this.kategorieZuAbkuerzung = new HashMap<String, KatalogKategorie>();
        this.datenbankverbinder = injector.getInstance(IDatenbankverbinder.class);
        this.katalogerkennerService = katalogerkenner;
    }

    public void showDialog(JFrame jFrame) {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            return;
        }
        this.ladeKatalogeUndDaten(jFrame);
    }

    @Override
    public void update(Observable observable, Object object) {
        KatalogdatenTo katalogdatenTo = (KatalogdatenTo)object;
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>(this.beschreibungZuKatalogAbkuerzung.keySet());
        for (String string : arrayList2) {
            List<String> list = this.erzeugeZeile(string, katalogdatenTo);
            arrayList.add(list);
        }
        this.statusFenster.stopAnimation();
        if (this.allLinesAndColumns == null) {
            this.allLinesAndColumns = arrayList;
        }
        this.dialog = new KatalogeUebersichtDialog();
        this.dialog.zeigeKataloge(this.allLinesAndColumns, this.numberOfLinesWithExamples);
        this.dialog.getSearchTextField().addActionListener(actionEvent -> {
            String string = this.dialog.getSearchTextField().getText();
            this.filterEintraegeNachSuche(string);
        });
    }

    private void filterEintraegeNachSuche(String string) {
        if (Check.isEmpty(string) || string.equals(this.i18n.getString("db_gui92"))) {
            this.dialog.zeigeKataloge(this.allLinesAndColumns, this.numberOfLinesWithExamples);
        } else {
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
            this.allLinesAndColumns.forEach(list2 -> {
                String string2 = (String)list2.get(0);
                String string3 = (String)list2.get(1);
                String string4 = (String)list2.get(2);
                String string5 = string.toLowerCase();
                if (string2.toLowerCase().contains(string5) || string3.toLowerCase().contains(string5) || string4 != null && string4.toLowerCase().contains(string5)) {
                    arrayList.add((List<String>)list2);
                }
            });
            this.dialog.zeigeKataloge(arrayList, this.numberOfLinesWithExamples);
        }
    }

    private List<String> erzeugeZeile(String string, KatalogdatenTo katalogdatenTo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(this.beschreibungZuKatalogAbkuerzung.get(string));
        if (this.kategorieZuAbkuerzung.get(string) != null) {
            arrayList.add(this.i18n.getString("db_kategorie_" + this.kategorieZuAbkuerzung.get(string).getKategorieName()));
        } else {
            arrayList.add("");
        }
        String string2 = katalogdatenTo.getBeispielFuerAbk().get(string);
        if (!"".equals(string2)) {
            ++this.numberOfLinesWithExamples;
        }
        arrayList.add(string2);
        arrayList.add(this.i18n.toLocalisedInt(katalogdatenTo.getAnzahlFuerAbk().get(string)));
        return arrayList;
    }

    private void ladeKatalogeUndDaten(JFrame jFrame) {
        this.statusFenster = new StatusfensterHandler(jFrame, "Kataloge laden...");
        this.statusFenster.startAnimation();
        try {
            this.leseKatalogdatei();
            ArrayList<String> arrayList = new ArrayList<String>(this.beschreibungZuKatalogAbkuerzung.keySet());
            KatalogZaehlerService katalogZaehlerService = new KatalogZaehlerService();
            KatalogeControler katalogeControler = this;
            Runnable runnable = () -> katalogZaehlerService.ermittle(katalogeControler, arrayList, this.katalogbeispielZuAbkuerzung, this.datenbankverbinder, this.katalogerkennerService, this.statusFenster);
            new Thread(runnable).start();
        }
        catch (IOException | RuntimeException exception) {
            this.statusFenster.stopAnimation();
            this.logging.error(exception);
            this.logging.showErrorMessageBox(null, this.i18n.getString("db_f9") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"));
        }
    }

    private void leseKatalogdatei() throws IOException {
        List<String> list = new KatalogService().ladeKatalogDatei();
        for (String string : list) {
            String[] stringArray = string.split(",");
            this.beschreibungZuKatalogAbkuerzung.put(stringArray[0], stringArray[1]);
            if (stringArray.length < 3) continue;
            try {
                if (Check.isFilled(stringArray[2])) {
                    this.kategorieZuAbkuerzung.put(stringArray[0], KatalogKategorie.parse(stringArray[2]));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logging.error("zeile fehlerhaft: '" + string + "'", illegalArgumentException);
            }
            if (stringArray.length < 4 || stringArray[3] == null) continue;
            this.katalogbeispielZuAbkuerzung.put(stringArray[0], stringArray[3]);
        }
    }
}

