/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.menuekataloge;

import de.planetensuche.datenbank.guis.TabellenBasisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public final class KatalogeUebersichtDialog
extends TabellenBasisdialog {
    public KatalogeUebersichtDialog() {
        super(BasisdialogId.DATENBANK_KATALOGE_UEBERSICHT);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        this.searchTextField.setVisible(true);
    }

    public JTextField getSearchTextField() {
        return this.searchTextField;
    }

    void zeigeKataloge(List<List<String>> list, int n) {
        try {
            SwingUtilities.invokeLater(() -> {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(this.getSprachcontainer().getString("db_m261"));
                arrayList.add(this.getSprachcontainer().getString("db_m262"));
                arrayList.add(this.getSprachcontainer().getString("db_m70"));
                arrayList.add(this.getSprachcontainer().getString("db_m263"));
                arrayList.add(this.getSprachcontainer().getString("db_m264"));
                this.setTabellenUeberschriften(arrayList);
                this.setTabellenDaten(list);
                this.setSize(1100, 600);
                this.setTitle(this.getSprachcontainer().getString("db_m265_1") + " " + list.size() + " " + this.getSprachcontainer().getString("db_m265_2") + " " + n + " " + this.getSprachcontainer().getString("db_m265_3"));
                this.setAlwaysOnTop(true);
                super.showDialog();
                this.ausgabe.disableDragColumns();
                this.ausgabe.disableEditMode();
                this.ausgabe.setAutoResizeMode(0);
                this.resizeColumnWidth();
            });
        }
        catch (RuntimeException runtimeException) {
            this.getLogger().error(runtimeException);
            JOptionPane.showMessageDialog(this, this.getSprachcontainer().getString("db_f9") + "\n" + runtimeException.toString(), this.getSprachcontainer().getString("db_f4_titel"), 0);
        }
    }

    public void resizeColumnWidth() {
        int n = this.getWidth() - 20;
        TableColumnModel tableColumnModel = this.ausgabe.getColumnModel();
        for (int i = 0; i < this.ausgabe.getColumnCount(); ++i) {
            int n2 = 120;
            for (int j = 0; j < this.ausgabe.getRowCount(); ++j) {
                TableCellRenderer tableCellRenderer = this.ausgabe.getCellRenderer(j, i);
                Component component = this.ausgabe.prepareRenderer(tableCellRenderer, j, i);
                n2 = Math.max(component.getPreferredSize().width + 1, n2);
            }
            if (n2 > 450) {
                n2 = 450;
            }
            if (n2 < 120) {
                n2 = 120;
            }
            n -= n2;
            tableColumnModel.getColumn(i).setPreferredWidth(n2);
        }
        n = n < 0 ? 0 : n;
        tableColumnModel.getColumn(4).setPreferredWidth(120 + n);
    }
}

