/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtebs;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.IPlanetensucheObjektPruefer;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.gaia.doublestar.GaiaAstrometricDto;
import de.planetensuche.datenbank.tic.VizierTicCatalogDto;
import java.sql.SQLException;
import java.util.Set;

public class DataMapper {
    private final PlanetensucheObjektPrueferDAO psObjectDao;

    public DataMapper(PlanetensucheObjektPrueferDAO planetensucheObjektPrueferDAO) {
        this.psObjectDao = planetensucheObjektPrueferDAO;
    }

    IPlanetensucheObjektPruefer createPlanetensucheObject(Long l, Long l2, VizierTicCatalogDto vizierTicCatalogDto, GaiaAstrometricDto gaiaAstrometricDto) throws SQLException {
        PlanetensucheObjektPruefer planetensucheObjektPruefer = new PlanetensucheObjektPruefer(this.psObjectDao);
        planetensucheObjektPruefer.setCategory(ObjektKategorie.STERNE);
        planetensucheObjektPruefer.setObjekttyp(StarObjectType.ECLIPSING_BINARY_CANDIDATE.getTypeName());
        planetensucheObjektPruefer.setAutor("TIC & Gaia catalog");
        planetensucheObjektPruefer.setObjektNamen(Set.of("TIC " + l));
        if (l2 != null && l2 > 0L) {
            planetensucheObjektPruefer.getObjektNamen().add("Gaia DR2 " + l2);
        }
        if (vizierTicCatalogDto.getKicId() != null) {
            planetensucheObjektPruefer.getObjektNamen().add("KIC " + vizierTicCatalogDto.getKicId());
        }
        if (vizierTicCatalogDto.getTwoMassId() != null) {
            planetensucheObjektPruefer.getObjektNamen().add("2MASS " + vizierTicCatalogDto.getTwoMassId());
        }
        if (vizierTicCatalogDto.getDeclJ2000() != null && vizierTicCatalogDto.getRaJ2000() != null) {
            planetensucheObjektPruefer.setRA(vizierTicCatalogDto.getRaJ2000());
            planetensucheObjektPruefer.setDECL(vizierTicCatalogDto.getDeclJ2000());
        }
        if (vizierTicCatalogDto.getDistanceInPc() != null) {
            planetensucheObjektPruefer.setEntfernung(vizierTicCatalogDto.getDistanceInPc() * 3.2616);
        }
        if (vizierTicCatalogDto.getVmag() != null) {
            planetensucheObjektPruefer.setScheinbareHelligkeit(vizierTicCatalogDto.getVmag());
            if (vizierTicCatalogDto.getBmag() != null) {
                planetensucheObjektPruefer.setBV(vizierTicCatalogDto.getBmag() - planetensucheObjektPruefer.getScheinbareHelligkeit());
            }
        }
        if (vizierTicCatalogDto.getRadius() != null) {
            planetensucheObjektPruefer.setDurchmesser(vizierTicCatalogDto.getRadius());
        }
        if (vizierTicCatalogDto.getTemperatureInKelvin() != null) {
            planetensucheObjektPruefer.setTemperatur(vizierTicCatalogDto.getTemperatureInKelvin());
        }
        if (gaiaAstrometricDto != null) {
            this.setGaiaDataOnPsObject(planetensucheObjektPruefer, gaiaAstrometricDto);
        }
        return planetensucheObjektPruefer;
    }

    void setGaiaDataOnPsObject(IPlanetensucheObjekt iPlanetensucheObjekt, GaiaAstrometricDto gaiaAstrometricDto) {
        iPlanetensucheObjekt.setGaiaNonSingle(gaiaAstrometricDto.getNonSingleStarType());
        if (gaiaAstrometricDto.getAstrometricExcessNoiseSignificance() != null) {
            iPlanetensucheObjekt.setGaiaAstroExNoiseSig(gaiaAstrometricDto.getAstrometricExcessNoiseSignificance());
        }
        if (gaiaAstrometricDto.getRuwe() != null) {
            iPlanetensucheObjekt.setGaiaRuwe(gaiaAstrometricDto.getRuwe());
        }
        if (gaiaAstrometricDto.getRvErrorInMeterPerSeconds() != null) {
            iPlanetensucheObjekt.setGaiaRvError(gaiaAstrometricDto.getRvErrorInMeterPerSeconds() / 1000.0);
        }
        if (gaiaAstrometricDto.getRvInMeterPerSeconds() != null) {
            iPlanetensucheObjekt.setGeschwindigkeit(gaiaAstrometricDto.getRvInMeterPerSeconds() / 1000.0);
        }
    }
}

