/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtebs;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbank.doublestar.queries.EclipsingBinaryCatalogDto;
import de.planetensuche.datenbank.doublestar.queries.KeltFalsePositiveDto;
import de.planetensuche.datenbank.doublestar.queries.KeplerEbCatalogService;
import de.planetensuche.datenbank.doublestar.queries.SesameResponseDto;
import de.planetensuche.datenbank.doublestar.queries.SesameService;
import de.planetensuche.datenbank.doublestar.queries.SuperWaspFalsePositiveDto;
import de.planetensuche.datenbank.doublestar.queries.VizierGalahSurveySb2Service;
import de.planetensuche.datenbank.doublestar.queries.VizierKeltFalsePositiveService;
import de.planetensuche.datenbank.doublestar.queries.VizierSuperWaspFalsePositiveService;
import de.planetensuche.datenbank.doublestar.queries.VizierTessOBAtypeEbCatalogService;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.BedeckungsveraenderlicherKandidatMapper;
import de.planetensuche.datenbank.importierer.tsvimport.commands.rest.simbad.BedeckungsveraenderlicherMapper;
import de.planetensuche.datenbank.vsx.AavsoDatabaseApiClient;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.net.UnknownHostException;
import java.util.Optional;

public class EbCatalogEntryFinder {
    private final VizierTessOBAtypeEbCatalogService tessEbCatalogService;
    private final VizierSuperWaspFalsePositiveService superwaspService;
    private final VizierKeltFalsePositiveService keltService;
    private final VizierGalahSurveySb2Service galahService;
    private final AavsoDatabaseApiClient aavsoService;
    private final KeplerEbCatalogService keplerService;
    private final SesameService sesameService;
    private final BedeckungsveraenderlicherMapper simbadEbTypeMapper;
    private final BedeckungsveraenderlicherKandidatMapper simbadEbCandidateTypeMapper;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public EbCatalogEntryFinder() {
        this.tessEbCatalogService = new VizierTessOBAtypeEbCatalogService();
        this.superwaspService = new VizierSuperWaspFalsePositiveService();
        this.keltService = new VizierKeltFalsePositiveService();
        this.galahService = new VizierGalahSurveySb2Service();
        this.aavsoService = new AavsoDatabaseApiClient();
        this.keplerService = new KeplerEbCatalogService();
        this.sesameService = new SesameService();
        this.simbadEbTypeMapper = new BedeckungsveraenderlicherMapper();
        this.simbadEbCandidateTypeMapper = new BedeckungsveraenderlicherKandidatMapper();
    }

    public Optional<String> findEbCatalogNameForTic(long l, long l2, long l3, String string, double d, double d2) {
        Object object;
        long l4 = System.currentTimeMillis();
        Optional<EclipsingBinaryCatalogDto> optional = this.tessEbCatalogService.query("" + l);
        this.logger.debug("duration of TESS EB query: " + (System.currentTimeMillis() - l4) + "ms");
        if (optional.isPresent()) {
            return Optional.of("TESS OBA-type EBs");
        }
        l4 = System.currentTimeMillis();
        Optional<SuperWaspFalsePositiveDto> optional2 = this.superwaspService.querySuperWasp(l);
        this.logger.debug("duration of SuperWASP query: " + (System.currentTimeMillis() - l4) + "ms");
        if (optional2.isPresent()) {
            return Optional.of("SuperWASP FP catalog");
        }
        l4 = System.currentTimeMillis();
        Optional<KeltFalsePositiveDto> optional3 = this.keltService.query("" + l);
        this.logger.debug("duration of KELT query: " + (System.currentTimeMillis() - l4) + "ms");
        if (optional3.isPresent()) {
            return Optional.of("KELT transit FP catalog");
        }
        if (l2 > 0L) {
            l4 = System.currentTimeMillis();
            object = this.galahService.query("Gaia DR2 " + l2);
            this.logger.debug("duration of GALAH query: " + (System.currentTimeMillis() - l4) + "ms");
            if (((Optional)object).isPresent()) {
                return Optional.of("GALAH survey FGK binaries");
            }
        }
        if (Check.isFilled(string)) {
            l4 = System.currentTimeMillis();
            object = this.keplerService.findEntry(string);
            this.logger.debug("duration of Kepler query: " + (System.currentTimeMillis() - l4) + "ms");
            if (object != null && ((EclipsingBinaryCatalogDto)object).getEntryStatus() == IconPoolCustom.AMPEL_GRUEN) {
                return Optional.of("Kepler EB catalog");
            }
        }
        double d3 = d * 360.0 / 24.0;
        l4 = System.currentTimeMillis();
        Optional<StarObjectType> optional4 = this.aavsoService.fetchObjectType(l, d3, d2, l3);
        this.logger.debug("duration of AAVSO/VSX query: " + (System.currentTimeMillis() - l4) + "ms");
        if (optional4.isPresent() && StarObjectType.ECLIPSING_BINARY.equals((Object)optional4.get())) {
            return Optional.of("AAVSO/VSX database (as EB)");
        }
        try {
            String string2;
            l4 = System.currentTimeMillis();
            Optional<SesameResponseDto> optional5 = this.sesameService.querySesame("TIC " + l);
            this.logger.debug("duration of Sesame query: " + (System.currentTimeMillis() - l4) + "ms");
            if (optional5.isPresent() && (string2 = optional5.get().getSimbadObjectTypeShort()) != null && (this.simbadEbTypeMapper.istZustaendig(string2) || this.simbadEbCandidateTypeMapper.istZustaendig(string2))) {
                return Optional.of("Simbad database (as EB)");
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

