/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtebs;

import de.planetensuche.datamodel.api.GaiaNonSingleStar;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.phtebs.TicTceNebDetector;
import de.planetensuche.datenbankkern.api.repos.IPhtEbCandidatesRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.PhtEbCandidateAutoValidStatus;
import de.planetensuche.datenbankkern.querydsl5.PhtEbCandidateTce;
import java.sql.SQLException;
import java.util.Optional;

public class EbGaiaDataClassifier {
    private static final int TAG_COUNT_THRESHOLD = 1;
    private final IPlanetensucheObjektRepository psRepo;
    private final IPhtEbCandidatesRepository phtRepo;
    private final TicTceNebDetector ticTceNebDetector;

    public EbGaiaDataClassifier(IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IPhtEbCandidatesRepository iPhtEbCandidatesRepository) {
        this.psRepo = iPlanetensucheObjektRepository;
        this.phtRepo = iPhtEbCandidatesRepository;
        this.ticTceNebDetector = new TicTceNebDetector();
    }

    public Optional<PhtEbCandidateAutoValidStatus> isProbablyEclipsingBinary(long l) {
        try {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.psRepo.read("TIC " + l);
            PhtEbCandidateTce phtEbCandidateTce = this.phtRepo.getTceForTic(l);
            int n = this.phtRepo.getEbTagCountForTicId(l);
            return Optional.ofNullable(this.isProbablyEclipsingBinary(iPlanetensucheObjekt, phtEbCandidateTce, n));
        }
        catch (IllegalArgumentException | SQLException exception) {
            return Optional.empty();
        }
    }

    public PhtEbCandidateAutoValidStatus isProbablyEclipsingBinary(IPlanetensucheObjekt iPlanetensucheObjekt, PhtEbCandidateTce phtEbCandidateTce, int n) {
        if (GaiaNonSingleStar.ECLIPSING_BINARY.equals((Object)iPlanetensucheObjekt.getGaiaNonSingle())) {
            return PhtEbCandidateAutoValidStatus.KNOWN_EB;
        }
        if (this.ticTceNebDetector.isNeb(phtEbCandidateTce, iPlanetensucheObjekt.getScheinbareHelligkeit())) {
            return PhtEbCandidateAutoValidStatus.NEB;
        }
        if (n < 1) {
            return PhtEbCandidateAutoValidStatus.UNLIKELY_EB;
        }
        if (GaiaNonSingleStar.ASTROMETRIC_BINARY.equals((Object)iPlanetensucheObjekt.getGaiaNonSingle()) || GaiaNonSingleStar.SPECTROSCOPIC_BINARY.equals((Object)iPlanetensucheObjekt.getGaiaNonSingle())) {
            return PhtEbCandidateAutoValidStatus.NEW_EB;
        }
        if (iPlanetensucheObjekt.isGaiaAstroExNoiseSigUnbekannt() && iPlanetensucheObjekt.isGaiaRuweUnbekannt() && iPlanetensucheObjekt.isGaiaRvErrorUnbekannt()) {
            return PhtEbCandidateAutoValidStatus.INCOMPLETE_DATA;
        }
        if (!iPlanetensucheObjekt.isGaiaRuweUnbekannt() && iPlanetensucheObjekt.getGaiaRuwe() >= 1.2) {
            return PhtEbCandidateAutoValidStatus.NEW_EB;
        }
        if (!iPlanetensucheObjekt.isGaiaAstroExNoiseSigUnbekannt() && iPlanetensucheObjekt.getGaiaAstroExNoiseSig() >= 2.0) {
            return PhtEbCandidateAutoValidStatus.NEW_EB;
        }
        if (!iPlanetensucheObjekt.isGaiaRvErrorUnbekannt() && iPlanetensucheObjekt.getGaiaRvError() >= 1.5) {
            return PhtEbCandidateAutoValidStatus.NEW_EB;
        }
        return PhtEbCandidateAutoValidStatus.UNLIKELY_EB;
    }
}

