/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtebs;

import de.planetensuche.datenbank.phtebs.EbGaiaDataClassifier;
import de.planetensuche.datenbankkern.api.repos.IPhtEbCandidatesRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.PhtEbCandidateAutoValidStatus;
import de.planetensuche.datenbankkern.api.repos.PhtEbCandidateDto;
import de.planetensuche.datenbankkern.querydsl5.PhtEbCandidateTce;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class HtmlExporter {
    private static final List<Long> NEB_TIC_IDS = List.of(382069441L, 309619055L, 263078716L, 271900960L, 238896431L, 348844154L, 176984236L, 54085154L, 55452495L, 365781372L, 277103955L, 408651399L, 176675077L, 379931600L, 468845640L, 307379977L, 309908721L);
    private static final List<Long> EB_TIC_IDS = List.of(49455964L, 299096355L, 470710327L, 356919658L, 176984248L, 54085149L, 176984241L, 410094645L, 237200747L, 260609205L, 458856474L, 408651394L, 199688472L, 307379994L, 233060434L, 76073981L, 207385593L, 255921197L, 388508344L, 423027012L, 468276605L, 342061072L, 178171080L, 73248090L, 137501278L, 137502446L, 188835620L, 230065962L, 372759279L, 440576881L, 230386397L, 173301640L, 139460937L, 445646082L, 32150630L, 348897766L, 53178352L, 167005326L, 469022819L, 5506314L, 382069435L, 278956474L, 302976834L, 78601408L);
    private static final List<Long> EXOPLANET_TIC_IDS = List.of(219698950L, 27916356L, 386259537L, 273874849L, 189380158L, 147797743L, 53750200L, 112099249L, 389352124L, 392476080L, 376637093L, 151483286L, 335630746L, 172518755L, 254113311L, 348835438L, 439842788L, 14344979L);
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IPhtEbCandidatesRepository phtEbRepo;
    private final EbGaiaDataClassifier ebGaiaDataClassifier;

    public HtmlExporter(IPhtEbCandidatesRepository iPhtEbCandidatesRepository, IPlanetensucheObjektRepository iPlanetensucheObjektRepository) {
        this.phtEbRepo = iPhtEbCandidatesRepository;
        this.ebGaiaDataClassifier = new EbGaiaDataClassifier(iPlanetensucheObjektRepository, iPhtEbCandidatesRepository);
    }

    void exportResultsToHtml() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<html>");
        arrayList.add("<h1>Automated validation of PHT EB tags over all sectors</h1><br><br>");
        arrayList.add("Legend:<br>");
        for (PhtEbCandidateAutoValidStatus phtEbCandidateAutoValidStatus : PhtEbCandidateAutoValidStatus.values()) {
            arrayList.add(phtEbCandidateAutoValidStatus.name() + " = " + phtEbCandidateAutoValidStatus.getDescription() + "<br>");
        }
        arrayList.add("<br><br><br>");
        arrayList.add("<table>");
        arrayList.add("<tr><th>TIC id</th><th>Subject ids for target</th><th>Used tags</th><th>Tags count overall</th><th>Auto validation status</th><th>Found EB in catalog...</th><th>TCE Period(s) in days</th></tr>");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        HashSet<Long> hashSet = new HashSet<Long>();
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        List<PhtEbCandidateDto> list = this.phtEbRepo.findAll();
        for (PhtEbCandidateDto phtEbCandidateDto : list) {
            if (null != phtEbCandidateDto.status()) {
                switch (phtEbCandidateDto.status()) {
                    case KNOWN_EB: {
                        ++n;
                        break;
                    }
                    case NEW_EB: {
                        ++n2;
                        break;
                    }
                    case NEB: {
                        ++n3;
                        break;
                    }
                    case UNLIKELY_EB: 
                    case INCOMPLETE_DATA: {
                        ++n4;
                        break;
                    }
                    default: {
                        this.logger.warn("unsupported type " + String.valueOf((Object)phtEbCandidateDto.status()) + " of TIC " + phtEbCandidateDto.ticId());
                    }
                }
            }
            Object object2 = "[";
            for (Long l : phtEbCandidateDto.subjectIds()) {
                object2 = (String)object2 + "<a href=\"https://www.zooniverse.org/projects/nora-dot-eisner/planet-hunters-tess/talk/subjects/" + l + "\">" + l + "</a>, ";
            }
            object2 = (String)object2 + "]";
            Object object4 = "<tr><td><a href=\"https://exofop.ipac.caltech.edu/tess/target.php?id=" + phtEbCandidateDto.ticId() + "\">" + phtEbCandidateDto.ticId() + "</a></td><td>" + (String)object2 + "</td><td>" + String.valueOf(phtEbCandidateDto.tags()) + "</td><td>" + phtEbCandidateDto.tagsCountOverall() + "</td><td>" + phtEbCandidateDto.status().name() + "</td><td>" + (phtEbCandidateDto.ebCatalogName() != null ? phtEbCandidateDto.ebCatalogName() : "") + "</td>";
            PhtEbCandidateTce object3 = this.phtEbRepo.getTceForTic(phtEbCandidateDto.ticId());
            if (object3 != null) {
                ++n5;
            }
            String string = this.createPeriodString(object3);
            object4 = (String)object4 + "<td>" + string + "</td>";
            object4 = (String)object4 + "</tr>";
            if (phtEbCandidateDto.status() != PhtEbCandidateAutoValidStatus.KNOWN_EB) {
                arrayList.add((String)object4);
            }
            hashSet.add(phtEbCandidateDto.ticId());
            if (phtEbCandidateDto.ebCatalogName() == null) continue;
            hashMap.put(phtEbCandidateDto.ticId(), phtEbCandidateDto.ebCatalogName());
        }
        arrayList.add("</table>");
        arrayList.add("<br><br>");
        this.addStatistics(arrayList, list, n, n2, n3, n4, n5);
        arrayList.add("<br><br>");
        this.addNebExamples(arrayList, hashSet, hashMap);
        arrayList.add("<br><br>");
        this.addEbExamples(arrayList, hashSet, hashMap);
        arrayList.add("<br><br>");
        this.addExoplanetExamples(arrayList, hashSet, hashMap);
        arrayList.add("<br><br>");
        arrayList.add("generated at: " + new Date().toString());
        arrayList.add("</html>");
        File file = new File(new File("").getAbsolutePath() + File.separator + "temp" + File.separator + "pht_eb_candidates.html");
        try {
            FileUtils.writeLines(file, "utf8", arrayList);
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
    }

    private void addStatistics(List<String> list, List<PhtEbCandidateDto> list2, int n, int n2, int n3, int n4, int n5) {
        list.add("stars overall: " + list2.size() + ", known EBs: " + n + " (" + this.formatDoubleAsPercent(n, list2.size()) + "), new EBs: " + n2 + " (" + this.formatDoubleAsPercent(n2, list2.size()) + "), NEBs: " + n3 + " (" + this.formatDoubleAsPercent(n3, list2.size()) + ") , unlikely EBs/incomplete data (check by a human is needed): " + n4 + " (" + this.formatDoubleAsPercent(n4, list2.size()) + ") , stars with TCEs: " + n5 + "<br>");
    }

    String createPeriodString(PhtEbCandidateTce phtEbCandidateTce) {
        if (phtEbCandidateTce == null) {
            return "";
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (phtEbCandidateTce.getPeriod1() != null) {
            arrayList.add(phtEbCandidateTce.getPeriod1());
        }
        if (phtEbCandidateTce.getPeriod2() != null) {
            arrayList.add(phtEbCandidateTce.getPeriod2());
        }
        if (phtEbCandidateTce.getPeriod3() != null) {
            arrayList.add(phtEbCandidateTce.getPeriod3());
        }
        if (phtEbCandidateTce.getPeriod4() != null) {
            arrayList.add(phtEbCandidateTce.getPeriod4());
        }
        if (phtEbCandidateTce.getPeriod5() != null) {
            arrayList.add(phtEbCandidateTce.getPeriod5());
        }
        if (phtEbCandidateTce.getPeriod6() != null) {
            arrayList.add(phtEbCandidateTce.getPeriod6());
        }
        if (arrayList.isEmpty()) {
            return "";
        }
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < arrayList.size(); ++i) {
            Double d = (Double)arrayList.get(i);
            stringBuilder.append(d.toString());
            if (i >= arrayList.size() - 1) continue;
            stringBuilder.append("|");
        }
        String string = stringBuilder.toString();
        return string;
    }

    private void addNebExamples(List<String> list, Set<Long> set, Map<Long, String> map) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        list.add("NEB examples:<br>");
        list.add("<table>");
        this.printHeader(list);
        for (Long l : NEB_TIC_IDS) {
            Optional<PhtEbCandidateAutoValidStatus> optional = this.ebGaiaDataClassifier.isProbablyEclipsingBinary(l);
            if (optional.isPresent()) {
                this.printTicEntry(list, l, optional.get(), map.get(l));
                if (PhtEbCandidateAutoValidStatus.NEW_EB.equals((Object)optional.get())) {
                    ++n;
                    if (set.contains(l)) {
                        ++n2;
                    }
                }
                ++n4;
            }
            if (!map.containsKey(l)) continue;
            ++n3;
        }
        list.add("</table>");
        list.add("false-positive rate for EBs (are NEBs), Gaia+TCE only: " + this.formatDoubleAsPercent(n, n4) + "<br>");
        list.add("false-positive rate for EBs (are NEBs), Gaia+TCE+tags: " + this.formatDoubleAsPercent(n2, n4) + "<br>");
        list.add("false-positive rate for EBs (are NEBs), catalog/databases: " + this.formatDoubleAsPercent(n3, n4) + "<br>");
    }

    private void addEbExamples(List<String> list, Set<Long> set, Map<Long, String> map) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        list.add("TOI exoplanet FP (retired as EB/SB) and manual vetted EB examples:<br>");
        list.add("<table>");
        this.printHeader(list);
        for (Long l : EB_TIC_IDS) {
            Optional<PhtEbCandidateAutoValidStatus> optional = this.ebGaiaDataClassifier.isProbablyEclipsingBinary(l);
            if (optional.isPresent()) {
                this.printTicEntry(list, l, optional.get(), map.get(l));
                if (PhtEbCandidateAutoValidStatus.UNLIKELY_EB.equals((Object)optional.get()) || PhtEbCandidateAutoValidStatus.NEB.equals((Object)optional.get())) {
                    ++n;
                }
                ++n3;
            }
            if (set.contains(l)) continue;
            ++n2;
        }
        list.add("</table>");
        list.add("false-negative rate for EBs, Gaia+TCE only: " + this.formatDoubleAsPercent(n, n3) + "<br>");
        list.add("false-negative rate for EBs, tags only: " + this.formatDoubleAsPercent(n2, n3) + "<br>");
    }

    private void addExoplanetExamples(List<String> list, Set<Long> set, Map<Long, String> map) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        list.add("big exoplanet / with deep eclipse around single star examples:<br>");
        list.add("<table>");
        this.printHeader(list);
        for (Long l : EXOPLANET_TIC_IDS) {
            Optional<PhtEbCandidateAutoValidStatus> optional = this.ebGaiaDataClassifier.isProbablyEclipsingBinary(l);
            if (optional.isPresent()) {
                this.printTicEntry(list, l, optional.get(), map.get(l));
                if (PhtEbCandidateAutoValidStatus.NEW_EB.equals((Object)optional.get())) {
                    ++n;
                    if (set.contains(l)) {
                        ++n2;
                    }
                }
                ++n4;
            }
            if (!map.containsKey(l)) continue;
            ++n3;
        }
        list.add("</table>");
        list.add("false-positive rate for EBs (are exoplanets), Gaia+TCE only: " + this.formatDoubleAsPercent(n, n4) + "<br>");
        list.add("false-positive rate for EBs (are exoplanets), Gaia+TCE+tags: " + this.formatDoubleAsPercent(n2, n4) + "<br>");
        list.add("false-positive rate for EBs (are exoplanets), catalog/databases: " + this.formatDoubleAsPercent(n3, n4) + "<br>");
    }

    private void printHeader(List<String> list) {
        list.add("<tr><th>TIC id</th><th>Auto validation status</th><th>database/catalog</th></tr>");
    }

    private void printTicEntry(List<String> list, long l, PhtEbCandidateAutoValidStatus phtEbCandidateAutoValidStatus, String string) {
        list.add("<tr><td><a href=\"https://exofop.ipac.caltech.edu/tess/target.php?id=" + l + "\">" + l + "</a></td><td>" + (phtEbCandidateAutoValidStatus != null ? phtEbCandidateAutoValidStatus.name() : "not in list") + "</td><td>" + (string != null ? string : "-") + "</td></tr>");
    }

    private String formatDoubleAsPercent(double d, double d2) {
        double d3 = d * 100.0 / d2;
        return Math.round(d3) + "%";
    }
}

