/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtebs;

import com.google.inject.Injector;
import de.planetensuche.datamodel.api.GaiaNonSingleStar;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.IPlanetensucheObjektPruefer;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.gaia.doublestar.GaiaAstrometricDto;
import de.planetensuche.datenbank.gaia.doublestar.GaiaDoubleStarIndicatorService;
import de.planetensuche.datenbank.phtebs.DataMapper;
import de.planetensuche.datenbank.phtebs.EbCatalogEntryFinder;
import de.planetensuche.datenbank.phtebs.EbGaiaDataClassifier;
import de.planetensuche.datenbank.phtebs.HtmlExporter;
import de.planetensuche.datenbank.phtebs.PhtPopularTagsDto;
import de.planetensuche.datenbank.phtebs.TceCsvImporter;
import de.planetensuche.datenbank.phtebs.ZooniverseApiClient;
import de.planetensuche.datenbank.tic.VizierTicCatalogDto;
import de.planetensuche.datenbank.tic.VizierTicCatalogQueryService;
import de.planetensuche.datenbankkern.api.repos.IPhtEbCandidatesRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenKlassifiziererService;
import de.planetensuche.datenbankkern.api.repos.PhtEbCandidateAutoValidStatus;
import de.planetensuche.datenbankkern.querydsl5.PhtEbCandidateTce;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PhtEbCandidateAnalyzer {
    private static final List<String> TAG_NAMES = List.of("eclipsingbinary", "eclipsing_binary", "eccentric-eb", "eccentric_eb", "eccentric-binary", "possibleEB", "possible-eb", "eb_eb", "e_binary", "spectroscopic_eb", "trinary", "tripple", "triple", "triplestar", "triple-star", "quadruple", "quadruplebinary", "quadruple-binary", "quadruple-star");
    private final IPhtEbCandidatesRepository phtEbRepo;
    private final IPlanetensucheObjektRepository psRepo;
    private final ZooniverseApiClient zooniverseClient;
    private final GaiaDoubleStarIndicatorService gaiaService;
    private final VizierTicCatalogQueryService ticCatalogService;
    private final PlanetensucheObjektPrueferDAO psObjectDao;
    private final ObjektnamenKlassifiziererService objektnamenKlassifiziererService;
    private final EbCatalogEntryFinder ebCatalogEntryFinder;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final HtmlExporter htmlExporter;
    private final DataMapper dataMapper;
    private final EbGaiaDataClassifier ebGaiaDataClassifier;
    private final TceCsvImporter tceCsvImporter;

    public PhtEbCandidateAnalyzer(Injector injector) {
        this.phtEbRepo = injector.getInstance(IPhtEbCandidatesRepository.class);
        this.psRepo = injector.getInstance(IPlanetensucheObjektRepository.class);
        this.psObjectDao = injector.getInstance(PlanetensucheObjektPrueferDAO.class);
        this.objektnamenKlassifiziererService = injector.getInstance(ObjektnamenKlassifiziererService.class);
        this.zooniverseClient = new ZooniverseApiClient();
        this.gaiaService = new GaiaDoubleStarIndicatorService();
        this.ticCatalogService = new VizierTicCatalogQueryService();
        this.ebCatalogEntryFinder = new EbCatalogEntryFinder();
        this.htmlExporter = new HtmlExporter(this.phtEbRepo, this.psRepo);
        this.dataMapper = new DataMapper(this.psObjectDao);
        this.ebGaiaDataClassifier = new EbGaiaDataClassifier(this.psRepo, this.phtEbRepo);
        this.tceCsvImporter = new TceCsvImporter(this.phtEbRepo);
    }

    public void analyze(int n) {
        try {
            this.logger.info("start PHT eb candidate analysis");
            this.downloadAndSaveTags(n);
            this.logger.info("finished PHT tags download");
            this.downloadAndSaveGaiaData();
            this.logger.info("finished Gaia data download");
            this.tceCsvImporter.importTceData("/media/veracrypt1/admin/planethunters/tess_dv_fast/data/tess_dv_fast/tess_tcestats.csv");
            this.logger.info("finished TCE data import");
            this.analyzeStars(n);
            this.logger.info("finished analysing stars");
            this.htmlExporter.exportResultsToHtml();
            this.logger.info("finished HTML export");
        }
        catch (IOException | InterruptedException | RuntimeException exception) {
            this.logger.error("limit=" + n, exception);
        }
    }

    private void downloadAndSaveTags(int n) {
        for (String string : TAG_NAMES) {
            try {
                int n2 = this.phtEbRepo.getNextPageForTag(string);
                int n3 = n2 + 1;
                for (int i = 0; n2 <= n3 && i < n; ++i) {
                    List<PhtPopularTagsDto> list = this.zooniverseClient.fetchTagStatistics(string, n2);
                    for (PhtPopularTagsDto phtPopularTagsDto : list) {
                        if (this.phtEbRepo.entryExistsForSubjectAndTag(phtPopularTagsDto.subjectId(), string)) continue;
                        try {
                            Optional<Long> optional = this.zooniverseClient.getTicIdForSubject(phtPopularTagsDto.subjectId());
                            if (!optional.isPresent()) continue;
                            this.phtEbRepo.createEbCandidate(phtPopularTagsDto.subjectId(), optional.get(), string, phtPopularTagsDto.tagCount());
                        }
                        catch (Exception exception) {
                            this.logger.error("error fetch tic id for subject id: " + phtPopularTagsDto.subjectId(), exception);
                        }
                    }
                    this.phtEbRepo.saveProcessedPage(string, n2);
                    n3 = list.isEmpty() ? ++n2 : list.get(0).overallPageCount();
                }
                this.logger.info(n2 - 1 + " of " + n3 + " pages for tag " + string + " processed until now");
            }
            catch (Exception exception) {
                this.logger.error("error fetch tag statistics and subjects for tag name: " + string, exception);
            }
        }
    }

    private void downloadAndSaveGaiaData() throws InterruptedException {
        List<Long> list = this.phtEbRepo.findMissingGaiaData();
        this.logger.info("found " + list.size() + " PHT stars for Gaia data download");
        if (list.isEmpty()) {
            return;
        }
        List<List<Long>> list2 = this.splitTicIdListIntoParts(list, Runtime.getRuntime().availableProcessors());
        ArrayList<Callable<Integer>> arrayList = new ArrayList<Callable<Integer>>();
        for (List<Long> list3 : list2) {
            arrayList.add(this.downloadAndSaveGaiaDataAsCallable(list3));
        }
        this.executeThreads(arrayList);
    }

    private void executeThreads(Collection<Callable<Integer>> collection) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(collection.size());
        executorService.invokeAll(collection);
    }

    List<List<Long>> splitTicIdListIntoParts(List<Long> list, int n) {
        if (list.size() <= n) {
            return List.of(list);
        }
        ArrayList<List<Long>> arrayList = new ArrayList<List<Long>>();
        int n2 = (list.size() % 2 == 0 ? list.size() : list.size() + 1) / n;
        if (n * n2 < list.size()) {
            ++n2;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i % n2 == 0) {
                arrayList.add(new ArrayList());
            }
            ((List)arrayList.get(arrayList.size() - 1)).add(list.get(i));
        }
        return arrayList;
    }

    Callable<Integer> downloadAndSaveGaiaDataAsCallable(List<Long> list) {
        return () -> {
            int n = 0;
            for (Long l : list) {
                IPlanetensucheObjekt iPlanetensucheObjekt = null;
                try {
                    try {
                        iPlanetensucheObjekt = this.psRepo.read("TIC " + l);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.logger.debug("star with tic id " + l + " not found in database, must be created");
                    }
                    if (iPlanetensucheObjekt == null) {
                        iPlanetensucheObjekt = this.createStarWithGaiaData(l);
                    } else if (iPlanetensucheObjekt.isGaiaAstroExNoiseSigUnbekannt() && iPlanetensucheObjekt.isGaiaNonSingleUnbekannt() && iPlanetensucheObjekt.isGaiaRuweUnbekannt()) {
                        this.updateStarWithGaiaData(l, iPlanetensucheObjekt);
                    }
                    if (iPlanetensucheObjekt == null || iPlanetensucheObjekt.getDatenid() == null) continue;
                    this.phtEbRepo.savePsObjectLink(l, iPlanetensucheObjekt.getDatenid());
                    ++n;
                }
                catch (IOException | RuntimeException | SQLException exception) {
                    if (iPlanetensucheObjekt != null) {
                        this.logger.error(iPlanetensucheObjekt.getObjektNamen().toString(), exception);
                        continue;
                    }
                    this.logger.error("tic id " + l, exception);
                }
            }
            return n;
        };
    }

    private void updateStarWithGaiaData(Long l, IPlanetensucheObjekt iPlanetensucheObjekt) throws IOException, SQLException {
        Optional<VizierTicCatalogDto> optional = this.ticCatalogService.findByTicId(l);
        if (optional.isPresent()) {
            VizierTicCatalogDto vizierTicCatalogDto = optional.get();
            Long l2 = vizierTicCatalogDto.getGaiaDr2Id();
            Optional<GaiaAstrometricDto> optional2 = l2 != null ? this.gaiaService.queryGaiaByGaiaDr2(l2) : this.gaiaService.queryGaiaByCoordinates(vizierTicCatalogDto.getRaJ2000(), vizierTicCatalogDto.getDeclJ2000());
            if (optional2.isPresent()) {
                GaiaAstrometricDto gaiaAstrometricDto = optional2.get();
                this.dataMapper.setGaiaDataOnPsObject(iPlanetensucheObjekt, gaiaAstrometricDto);
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                for (String string : iPlanetensucheObjekt.getObjektNamen()) {
                    if (string.startsWith("Gaia DR2 ")) {
                        bl = true;
                        continue;
                    }
                    if (string.startsWith("2MASS ")) {
                        bl2 = true;
                        continue;
                    }
                    if (!string.startsWith("KIC ")) continue;
                    bl3 = true;
                }
                if (bl && l2 != null) {
                    iPlanetensucheObjekt.getObjektNamen().add("Gaia DR2 " + l2);
                }
                if (vizierTicCatalogDto.getTwoMassId() != null && bl2) {
                    iPlanetensucheObjekt.getObjektNamen().add("2MASS " + vizierTicCatalogDto.getTwoMassId());
                }
                if (vizierTicCatalogDto.getKicId() != null && bl3) {
                    iPlanetensucheObjekt.getObjektNamen().add("KIC " + vizierTicCatalogDto.getKicId());
                }
                if (iPlanetensucheObjekt.getObjekttyp().equals(StarObjectType.SINGLE_STAR.getTypeName()) || iPlanetensucheObjekt.getObjekttyp().equals(StarObjectType.VARIABLE_UNKNOWN_TYPE.getTypeName()) || iPlanetensucheObjekt.getObjekttyp().equals(StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName()) || iPlanetensucheObjekt.getObjekttyp().equals(StarObjectType.DOUBLE_STAR_REAL.getTypeName())) {
                    iPlanetensucheObjekt.setObjekttyp(StarObjectType.ECLIPSING_BINARY_CANDIDATE.getTypeName());
                }
                this.psRepo.update(new PlanetensucheObjektPruefer(this.psObjectDao, iPlanetensucheObjekt), true, this.objektnamenKlassifiziererService);
            } else {
                this.logger.warn("no gaia catalog entry found for gaia DR2 id " + l2 + " and tic id " + l);
            }
        } else {
            this.logger.warn("no tic catalog entry found for tic id " + l);
        }
    }

    private void analyzeStars(int n) throws InterruptedException {
        List<Long> list = this.phtEbRepo.findUnanalyzedTargets();
        this.logger.info("found " + list.size() + " PHT stars for EB analysis");
        if (list.isEmpty()) {
            return;
        }
        if (n < list.size()) {
            list = list.subList(0, n);
        }
        int n2 = Runtime.getRuntime().availableProcessors() * 6;
        List<List<Long>> list2 = this.splitTicIdListIntoParts(list, n2);
        ArrayList<Callable<Integer>> arrayList = new ArrayList<Callable<Integer>>();
        int n3 = 1;
        for (List<Long> list3 : list2) {
            arrayList.add(this.analyzeStarsAsCallable(list3, n3));
            ++n3;
        }
        this.logger.info("execute " + arrayList.size() + " tasks to analyse " + list.size() + " TIC ids");
        this.executeThreads(arrayList);
    }

    private Callable<Integer> analyzeStarsAsCallable(List<Long> list, int n) {
        return () -> {
            int n2 = 0;
            int n3 = 0;
            for (Long l : list) {
                try {
                    int n4;
                    IPlanetensucheObjekt iPlanetensucheObjekt;
                    try {
                        iPlanetensucheObjekt = this.psRepo.read("TIC " + l);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.logger.error("star with tic id " + l + " not found in database, something wrong", illegalArgumentException);
                        continue;
                    }
                    if (GaiaNonSingleStar.ECLIPSING_BINARY.equals((Object)iPlanetensucheObjekt.getGaiaNonSingle())) {
                        this.saveStarAsKnownEb(l, "Gaia DR2/DR3");
                        continue;
                    }
                    if (iPlanetensucheObjekt.getObjekttyp().equals(StarObjectType.ECLIPSING_BINARY.getTypeName())) {
                        this.saveStarAsKnownEb(l, "Planetensuche database");
                        continue;
                    }
                    long l2 = this.extractGaiaDr2Id(iPlanetensucheObjekt);
                    long l3 = this.extractGaiaDr3Id(iPlanetensucheObjekt);
                    String string = this.extractKicName(iPlanetensucheObjekt);
                    Optional<String> optional = this.ebCatalogEntryFinder.findEbCatalogNameForTic(l, l2, l3, string, iPlanetensucheObjekt.getRA(), iPlanetensucheObjekt.getDECL());
                    if (optional.isPresent()) {
                        this.saveStarAsKnownEb(l, optional.get());
                        continue;
                    }
                    PhtEbCandidateTce phtEbCandidateTce = this.phtEbRepo.getTceForTic(l);
                    PhtEbCandidateAutoValidStatus phtEbCandidateAutoValidStatus = this.ebGaiaDataClassifier.isProbablyEclipsingBinary(iPlanetensucheObjekt, phtEbCandidateTce, n4 = this.phtEbRepo.getEbTagCountForTicId(l));
                    if (phtEbCandidateAutoValidStatus == PhtEbCandidateAutoValidStatus.NEB && iPlanetensucheObjekt.getObjekttyp().equals(StarObjectType.ECLIPSING_BINARY_CANDIDATE.getTypeName())) {
                        iPlanetensucheObjekt.setObjekttyp(StarObjectType.SINGLE_STAR.getTypeName());
                        this.psRepo.update(new PlanetensucheObjektPruefer(this.psObjectDao, iPlanetensucheObjekt), true, this.objektnamenKlassifiziererService);
                    }
                    this.phtEbRepo.saveAutoValidStatus(l, phtEbCandidateAutoValidStatus);
                    ++n3;
                }
                catch (RuntimeException | SQLException exception) {
                    this.logger.error("tic id " + l, exception);
                }
                if (!this.logger.isDebugEnabled()) continue;
                long l4 = Math.round((double)(++n2) * 100.0 / (double)list.size());
                this.logger.debug(l4 + "% done for task " + n);
            }
            return n3;
        };
    }

    private String extractKicName(IPlanetensucheObjekt iPlanetensucheObjekt) {
        List<String> list = iPlanetensucheObjekt.getObjektNamen().stream().filter(string -> string.startsWith("KIC ")).toList();
        String string2 = null;
        if (!list.isEmpty()) {
            string2 = list.get(0);
        }
        return string2;
    }

    private long extractGaiaDr3Id(IPlanetensucheObjekt iPlanetensucheObjekt) throws NumberFormatException {
        String string2;
        List<String> list = iPlanetensucheObjekt.getObjektNamen().stream().filter(string -> string.startsWith("Gaia DR3 ")).toList();
        long l = 0L;
        if (!list.isEmpty() && (string2 = list.get(0)) != null && string2.length() > 10) {
            l = Long.parseLong(string2.substring(9));
        }
        return l;
    }

    private long extractGaiaDr2Id(IPlanetensucheObjekt iPlanetensucheObjekt) throws NumberFormatException {
        String string2;
        List<String> list = iPlanetensucheObjekt.getObjektNamen().stream().filter(string -> string.startsWith("Gaia DR2 ")).toList();
        long l = 0L;
        if (!list.isEmpty() && (string2 = list.get(0)) != null && string2.length() > 10) {
            l = Long.parseLong(string2.substring(9));
        }
        return l;
    }

    private void saveStarAsKnownEb(long l, String string) throws SQLException, IOException {
        this.phtEbRepo.saveAutoValidStatus(l, PhtEbCandidateAutoValidStatus.KNOWN_EB, string);
        IPlanetensucheObjekt iPlanetensucheObjekt = this.psRepo.read("TIC " + l);
        if (!StarObjectType.ECLIPSING_BINARY.getTypeName().equals(iPlanetensucheObjekt.getObjekttyp())) {
            iPlanetensucheObjekt.setObjekttyp(StarObjectType.ECLIPSING_BINARY.getTypeName());
            this.psRepo.update(new PlanetensucheObjektPruefer(this.psObjectDao, iPlanetensucheObjekt), true, this.objektnamenKlassifiziererService);
        }
    }

    private IPlanetensucheObjekt createStarWithGaiaData(Long l) throws SQLException, IOException {
        Optional<VizierTicCatalogDto> optional = this.ticCatalogService.findByTicId(l);
        if (optional.isPresent()) {
            VizierTicCatalogDto vizierTicCatalogDto = optional.get();
            Long l2 = vizierTicCatalogDto.getGaiaDr2Id();
            Optional<GaiaAstrometricDto> optional2 = l2 != null ? this.gaiaService.queryGaiaByGaiaDr2(l2) : this.gaiaService.queryGaiaByCoordinates(vizierTicCatalogDto.getRaJ2000(), vizierTicCatalogDto.getDeclJ2000());
            if (optional2.isPresent()) {
                GaiaAstrometricDto gaiaAstrometricDto = optional2.get();
                IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer = this.dataMapper.createPlanetensucheObject(l, l2, vizierTicCatalogDto, gaiaAstrometricDto);
                this.psRepo.create(iPlanetensucheObjektPruefer, true, this.objektnamenKlassifiziererService);
                return iPlanetensucheObjektPruefer;
            }
            this.logger.warn("no gaia catalog entry found for gaia DR2 id " + l2 + " and tic id " + l);
            IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer = this.dataMapper.createPlanetensucheObject(l, l2, vizierTicCatalogDto, null);
            this.psRepo.create(iPlanetensucheObjektPruefer, true, this.objektnamenKlassifiziererService);
            return iPlanetensucheObjektPruefer;
        }
        this.logger.warn("no tic catalog entry found for tic id " + l);
        return null;
    }
}

