/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtebs;

import com.google.inject.Inject;
import de.planetensuche.core.Check;
import de.planetensuche.datenbankkern.api.repos.IPhtEbCandidatesRepository;
import de.planetensuche.datenbankkern.querydsl5.PhtEbCandidateTce;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;

public class TceCsvImporter {
    static final String DEFAULT_INPUT_FILE = "/media/veracrypt1/admin/planethunters/tess_dv_fast/data/tess_dv_fast/tess_tcestats.csv";
    private final int columnTicId = 2;
    private final int columnSectors = 4;
    private final int columnPeriod = 6;
    private final int columnDitcoMsky = 122;
    private final int columnDitcoMskyErr = 123;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IPhtEbCandidatesRepository phtEbCandidatesRepo;

    @Inject
    public TceCsvImporter(IPhtEbCandidatesRepository iPhtEbCandidatesRepository) {
        this.phtEbCandidatesRepo = iPhtEbCandidatesRepository;
    }

    public void importTceData(String string) throws IOException {
        this.logger.info("start TCE import");
        long l = this.phtEbCandidatesRepo.countTceEntries();
        if (l > 0L) {
            this.logger.info("cancel import, there are already " + l + " TCE entries");
            return;
        }
        List<String> list = FileUtils.readLines(new File(string), Charset.forName("utf-8"));
        this.logger.debug("found " + list.size() + " lines in the CSV file");
        for (String string2 : list) {
            if (string2.startsWith("#") || string2.startsWith("exomast_id")) continue;
            try {
                PhtEbCandidateTce phtEbCandidateTce = this.parseLineAndMapToExistingData(string2);
                this.phtEbCandidatesRepo.saveTceEntry(phtEbCandidateTce);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException | SQLException | PatternSyntaxException exception) {
                this.logger.error("unable to process line: " + string2, exception);
            }
        }
        this.logger.info("finished TCE import");
    }

    PhtEbCandidateTce parseLineAndMapToExistingData(String string) {
        PhtEbCandidateTce phtEbCandidateTce = this.parseLine(string);
        PhtEbCandidateTce phtEbCandidateTce2 = this.phtEbCandidatesRepo.getTceForTic(phtEbCandidateTce.getTicId());
        if (phtEbCandidateTce2 == null) {
            return phtEbCandidateTce;
        }
        if (this.periodsNearlyTheSame(phtEbCandidateTce.getPeriod1(), phtEbCandidateTce2.getPeriod1())) {
            if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors1()) {
                this.setPeriodOffsetSector1(phtEbCandidateTce2, phtEbCandidateTce);
            }
        } else if (this.periodsNearlyTheSame(phtEbCandidateTce.getPeriod1(), phtEbCandidateTce2.getPeriod2())) {
            if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors2()) {
                this.setPeriodOffsetSector2(phtEbCandidateTce2, phtEbCandidateTce);
            }
        } else if (this.periodsNearlyTheSame(phtEbCandidateTce.getPeriod1(), phtEbCandidateTce2.getPeriod3())) {
            if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors3()) {
                this.setPeriodOffsetSector3(phtEbCandidateTce2, phtEbCandidateTce);
            }
        } else if (this.periodsNearlyTheSame(phtEbCandidateTce.getPeriod1(), phtEbCandidateTce2.getPeriod4())) {
            if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors4()) {
                this.setPeriodOffsetSector4(phtEbCandidateTce2, phtEbCandidateTce);
            }
        } else if (this.periodsNearlyTheSame(phtEbCandidateTce.getPeriod1(), phtEbCandidateTce2.getPeriod5())) {
            if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors5()) {
                this.setPeriodOffsetSector5(phtEbCandidateTce2, phtEbCandidateTce);
            }
        } else if (this.periodsNearlyTheSame(phtEbCandidateTce.getPeriod1(), phtEbCandidateTce2.getPeriod6())) {
            if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors6()) {
                this.setPeriodOffsetSector6(phtEbCandidateTce2, phtEbCandidateTce);
            }
        } else if (phtEbCandidateTce2.getPeriod2() == null) {
            this.setPeriodOffsetSector2(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce2.getPeriod3() == null) {
            this.setPeriodOffsetSector3(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce2.getPeriod4() == null) {
            this.setPeriodOffsetSector4(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce2.getPeriod5() == null) {
            this.setPeriodOffsetSector5(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce2.getPeriod6() == null) {
            this.setPeriodOffsetSector6(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors1()) {
            this.setPeriodOffsetSector1(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors2()) {
            this.setPeriodOffsetSector2(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors3()) {
            this.setPeriodOffsetSector3(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors4()) {
            this.setPeriodOffsetSector4(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors5()) {
            this.setPeriodOffsetSector5(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce.getNumSectors1() > phtEbCandidateTce2.getNumSectors6()) {
            this.setPeriodOffsetSector6(phtEbCandidateTce2, phtEbCandidateTce);
        } else if (phtEbCandidateTce.getTargetOffset1() != null) {
            if (phtEbCandidateTce2.getTargetOffset1() == null && Objects.equals(phtEbCandidateTce.getNumSectors1(), phtEbCandidateTce2.getNumSectors1())) {
                this.setPeriodOffsetSector1(phtEbCandidateTce2, phtEbCandidateTce);
            } else if (phtEbCandidateTce2.getTargetOffset2() == null && Objects.equals(phtEbCandidateTce.getNumSectors1(), phtEbCandidateTce2.getNumSectors2())) {
                this.setPeriodOffsetSector2(phtEbCandidateTce2, phtEbCandidateTce);
            } else if (phtEbCandidateTce2.getTargetOffset3() == null && Objects.equals(phtEbCandidateTce.getNumSectors1(), phtEbCandidateTce2.getNumSectors3())) {
                this.setPeriodOffsetSector3(phtEbCandidateTce2, phtEbCandidateTce);
            } else if (phtEbCandidateTce2.getTargetOffset4() == null && Objects.equals(phtEbCandidateTce.getNumSectors1(), phtEbCandidateTce2.getNumSectors4())) {
                this.setPeriodOffsetSector4(phtEbCandidateTce2, phtEbCandidateTce);
            } else if (phtEbCandidateTce2.getTargetOffset5() == null && Objects.equals(phtEbCandidateTce.getNumSectors1(), phtEbCandidateTce2.getNumSectors5())) {
                this.setPeriodOffsetSector5(phtEbCandidateTce2, phtEbCandidateTce);
            } else if (phtEbCandidateTce2.getTargetOffset6() == null && Objects.equals(phtEbCandidateTce.getNumSectors1(), phtEbCandidateTce2.getNumSectors6())) {
                this.setPeriodOffsetSector6(phtEbCandidateTce2, phtEbCandidateTce);
            } else {
                this.logger.debug("existing TCE for TIC " + phtEbCandidateTce.getTicId() + " with period " + phtEbCandidateTce2.getPeriod1() + "/" + phtEbCandidateTce2.getPeriod2() + "/" + phtEbCandidateTce2.getPeriod3() + "/" + phtEbCandidateTce2.getPeriod4() + "/" + phtEbCandidateTce2.getPeriod5() + "/" + phtEbCandidateTce2.getPeriod6() + " and offset " + phtEbCandidateTce2.getTargetOffset1() + "/" + phtEbCandidateTce2.getTargetOffset2() + "/" + phtEbCandidateTce2.getTargetOffset3() + "/" + phtEbCandidateTce2.getTargetOffset4() + "/" + phtEbCandidateTce2.getTargetOffset5() + "/" + phtEbCandidateTce2.getTargetOffset6() + " will not overwrite with period " + phtEbCandidateTce.getPeriod1() + " and offset " + phtEbCandidateTce.getTargetOffset1());
            }
        }
        return phtEbCandidateTce2;
    }

    private void setPeriodOffsetSector1(PhtEbCandidateTce phtEbCandidateTce, PhtEbCandidateTce phtEbCandidateTce2) {
        phtEbCandidateTce.setPeriod1(phtEbCandidateTce2.getPeriod1());
        phtEbCandidateTce.setNumSectors1(phtEbCandidateTce2.getNumSectors1());
        phtEbCandidateTce.setTargetOffset1(phtEbCandidateTce2.getTargetOffset1());
    }

    private void setPeriodOffsetSector2(PhtEbCandidateTce phtEbCandidateTce, PhtEbCandidateTce phtEbCandidateTce2) {
        phtEbCandidateTce.setPeriod2(phtEbCandidateTce2.getPeriod1());
        phtEbCandidateTce.setNumSectors2(phtEbCandidateTce2.getNumSectors1());
        phtEbCandidateTce.setTargetOffset2(phtEbCandidateTce2.getTargetOffset1());
    }

    private void setPeriodOffsetSector3(PhtEbCandidateTce phtEbCandidateTce, PhtEbCandidateTce phtEbCandidateTce2) {
        phtEbCandidateTce.setPeriod3(phtEbCandidateTce2.getPeriod1());
        phtEbCandidateTce.setNumSectors3(phtEbCandidateTce2.getNumSectors1());
        phtEbCandidateTce.setTargetOffset3(phtEbCandidateTce2.getTargetOffset1());
    }

    private void setPeriodOffsetSector4(PhtEbCandidateTce phtEbCandidateTce, PhtEbCandidateTce phtEbCandidateTce2) {
        phtEbCandidateTce.setPeriod4(phtEbCandidateTce2.getPeriod1());
        phtEbCandidateTce.setNumSectors4(phtEbCandidateTce2.getNumSectors1());
        phtEbCandidateTce.setTargetOffset4(phtEbCandidateTce2.getTargetOffset1());
    }

    private void setPeriodOffsetSector5(PhtEbCandidateTce phtEbCandidateTce, PhtEbCandidateTce phtEbCandidateTce2) {
        phtEbCandidateTce.setPeriod5(phtEbCandidateTce2.getPeriod1());
        phtEbCandidateTce.setNumSectors5(phtEbCandidateTce2.getNumSectors1());
        phtEbCandidateTce.setTargetOffset5(phtEbCandidateTce2.getTargetOffset1());
    }

    private void setPeriodOffsetSector6(PhtEbCandidateTce phtEbCandidateTce, PhtEbCandidateTce phtEbCandidateTce2) {
        phtEbCandidateTce.setPeriod6(phtEbCandidateTce2.getPeriod1());
        phtEbCandidateTce.setNumSectors6(phtEbCandidateTce2.getNumSectors1());
        phtEbCandidateTce.setTargetOffset6(phtEbCandidateTce2.getTargetOffset1());
    }

    private boolean periodsNearlyTheSame(Double d, Double d2) {
        long l;
        if (d == null || d2 == null) {
            return false;
        }
        long l2 = Math.round(d * 10.0);
        return l2 == (l = Math.round(d2 * 10.0)) || l2 > l - 4L && l2 < l + 4L;
    }

    PhtEbCandidateTce parseLine(String string) throws NumberFormatException {
        String[] stringArray = string.split(",");
        PhtEbCandidateTce phtEbCandidateTce = new PhtEbCandidateTce();
        phtEbCandidateTce.setTicId(Long.valueOf(stringArray[2]));
        phtEbCandidateTce.setNumSectors1(this.parseNumberOfSectors(stringArray[4]));
        phtEbCandidateTce.setPeriod1(Double.valueOf(stringArray[6]));
        if (phtEbCandidateTce.getPeriod1() == null || phtEbCandidateTce.getPeriod1() <= 0.0) {
            throw new NumberFormatException("period of TIC " + phtEbCandidateTce.getTicId() + " is invalid: '" + stringArray[6] + "'");
        }
        if (phtEbCandidateTce.getNumSectors1() == null || phtEbCandidateTce.getNumSectors1() <= 0) {
            throw new NumberFormatException("number of sectors of TIC " + phtEbCandidateTce.getTicId() + " is invalid: '" + stringArray[4] + "'");
        }
        if (Check.isFilled(stringArray[122]) && Check.isFilled(stringArray[123])) {
            Double d = Double.valueOf(stringArray[122]);
            Double d2 = Double.valueOf(stringArray[123]);
            if (d != 0.0 && d2 != 0.0) {
                double d3 = d / d2;
                phtEbCandidateTce.setTargetOffset1(d3);
            }
        }
        return phtEbCandidateTce;
    }

    private Integer parseNumberOfSectors(String string) {
        String[] stringArray = string.split("-");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("sector '" + string + "' not parseable");
        }
        int n = Integer.parseInt(stringArray[0].replace("s", ""));
        int n2 = Integer.parseInt(stringArray[1].replace("s", ""));
        return n2 + 1 - n;
    }
}

