/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtebs;

import com.google.gson.Gson;
import de.planetensuche.datenbank.phtebs.PhtPopularTagsDto;
import de.planetensuche.datenbank.phtebs.PopularTagsResultDto;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ZooniverseApiClient {
    private static final String TAGS_URL = "https://talk.zooniverse.org/tags/popular?http_cache=true&taggable_type=Subject&section=project-7929&name={0}&page={1}";
    private static final String SUBJECT_METADATA_URL = "https://www.zooniverse.org/api/subjects/{0}?http_cache=true";
    private static final int TIMEOUT_IN_MS_SUBJECT = 5000;
    private static final int TIMEOUT_IN_MS_TAGS = 7500;
    private final Gson gson;
    private final HttpClient client;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public ZooniverseApiClient() {
        this.gson = new Gson();
        this.client = HttpClient.newBuilder().build();
    }

    public List<PhtPopularTagsDto> fetchTagStatistics(String string, int n) throws URISyntaxException, IOException, InterruptedException {
        String string2 = TAGS_URL.replace("{0}", string).replace("{1}", "" + n);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(string2)).GET().timeout(Duration.ofMillis(7500L)).build();
        HttpResponse<String> httpResponse = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        return this.extractTagsFromJson(httpResponse.body());
    }

    List<PhtPopularTagsDto> extractTagsFromJson(String string) {
        PopularTagsResultDto popularTagsResultDto = this.gson.fromJson(string, PopularTagsResultDto.class);
        int n = popularTagsResultDto.meta.popular.page_count;
        List<PopularTagsResultDto.TagPopular> list = popularTagsResultDto.popular;
        ArrayList<PhtPopularTagsDto> arrayList = new ArrayList<PhtPopularTagsDto>();
        for (PopularTagsResultDto.TagPopular tagPopular : list) {
            arrayList.add(new PhtPopularTagsDto(tagPopular.taggable_id, tagPopular.usages, n));
        }
        return arrayList;
    }

    public Optional<Long> getTicIdForSubject(long l) throws URISyntaxException, IOException, InterruptedException {
        String string = SUBJECT_METADATA_URL.replace("{0}", "" + l);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(string)).header("Content-Type", "application/json").header("Accept", "application/vnd.api+json; version=1").GET().timeout(Duration.ofMillis(5000L)).build();
        HttpResponse<String> httpResponse = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        String string2 = httpResponse.body();
        try {
            Long l2 = this.extractTicIdFromJson(string2);
            return Optional.ofNullable(l2);
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("can't parse tic id from body: " + string2, runtimeException);
            throw runtimeException;
        }
    }

    Long extractTicIdFromJson(String string) {
        int n = string.indexOf("TIC ID");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n);
        n = string2.indexOf(":");
        string2 = string2.substring(n + 1);
        n = string2.indexOf(",");
        long l = Long.parseLong((string2 = string2.substring(0, n).replaceAll("\"", "")).trim());
        if (l < 1L) {
            throw new IllegalArgumentException("could not parse tic id from json '" + string + "'");
        }
        return l;
    }
}

