/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtmatches;

import de.planetensuche.datenbank.phtmatches.EditExoplanetDiscoveryDialog;
import de.planetensuche.datenbankkern.api.repos.IPhtTransitMatchesRepository;
import de.planetensuche.datenbankkern.querydsl5.PhtTransitMatches;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.eventbus.EventBus;
import de.planetensuche.guidesigner.eventbus.Topics;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class EditExoplanetDiscoveryController {
    private final ILogging logger;
    private final IPhtTransitMatchesRepository repo;
    private final EventBus<Topics> eventBus;

    public EditExoplanetDiscoveryController(IPhtTransitMatchesRepository iPhtTransitMatchesRepository, EventBus<Topics> eventBus) {
        this.repo = iPhtTransitMatchesRepository;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.eventBus = eventBus;
    }

    public void showDialog() {
        EventQueue.invokeLater(() -> {
            EditExoplanetDiscoveryDialog editExoplanetDiscoveryDialog = new EditExoplanetDiscoveryDialog();
            editExoplanetDiscoveryDialog.getComboBoxOwnDiscoveries().removeAllItems();
            List<PhtTransitMatches> list = this.repo.findScanResults();
            for (PhtTransitMatches phtTransitMatches : list) {
                editExoplanetDiscoveryDialog.getComboBoxOwnDiscoveries().addItem(phtTransitMatches.getPlanetId());
            }
            editExoplanetDiscoveryDialog.getComboBoxOwnDiscoveries().addActionListener(actionEvent -> this.changeExoplanet(editExoplanetDiscoveryDialog));
            editExoplanetDiscoveryDialog.getButtonSave().addActionListener(actionEvent -> this.save(editExoplanetDiscoveryDialog));
            editExoplanetDiscoveryDialog.setVisible(true);
        });
    }

    private void changeExoplanet(EditExoplanetDiscoveryDialog editExoplanetDiscoveryDialog) {
        if (editExoplanetDiscoveryDialog.getComboBoxOwnDiscoveries().getSelectedIndex() >= 0) {
            editExoplanetDiscoveryDialog.getLabelMessage().setText("");
            String string = editExoplanetDiscoveryDialog.getComboBoxOwnDiscoveries().getSelectedItem().toString();
            PhtTransitMatches phtTransitMatches = this.repo.read(string);
            if (phtTransitMatches != null) {
                editExoplanetDiscoveryDialog.getInputPlanetName().setText(phtTransitMatches.getPlanetId());
                editExoplanetDiscoveryDialog.getInputObserve().setSelected(true);
                editExoplanetDiscoveryDialog.getInputPhtSubjectId().setText(phtTransitMatches.getMatchedSubjectId().toString());
                editExoplanetDiscoveryDialog.getInputUserComment().setText(phtTransitMatches.getUserComment());
            }
        }
    }

    private void save(EditExoplanetDiscoveryDialog editExoplanetDiscoveryDialog) {
        if (!(this.checkInput(editExoplanetDiscoveryDialog.getInputPlanetName(), editExoplanetDiscoveryDialog) && this.checkInput(editExoplanetDiscoveryDialog.getInputPhtSubjectId(), editExoplanetDiscoveryDialog) && this.checkInput(editExoplanetDiscoveryDialog.getInputUserComment(), editExoplanetDiscoveryDialog))) {
            return;
        }
        ISprachcontainer iSprachcontainer = editExoplanetDiscoveryDialog.getSprachcontainer();
        if (editExoplanetDiscoveryDialog.getInputUserComment().getText().length() > 256) {
            JOptionPane.showMessageDialog(editExoplanetDiscoveryDialog, iSprachcontainer.getString("db_f122"), iSprachcontainer.getString("db_m491"), 0);
            return;
        }
        try {
            PhtTransitMatches phtTransitMatches = this.repo.read(editExoplanetDiscoveryDialog.getInputPlanetName().getText());
            if (phtTransitMatches == null) {
                JOptionPane.showMessageDialog(editExoplanetDiscoveryDialog, iSprachcontainer.getString("db_m490", editExoplanetDiscoveryDialog.getInputPlanetName().getText()), iSprachcontainer.getString("db_m491"), 0);
                return;
            }
            phtTransitMatches.setChecked(Boolean.TRUE);
            if (editExoplanetDiscoveryDialog.getInputObserve().isSelected()) {
                if (!this.validateAndSetSubjectId(editExoplanetDiscoveryDialog, iSprachcontainer, phtTransitMatches)) {
                    return;
                }
            } else {
                phtTransitMatches.setMatchedSubjectId(null);
            }
            phtTransitMatches.setUserComment(editExoplanetDiscoveryDialog.getInputUserComment().getText());
            this.repo.save(phtTransitMatches);
            this.afterSave(editExoplanetDiscoveryDialog, iSprachcontainer, phtTransitMatches.getPlanetId());
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
    }

    private void afterSave(EditExoplanetDiscoveryDialog editExoplanetDiscoveryDialog, ISprachcontainer iSprachcontainer, String string) {
        editExoplanetDiscoveryDialog.getLabelMessage().setText(iSprachcontainer.getString("db_m493", string));
        boolean bl = false;
        for (int i = 0; i < editExoplanetDiscoveryDialog.getComboBoxOwnDiscoveries().getItemCount(); ++i) {
            String string2 = editExoplanetDiscoveryDialog.getComboBoxOwnDiscoveries().getItemAt(i);
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            editExoplanetDiscoveryDialog.getComboBoxOwnDiscoveries().addItem(string);
        }
        this.eventBus.publish(Topics.REFRESH, string);
    }

    private boolean validateAndSetSubjectId(EditExoplanetDiscoveryDialog editExoplanetDiscoveryDialog, ISprachcontainer iSprachcontainer, PhtTransitMatches phtTransitMatches) throws HeadlessException {
        long l;
        String string = editExoplanetDiscoveryDialog.getInputPhtSubjectId().getText();
        try {
            l = Long.parseLong(string);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            JOptionPane.showMessageDialog(editExoplanetDiscoveryDialog, iSprachcontainer.getString("db_m492"), iSprachcontainer.getString("db_m491"), 0);
            return false;
        }
        if (l < 1L) {
            JOptionPane.showMessageDialog(editExoplanetDiscoveryDialog, iSprachcontainer.getString("db_m492"), iSprachcontainer.getString("db_m491"), 0);
            return false;
        }
        phtTransitMatches.setMatchedSubjectId(l);
        return true;
    }

    private boolean checkInput(JTextField jTextField, EditExoplanetDiscoveryDialog editExoplanetDiscoveryDialog) {
        if (jTextField.getText().isBlank()) {
            jTextField.setBackground(Color.red);
            return false;
        }
        jTextField.setBackground(editExoplanetDiscoveryDialog.getComboBoxOwnDiscoveries().getBackground());
        return true;
    }
}

