/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtmatches;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.DatenbankDialog;
import de.planetensuche.datenbank.PlanetTypeDetectorService;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbank.phtmatches.EditExoplanetDiscoveryController;
import de.planetensuche.datenbank.phtmatches.IScanProgress;
import de.planetensuche.datenbank.phtmatches.PhtMatchesDialog;
import de.planetensuche.datenbank.phtmatches.PhtMatchesResultDialog;
import de.planetensuche.datenbank.phtmatches.PhtMatchesStatisticService;
import de.planetensuche.datenbank.phtmatches.PhtScanResultDto;
import de.planetensuche.datenbank.phtmatches.PhtScanResultMapper;
import de.planetensuche.datenbank.phtmatches.service.IPhtTransitMatchFinder;
import de.planetensuche.datenbank.phtmatches.service.PhtTransitImporter;
import de.planetensuche.datenbankkern.api.kategorien.IPlanetenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPhtTransitMatchesRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.eventbus.EventBus;
import de.planetensuche.guidesigner.eventbus.Subscriber;
import de.planetensuche.guidesigner.eventbus.Topics;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;

public class PhtMatchesDialogControler
implements IScanProgress {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final PhtMatchesDialog dialog;
    private final PhtMatchesResultDialog resultDialog;
    private final IPhtTransitMatchFinder transitFinder;
    private final PhtTransitImporter importer;
    private final IPhtTransitMatchesRepository transitRepo;
    private final PhtMatchesStatisticService statisticService;
    private final DatenbankDialog datenbankDialog;
    private final PhtScanResultMapper mapper;
    private final EventBus<Topics> eventBus;
    private final long subscriberId;

    public PhtMatchesDialogControler(IPhtTransitMatchFinder iPhtTransitMatchFinder, IPhtTransitMatchesRepository iPhtTransitMatchesRepository, IPlanetenRepository iPlanetenRepository, IObjektnamenRepository iObjektnamenRepository, Katalogerkenner katalogerkenner, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, PlanetTypeDetectorService planetTypeDetectorService, DatenbankDialog datenbankDialog) {
        this.transitFinder = iPhtTransitMatchFinder;
        this.transitRepo = iPhtTransitMatchesRepository;
        this.datenbankDialog = datenbankDialog;
        this.eventBus = new EventBus();
        this.subscriberId = System.currentTimeMillis();
        this.importer = new PhtTransitImporter(iPhtTransitMatchesRepository, katalogerkenner);
        this.dialog = new PhtMatchesDialog();
        this.resultDialog = new PhtMatchesResultDialog();
        this.statisticService = new PhtMatchesStatisticService(iPhtTransitMatchesRepository, iPlanetenRepository, iObjektnamenRepository, this.dialog.getSprachcontainer(), this.dialog);
        this.mapper = new PhtScanResultMapper(iPlanetensucheObjektRepository, planetTypeDetectorService);
        this.addActionListener();
        this.setPhtUsernameOnGui();
        this.eventBus.subscribe(Topics.REFRESH, this.createSubscriber());
    }

    private Subscriber<Topics> createSubscriber() {
        return new Subscriber<Topics>(){

            @Override
            public void onEvent(Topics topics, Object object) {
                if (topics == Topics.REFRESH) {
                    PhtMatchesDialogControler.this.loadAndRefreshResultList();
                }
            }

            @Override
            public long getSubscriberId() {
                return PhtMatchesDialogControler.this.subscriberId;
            }
        };
    }

    private void setPhtUsernameOnGui() {
        try {
            String string = KonfiguratorFabrik.getKonfigurator().read().getPhtUsername();
            if (Check.isFilled(string)) {
                this.dialog.setPhtUsername(string);
            }
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
    }

    private void addActionListener() {
        PhtMatchesDialogControler phtMatchesDialogControler = this;
        this.dialog.getStartOrResumeScanButton().addActionListener(actionEvent -> JOptionPane.showMessageDialog(this.dialog, this.dialog.getI18n().getString("db_m506"), this.dialog.getI18n().getString("db_m506_title"), 1));
        this.dialog.getPauseScanButton().addActionListener(actionEvent -> {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(() -> {
                this.transitFinder.stopScan();
                return null;
            });
        });
        this.dialog.getShowResultsButton().addActionListener(actionEvent -> this.loadAndRefreshResultList());
        this.dialog.getResetResultsButton().addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(this.dialog, this.dialog.getSprachcontainer().getString("db_m473"), this.dialog.getSprachcontainer().getString("db_m473_titel"), 0, 3);
            if (n == 0) {
                this.dialog.getStartOrResumeScanButton().setEnabled(false);
                this.dialog.getResetResultsButton().setEnabled(false);
                this.dialog.setCursor(Cursor.getPredefinedCursor(3));
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                executorService.submit(() -> {
                    this.transitFinder.resetScan();
                    this.dialog.setCursor(Cursor.getPredefinedCursor(0));
                    this.dialog.getStartOrResumeScanButton().setEnabled(true);
                    this.dialog.getResetResultsButton().setEnabled(true);
                    return null;
                });
            }
        });
        this.resultDialog.getResultsTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    Object object;
                    Object object2;
                    int n = PhtMatchesDialogControler.this.resultDialog.getResultsTable().getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    int n2 = PhtMatchesDialogControler.this.resultDialog.getResultsTable().getSelectedColumn();
                    if (n2 == 8 || n2 == 9) {
                        object2 = PhtMatchesDialogControler.this.resultDialog.getResultsTable().getModel().getValueAt(n, n2 + 3);
                        object = new URI(object2.toString());
                        Desktop.getDesktop().browse((URI)object);
                    }
                    if (n2 == 10) {
                        object2 = PhtMatchesDialogControler.this.resultDialog.getResultsTable().getModel().getValueAt(n, 5).toString();
                        if (Check.isEmpty(object2)) {
                            object = PhtMatchesDialogControler.this.dialog.getSprachcontainer();
                            JOptionPane.showMessageDialog(PhtMatchesDialogControler.this.resultDialog, object.getString("db_f123"), object.getString("db_f123_title"), 2);
                        } else {
                            object = PhtMatchesDialogControler.this.resultDialog.getResultsTable().getModel().getValueAt(n, 0).toString();
                            if (Check.isFilled(object)) {
                                PhtMatchesDialogControler.this.datenbankDialog.zeigeInfos((String)object);
                                PhtMatchesDialogControler.this.resultDialog.setState(1);
                                PhtMatchesDialogControler.this.dialog.setState(1);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    PhtMatchesDialogControler.this.logger.error("error on open link in PHT result table", exception);
                }
            }
        });
        this.resultDialog.getMenuEditEntry().addActionListener(actionEvent -> {
            EditExoplanetDiscoveryController editExoplanetDiscoveryController = new EditExoplanetDiscoveryController(this.transitRepo, this.eventBus);
            editExoplanetDiscoveryController.showDialog();
        });
        this.resultDialog.getMenuRefresh().addActionListener(actionEvent -> this.loadAndRefreshResultList());
    }

    private void loadAndRefreshResultList() {
        AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
        asyncLoadingScreenCallbackExecutor.execute(this.resultDialog, () -> {
            try {
                List<PhtScanResultDto> list = this.mapper.convertTo(this.transitRepo.findScanResults());
                EventQueue.invokeLater(() -> {
                    this.resultDialog.setVisible(true);
                    this.resultDialog.showData(list);
                });
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
            }
        });
    }

    public void showDialog() {
        EventQueue.invokeLater(() -> this.dialog.setVisible(true));
    }

    @Override
    public void updateProgress(int n, int n2) {
        int n3 = (int)Math.round((double)n * 100.0 / (double)n2);
        this.dialog.setStatus(n3);
    }

    @Override
    public void printTextDownloadData() {
        this.dialog.appendAusgabe(this.dialog.getSprachcontainer().getString("db_m468"));
    }

    @Override
    public void printTextScanPlanetCandidateList() {
        this.dialog.appendAusgabe(this.dialog.getSprachcontainer().getString("db_m469"));
    }

    @Override
    public void printMsg(String string) {
        this.dialog.appendAusgabe(string);
    }

    @Override
    public void printTextScanStoppedUser() {
        this.dialog.setCursor(Cursor.getPredefinedCursor(0));
        this.dialog.appendAusgabe(this.dialog.getSprachcontainer().getString("db_m470"));
        this.dialog.getStartOrResumeScanButton().setEnabled(true);
        this.dialog.getResetResultsButton().setEnabled(true);
    }

    @Override
    public void printTextScanStoppedError() {
        this.dialog.setCursor(Cursor.getPredefinedCursor(0));
        this.dialog.appendAusgabe(this.dialog.getSprachcontainer().getString("db_m471"));
        this.dialog.getStartOrResumeScanButton().setEnabled(true);
        this.dialog.getResetResultsButton().setEnabled(true);
    }

    @Override
    public void printScanCurrentlyPcName(String string, Optional<String> optional) {
        this.dialog.setScanPc(string, optional);
    }

    @Override
    public void printTextUserHasNoTransits() {
        this.dialog.setCursor(Cursor.getPredefinedCursor(0));
        this.dialog.appendAusgabe(this.dialog.getSprachcontainer().getString("db_m472"));
        this.dialog.getStartOrResumeScanButton().setEnabled(true);
        this.dialog.getResetResultsButton().setEnabled(true);
    }

    @Override
    public void printTextUserTransitCount(int n) {
        this.dialog.appendAusgabe(this.dialog.getSprachcontainer().getString("db_m476", this.dialog.getPhtUserName(), n));
    }
}

