/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtmatches;

import de.planetensuche.datenbank.importierer.csv.nasa.ExofopPlanetStatus;
import de.planetensuche.datenbank.phtmatches.PhtScanResultDto;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.jtable.JTableExtended;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;

public class PhtMatchesResultDialog
extends Basisdialog {
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JLabel labelEntriesFound;
    private JMenuItem menuEditEntry;
    private JMenuItem menuRefresh;
    private JTableExtended resultsTable;

    public PhtMatchesResultDialog() {
        super(BasisdialogId.DATENBANK_PHT_MATCHES_RESULT);
        this.initComponents();
        this.setSize(this.getMaxDesktopWidth(), this.getHeight() + 20);
        this.setTitle(this.i18n.getString("db_gui143"));
        this.jMenu1.setText(this.i18n.getString("db_gui163"));
        this.menuEditEntry.setText(this.i18n.getString("db_gui164"));
        this.menuRefresh.setText(this.i18n.getString("db_gui188"));
        this.labelEntriesFound.setText("");
        this.resultsTable.disableDragColumns();
        this.resultsTable.disableEditMode();
        this.resultsTable.setToolTipText(this.i18n.getString("db_m474"));
    }

    public JTableExtended getResultsTable() {
        return this.resultsTable;
    }

    public JMenuItem getMenuEditEntry() {
        return this.menuEditEntry;
    }

    public JMenuItem getMenuRefresh() {
        return this.menuRefresh;
    }

    public void showData(List<PhtScanResultDto> list) {
        List<String> list2 = Arrays.asList(this.getI18n().getHtmlString("db_gui144"), this.getI18n().getHtmlString("db_gui176"), this.getI18n().getHtmlString("db_gui145"), this.getI18n().getHtmlString("db_gui177"), this.getI18n().getHtmlString("db_gui171").replace(":", ""), this.getI18n().getHtmlString("db_gui179"), this.i18n.getHtmlString("db_m451"), this.getI18n().getHtmlString("db_gui178"), this.i18n.getHtmlString("db_gui146"), this.i18n.getHtmlString("db_gui147"), this.getI18n().getHtmlString("db_gui180"), "hiden PHT link", "hiden exofop link");
        List<List<String>> list3 = this.convertTo(list);
        EventQueue.invokeLater(() -> {
            boolean bl = this.resultsTable.getModel().getRowCount() < 1;
            this.resultsTable.setTableContent(list3, list2);
            if (bl) {
                Dimension dimension = this.resultsTable.getTableHeader().getPreferredSize();
                this.resultsTable.getTableHeader().setPreferredSize(new Dimension((int)Math.round(dimension.getWidth()), (int)Math.round(dimension.getHeight() * 3.0)));
            }
            this.resultsTable.removeColumn(this.resultsTable.getColumnModel().getColumn(12));
            this.resultsTable.removeColumn(this.resultsTable.getColumnModel().getColumn(11));
            this.setFixWithForColumn(0, 140);
            this.setFixWithForColumn(1, 100);
            this.setFixWithForColumn(2, 140);
            this.setFixWithForColumn(3, 60);
            this.setFixWithForColumn(5, 120);
            this.setFixWithForColumn(6, 90);
            this.setFixWithForColumn(8, 100);
            this.setFixWithForColumn(9, 80);
            this.setFixWithForColumn(10, 100);
            this.jScrollPane1.setHorizontalScrollBarPolicy(30);
            this.labelEntriesFound.setText(" " + this.i18n.toLocalisedInt(list3.size()) + " " + this.i18n.getString("db_gui163"));
        });
    }

    private void setFixWithForColumn(int n, int n2) {
        this.resultsTable.getColumnModel().getColumn(n).setMinWidth(n2);
        this.resultsTable.getColumnModel().getColumn(n).setMaxWidth(n2);
        this.resultsTable.getColumnModel().getColumn(n).setPreferredWidth(n2);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.resultsTable = new JTableExtended();
        this.labelEntriesFound = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.menuEditEntry = new JMenuItem();
        this.menuRefresh = new JMenuItem();
        this.setResizable(false);
        this.resultsTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.resultsTable);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.labelEntriesFound.setText("25 eintr\u00e4ge");
        this.labelEntriesFound.setMaximumSize(new Dimension(72, 24));
        this.labelEntriesFound.setMinimumSize(new Dimension(72, 24));
        this.labelEntriesFound.setPreferredSize(new Dimension(72, 24));
        this.getContentPane().add((Component)this.labelEntriesFound, "Last");
        this.jMenu1.setText("Edit");
        this.menuEditEntry.setText("Edit Entry");
        this.jMenu1.add(this.menuEditEntry);
        this.menuRefresh.setText("refresh list");
        this.jMenu1.add(this.menuRefresh);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private List<List<String>> convertTo(List<PhtScanResultDto> list) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        for (PhtScanResultDto phtScanResultDto : list) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(phtScanResultDto.getPlanetName());
            arrayList2.add(phtScanResultDto.getToiPlanetName() != null ? phtScanResultDto.getToiPlanetName() : "");
            arrayList2.add(ExofopPlanetStatus.parse(phtScanResultDto.getExofopDisposition()).name());
            arrayList2.add(phtScanResultDto.getPhtCandidate() != null ? this.getI18n().getString(phtScanResultDto.getPhtCandidate().toString()) : "");
            arrayList2.add(phtScanResultDto.getUserComment() != null ? phtScanResultDto.getUserComment() : "");
            arrayList2.add(phtScanResultDto.getPlanetensuchePlanetType() != null ? phtScanResultDto.getPlanetensuchePlanetType() : "");
            if (phtScanResultDto.getPlanetensucheDiscoveryConfirmed() == null) {
                arrayList2.add("");
            } else {
                arrayList2.add(phtScanResultDto.getPlanetensucheDiscoveryConfirmed() != false ? this.i18n.getString("ps_true") : this.i18n.getString("ps_false"));
            }
            arrayList2.add(phtScanResultDto.getPlanetensucheComment() != null ? phtScanResultDto.getPlanetensucheComment() : "");
            arrayList2.add(this.getI18n().getString("db_gui174"));
            arrayList2.add(this.getI18n().getString("db_gui175"));
            if (phtScanResultDto.getPlanetensuchePlanetType() != null || phtScanResultDto.getPhtCandidate() != null) {
                arrayList2.add(this.getI18n().getString("db_gui181"));
            } else {
                arrayList2.add("");
            }
            arrayList2.add("https://www.zooniverse.org/projects/nora-dot-eisner/planet-hunters-tess/talk/subjects/" + phtScanResultDto.getSubjectId());
            arrayList2.add("https://exofop.ipac.caltech.edu/tess/target.php?id=" + phtScanResultDto.getTicId());
            arrayList.add(arrayList2);
        }
        return arrayList;
    }
}

