/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtmatches;

import de.planetensuche.datenbank.importierer.csv.nasa.ExofopPlanetStatus;
import de.planetensuche.datenbank.phtmatches.PhtMatchesDialog;
import de.planetensuche.datenbankkern.api.kategorien.ExoplanetOverviewDto;
import de.planetensuche.datenbankkern.api.kategorien.IPlanetenRepository;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPhtTransitMatchesRepository;
import de.planetensuche.datenbankkern.querydsl5.PhtTransitMatches;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class PhtMatchesStatisticService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IPhtTransitMatchesRepository transitRepo;
    private final IPlanetenRepository planetenRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final ISprachcontainer i18n;
    private final PhtMatchesDialog dialog;

    public PhtMatchesStatisticService(IPhtTransitMatchesRepository iPhtTransitMatchesRepository, IPlanetenRepository iPlanetenRepository, IObjektnamenRepository iObjektnamenRepository, ISprachcontainer iSprachcontainer, PhtMatchesDialog phtMatchesDialog) {
        this.transitRepo = iPhtTransitMatchesRepository;
        this.planetenRepository = iPlanetenRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.i18n = iSprachcontainer;
        this.dialog = phtMatchesDialog;
    }

    public void showStatistic(String string) {
        this.dialog.appendAusgabe(this.i18n.getString("db_m480", this.transitRepo.countAllPlanets(), this.transitRepo.countAllStars()));
        long l = this.transitRepo.countMatchesWithExofopState(ExofopPlanetStatus.PLANET_CANDIDATE.getExofopKuerzel());
        this.dialog.appendAusgabe(this.i18n.getString("db_m477", string, l));
        long l2 = this.transitRepo.countMatchesWithExofopState(List.of(ExofopPlanetStatus.CONFIRMED_PLANET.getExofopKuerzel(), ExofopPlanetStatus.KNOWN_PLANET.getExofopKuerzel()));
        this.dialog.appendAusgabe(this.i18n.getString("db_m478", string, l2));
        long l3 = this.transitRepo.countMatchesWithExofopState(List.of(ExofopPlanetStatus.AMBIGUOUS_PLANET_CANDIDATE.getExofopKuerzel(), ExofopPlanetStatus.FALSE_ALARM.getExofopKuerzel(), ExofopPlanetStatus.FALSE_POSITIVE.getExofopKuerzel(), ExofopPlanetStatus.ECLIPSING_BINARY.getExofopKuerzel(), ExofopPlanetStatus.OTHER.getExofopKuerzel()));
        this.dialog.appendAusgabe(this.i18n.getString("db_m479", string, l3));
        List<ExoplanetOverviewDto> list = this.planetenRepository.getExoplanetsByDiscovererLastName(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase());
        int n = this.countCandidates(list);
        int n2 = this.countConfirmed(list);
        this.dialog.appendAusgabe(this.i18n.getString("db_m481", n, n2));
        int n3 = this.countUserCandidatesNotPublishedByPht(list);
        this.dialog.appendAusgabe(this.i18n.getString("db_m482", string, n3));
        if (n > 0) {
            long l4 = l - (long)n3;
            double d = (double)Math.round((double)l4 * 1000.0 / (double)n) / 10.0;
            this.dialog.appendAusgabe(this.i18n.getString("db_m484", string, d));
        }
        Pair<Integer, Integer> pair = this.countConfirmedAndUnconfirmedUserPlanetsInPlanetensuche();
        this.dialog.appendAusgabe(this.i18n.getString("db_m483", string, pair.getLeft(), pair.getRight()));
        this.logger.debug("PHT statistik ende");
    }

    private int countCandidates(List<ExoplanetOverviewDto> list) {
        int n = 0;
        for (ExoplanetOverviewDto exoplanetOverviewDto : list) {
            if (exoplanetOverviewDto.isConfirmed()) continue;
            ++n;
        }
        return n;
    }

    private int countConfirmed(List<ExoplanetOverviewDto> list) {
        int n = 0;
        for (ExoplanetOverviewDto exoplanetOverviewDto : list) {
            if (!exoplanetOverviewDto.isConfirmed()) continue;
            ++n;
        }
        return n;
    }

    private int countUserCandidatesNotPublishedByPht(List<ExoplanetOverviewDto> list) {
        List<PhtTransitMatches> list2 = this.transitRepo.findScanResults();
        int n = 0;
        List list3 = list.stream().map(exoplanetOverviewDto -> exoplanetOverviewDto.getPlanetName()).collect(Collectors.toList());
        for (PhtTransitMatches phtTransitMatches : list2) {
            if (!ExofopPlanetStatus.parse(phtTransitMatches.getExofopState()).isPlanetCandidate()) continue;
            String string = phtTransitMatches.getPlanetId();
            boolean bl = false;
            for (String string2 : list3) {
                if (!string2.contains(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            ++n;
        }
        return n;
    }

    private Pair<Integer, Integer> countConfirmedAndUnconfirmedUserPlanetsInPlanetensuche() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List<PhtTransitMatches> list = this.transitRepo.findScanResults();
        this.logger.debug("found " + list.size() + " scan results for statistics");
        for (PhtTransitMatches phtTransitMatches : list) {
            String string = phtTransitMatches.getPlanetId();
            ExofopPlanetStatus exofopPlanetStatus = ExofopPlanetStatus.parse(phtTransitMatches.getExofopState());
            if (exofopPlanetStatus.isPlanetCandidate()) {
                arrayList2.add(string);
                continue;
            }
            if (!exofopPlanetStatus.isConfirmedPlanet()) continue;
            arrayList.add(string);
        }
        int n = 0;
        int n2 = 0;
        try {
            if (!arrayList.isEmpty()) {
                n = this.objektnamenRepository.countNamen(arrayList);
            }
        }
        catch (SQLException sQLException) {
            this.logger.error("error on counting confirmed exoplanets " + String.valueOf(arrayList), sQLException);
        }
        try {
            if (!arrayList2.isEmpty()) {
                n2 = this.objektnamenRepository.countNamen(arrayList2);
            }
        }
        catch (SQLException sQLException) {
            this.logger.error("error on counting unconfirmed exoplanets " + String.valueOf(arrayList2), sQLException);
        }
        return Pair.of(n, n2);
    }
}

