/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtmatches;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.PlanetTypeDetectorService;
import de.planetensuche.datenbank.phtmatches.PhtScanResultDto;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.querydsl5.PhtTransitMatches;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PhtScanResultMapper {
    private final ILogging logger;
    private final IPlanetensucheObjektRepository psRepo;
    private final PlanetTypeDetectorService planetenTypErmittelnService;

    public PhtScanResultMapper(IPlanetensucheObjektRepository iPlanetensucheObjektRepository, PlanetTypeDetectorService planetTypeDetectorService) {
        this.psRepo = iPlanetensucheObjektRepository;
        this.planetenTypErmittelnService = planetTypeDetectorService;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public List<PhtScanResultDto> convertTo(List<PhtTransitMatches> list) {
        ArrayList<PhtScanResultDto> arrayList = new ArrayList<PhtScanResultDto>();
        for (PhtTransitMatches phtTransitMatches : list) {
            arrayList.add(this.convertTo(phtTransitMatches));
        }
        return arrayList;
    }

    private PhtScanResultDto convertTo(PhtTransitMatches phtTransitMatches) {
        PhtScanResultDto phtScanResultDto = new PhtScanResultDto();
        phtScanResultDto.setExofopDisposition(phtTransitMatches.getExofopState());
        phtScanResultDto.setPlanetName(phtTransitMatches.getPlanetId());
        phtScanResultDto.setSubjectId(phtTransitMatches.getMatchedSubjectId());
        phtScanResultDto.setTicId(phtTransitMatches.getTicId());
        phtScanResultDto.setUserComment(phtTransitMatches.getUserComment());
        try {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.psRepo.read(phtTransitMatches.getPlanetId());
            if (iPlanetensucheObjekt != null) {
                phtScanResultDto.setPlanetensucheComment(iPlanetensucheObjekt.getNotiz());
                phtScanResultDto.setPlanetensucheDiscoveryConfirmed(iPlanetensucheObjekt.isEntdeckungBestaetigt());
                for (String string : iPlanetensucheObjekt.getObjektNamen()) {
                    if (!string.startsWith("TOI")) continue;
                    phtScanResultDto.setToiPlanetName(string);
                    break;
                }
                boolean bl = iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().containsKey(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase());
                phtScanResultDto.setPhtCandidate(bl);
                if (!iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
                    double d = 11.194418312950768 * iPlanetensucheObjekt.getDurchmesser();
                    String string = this.planetenTypErmittelnService.getType(d);
                    phtScanResultDto.setPlanetensuchePlanetType(string);
                }
            }
        }
        catch (IllegalArgumentException | SQLException exception) {
            this.logger.warn("could not load planet candidate '" + phtTransitMatches.getPlanetId() + "'", exception);
        }
        return phtScanResultDto;
    }
}

