/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtmatches.service;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class DateTimeUtil {
    private static final int BJD_START = 2457000;

    private DateTimeUtil() {
    }

    public static double convertToPhtDay(Double d, double d2) {
        return d - 2457000.0 - d2;
    }

    public static double convertDiscoveryDateToTimestamp(String string) {
        if (string.startsWith("00.00.")) {
            String string2 = string.substring(6);
            return DateTimeUtil.convertToBjd(Timestamp.valueOf(string2 + "-01-01 00:00:00"));
        }
        String string3 = DateTimeUtil.convertToEnglish(string);
        return DateTimeUtil.convertToBjd(Timestamp.valueOf(string3 + " 00:00:00"));
    }

    public static String convertToEnglish(String string) {
        String string2 = string.substring(6);
        String string3 = string.substring(0, 2);
        String string4 = string.substring(3, 5);
        return string2 + "-" + string4 + "-" + string3;
    }

    public static double convertToBjd(Timestamp timestamp) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        int n = calendar.get(2) + 1;
        int n2 = calendar.get(1);
        int n3 = calendar.get(5);
        if (n <= 2) {
            n += 12;
            --n2;
        }
        double d = Math.floor((double)n2 / 400.0) - Math.floor((double)n2 / 100.0);
        int n4 = calendar.get(13);
        int n5 = calendar.get(12);
        int n6 = calendar.get(11);
        double d2 = Math.floor(365.25 * (double)n2) + Math.floor(30.6001 * (double)(n + 1)) + d + 1720996.5 + (double)n3 + ((double)n6 + (double)n5 / 60.0 + (double)n4 / 3600.0) / 24.0;
        return d2;
    }
}

