/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtmatches.service;

import de.planetensuche.datenbank.importierer.csv.base.CsvDto;
import de.planetensuche.datenbank.importierer.csv.nasa.CtoiCsvZuDtoKonverter;
import de.planetensuche.datenbank.importierer.csv.nasa.ExofopCsvDownloader;
import de.planetensuche.datenbank.importierer.csv.nasa.ToiCsvZuDtoKonverter;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbank.phtmatches.IScanProgress;
import de.planetensuche.datenbankkern.api.repos.IPhtTransitMatchesRepository;
import de.planetensuche.datenbankkern.querydsl5.PhtTransitMatches;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.List;

public class PhtTransitImporter {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IPhtTransitMatchesRepository repo;
    private final Katalogerkenner katalogerkenner;

    public PhtTransitImporter(IPhtTransitMatchesRepository iPhtTransitMatchesRepository, Katalogerkenner katalogerkenner) {
        this.repo = iPhtTransitMatchesRepository;
        this.katalogerkenner = katalogerkenner;
    }

    public void insertOrUpdatePlanets(IScanProgress iScanProgress) throws UnknownHostException {
        try {
            iScanProgress.printTextDownloadData();
            ExofopCsvDownloader exofopCsvDownloader = new ExofopCsvDownloader("temp", true);
            File file = exofopCsvDownloader.downloadCtoiFile();
            File file2 = exofopCsvDownloader.downloadToiFile();
            CtoiCsvZuDtoKonverter ctoiCsvZuDtoKonverter = new CtoiCsvZuDtoKonverter();
            ToiCsvZuDtoKonverter toiCsvZuDtoKonverter = new ToiCsvZuDtoKonverter(this.katalogerkenner);
            List<CsvDto> list = ctoiCsvZuDtoKonverter.leseDtos(file);
            list.addAll(toiCsvZuDtoKonverter.leseDtos(file2));
            iScanProgress.updateProgress(0, list.size());
            int n = 0;
            int n2 = 0;
            for (CsvDto csvDto : list) {
                if (csvDto.getPlanetTransitBjd() != null) {
                    if (!this.repo.existsPlanet(csvDto.getPlanetName())) {
                        var12_14 = this.convertToEntity(csvDto);
                        this.repo.save(var12_14);
                        ++n;
                    } else {
                        var12_14 = this.repo.read(csvDto.getPlanetName());
                        var12_14.setExofopState(csvDto.getPlanetExofopDisposition());
                        this.repo.save(var12_14);
                    }
                }
                iScanProgress.updateProgress(++n2, list.size());
            }
            this.logger.info(n + " new C/TOI entries inserted");
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (IOException | RuntimeException | SQLException exception) {
            this.logger.error("", exception);
        }
    }

    private PhtTransitMatches convertToEntity(CsvDto csvDto) {
        PhtTransitMatches phtTransitMatches = new PhtTransitMatches();
        phtTransitMatches.setChecked(false);
        phtTransitMatches.setEpochBjd(csvDto.getPlanetTransitBjd());
        phtTransitMatches.setEpochBjdError(csvDto.getPlanetTransitBjdError());
        if (phtTransitMatches.getEpochBjdError() == null) {
            phtTransitMatches.setEpochBjdError(0.0);
        }
        phtTransitMatches.setExofopEntryCreated(csvDto.getExofopEntryCreated());
        phtTransitMatches.setExofopState(csvDto.getPlanetExofopDisposition());
        phtTransitMatches.setPeriodDays(csvDto.getPlanetUmlaufszeit());
        phtTransitMatches.setPeriodDaysError(csvDto.getPlanetUmlaufszeitError());
        phtTransitMatches.setPlanetId(csvDto.getPlanetName());
        phtTransitMatches.setTicId(this.findTicId(csvDto));
        return phtTransitMatches;
    }

    private long findTicId(CsvDto csvDto) {
        if (csvDto.getSternName().startsWith("TIC ")) {
            return Long.parseLong(csvDto.getSternName().substring(4));
        }
        for (String string : csvDto.getWeitereSternnamen()) {
            if (!string.startsWith("TIC ")) continue;
            return Long.parseLong(string.substring(4));
        }
        throw new IllegalStateException("no TIC id found for C/TOI entry " + csvDto.getSternName() + "?!");
    }
}

