/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.phtmatches.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.importierer.csv.nasa.ExofopPlanetStatus;
import de.planetensuche.datenbank.phtmatches.IScanProgress;
import de.planetensuche.datenbank.phtmatches.service.DateTimeUtil;
import de.planetensuche.datenbank.phtmatches.service.IPhtTransitMatchFinder;
import de.planetensuche.datenbank.phtmatches.service.PhtInfoDialogDto;
import de.planetensuche.datenbank.phtmatches.service.UserFindingsRawDataDto;
import de.planetensuche.datenbank.phtmatches.service.UserTransitDto;
import de.planetensuche.datenbankkern.api.repos.IPhtTransitMatchesRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.querydsl5.PhtTransitMatches;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class SlowPhtTransitMatchFinder
implements IPhtTransitMatchFinder {
    private final int timeout = 6000;
    private final int bjdStart = 2457000;
    private final IPhtTransitMatchesRepository transitMatchesRepo;
    private final IPlanetensucheObjektRepository planetensucheRepo;
    private final RestTemplate restTemplate;
    private final ILogging logger;
    private volatile boolean stopScan = false;

    @Inject
    public SlowPhtTransitMatchFinder(IPhtTransitMatchesRepository iPhtTransitMatchesRepository, IPlanetensucheObjektRepository iPlanetensucheObjektRepository) {
        this.transitMatchesRepo = iPhtTransitMatchesRepository;
        this.planetensucheRepo = iPlanetensucheObjektRepository;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setConnectTimeout(6000);
        simpleClientHttpRequestFactory.setReadTimeout(6000);
        this.restTemplate = new RestTemplate();
        this.restTemplate.setMessageConverters(Arrays.asList(new MappingJackson2HttpMessageConverter()));
        this.restTemplate.setRequestFactory(simpleClientHttpRequestFactory);
    }

    @Override
    public void startScan(String string, IScanProgress iScanProgress) {
        this.stopScan = false;
        try {
            List<List<String>> list = this.getDataFromPhtApiLongRequest("https://mast.stsci.edu/phad/api/v0.1/access/transit/users?username=" + string);
            if (Check.isEmpty(list)) {
                iScanProgress.printTextUserHasNoTransits();
                return;
            }
            this.savePhtUsernameInKonfigFile(string);
            iScanProgress.printTextUserTransitCount(list.size());
            iScanProgress.printTextScanPlanetCandidateList();
            List<PhtTransitMatches> list2 = this.transitMatchesRepo.findUnprocessedList();
            int n = -1;
            for (PhtTransitMatches phtTransitMatches : list2) {
                Object object;
                if (this.stopScan) {
                    this.logger.info("scan stopped");
                    iScanProgress.printTextScanStoppedUser();
                    return;
                }
                iScanProgress.updateProgress(++n, list2.size());
                iScanProgress.printScanCurrentlyPcName(phtTransitMatches.getPlanetId(), Optional.empty());
                try {
                    String string2 = "https://mast.stsci.edu/phad/api/v0.1/access/transit?tic_id=" + phtTransitMatches.getTicId();
                    object = this.getDataFromPhtApi(string2);
                    if (Check.isEmpty(object)) {
                        phtTransitMatches.setChecked(true);
                        this.transitMatchesRepo.save(phtTransitMatches);
                        continue;
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        List list3 = (List)iterator.next();
                        hashSet.add((String)list3.get(0));
                    }
                    this.checkAllSubjectsForTicId(hashSet, string, phtTransitMatches, iScanProgress);
                }
                catch (SocketTimeoutException | ResourceAccessException exception) {
                    object = "skip " + phtTransitMatches.getPlanetId() + " because of " + exception.getMessage();
                    this.logger.warn(object, exception);
                    iScanProgress.printMsg((String)object);
                }
            }
            this.logger.debug("PHT scan finished");
            iScanProgress.updateProgress(100, 100);
        }
        catch (Exception exception) {
            iScanProgress.printTextScanStoppedError();
            this.logger.error("user name '" + string + "' for scan used", exception);
        }
    }

    private void savePhtUsernameInKonfigFile(String string) {
        try {
            IKonfigurator iKonfigurator = KonfiguratorFabrik.getKonfigurator();
            KonfigurationDTO konfigurationDTO = iKonfigurator.read();
            konfigurationDTO.setPhtUsername(string);
            iKonfigurator.write(konfigurationDTO);
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
    }

    private void checkAllSubjectsForTicId(Set<String> set, String string, PhtTransitMatches phtTransitMatches, IScanProgress iScanProgress) throws RestClientException, SQLException, IOException, SocketTimeoutException, InterruptedException {
        for (String string2 : set) {
            if (this.stopScan) {
                return;
            }
            iScanProgress.printScanCurrentlyPcName(phtTransitMatches.getPlanetId(), Optional.of(string2));
            String string3 = "https://mast.stsci.edu/phad/api/v0.1/access/transit/users?subject_id=" + string2 + "&username=" + string;
            List<List<String>> list = this.getDataFromPhtApi(string3);
            if (Check.isEmpty(list)) continue;
            List<UserTransitDto> list2 = this.createUserTransitList(list, string2);
            PhtInfoDialogDto phtInfoDialogDto = this.findMetaDataForSubjectId(string2);
            double d = this.findSectorStartForSubjectId(phtInfoDialogDto);
            for (UserTransitDto userTransitDto : list2) {
                boolean bl;
                if (this.stopScan) {
                    return;
                }
                if (!this.matchPlanetTransitMarks(userTransitDto, d, phtTransitMatches) || !(bl = this.isExofopEntryCreatedAfterUserDiscovery(phtTransitMatches, phtInfoDialogDto, string2))) continue;
                phtTransitMatches.setChecked(true);
                phtTransitMatches.setMatchedSubjectId(Long.parseLong(string2));
                this.transitMatchesRepo.save(phtTransitMatches);
                String string4 = "user " + string + " found exoplanet candidate " + phtTransitMatches.getPlanetId() + " in PHT talk https://www.zooniverse.org/projects/nora-dot-eisner/planet-hunters-tess/talk/subjects/" + string2;
                this.logger.info(string4);
                iScanProgress.printMsg(string4);
                return;
            }
        }
        this.logger.debug("user " + string + " missed exoplanet " + phtTransitMatches.getPlanetId());
        phtTransitMatches.setChecked(true);
        this.transitMatchesRepo.save(phtTransitMatches);
    }

    private List<UserTransitDto> createUserTransitList(List<List<String>> list, String string) {
        ArrayList<UserTransitDto> arrayList = new ArrayList<UserTransitDto>();
        for (List<String> list2 : list) {
            arrayList.add(new UserTransitDto(string, list2.get(3), list2.get(4)));
        }
        return arrayList;
    }

    private boolean isExofopEntryCreatedAfterUserDiscovery(PhtTransitMatches phtTransitMatches, PhtInfoDialogDto phtInfoDialogDto, String string) {
        double d = this.getPlanetDiscoveryDate(phtTransitMatches);
        double d2 = this.findSectorEndForSubjectId(phtInfoDialogDto) + 2457000.0;
        double d3 = d2 + 28.0;
        this.logger.debug("first possible user discovery bjd: " + d3 + " for subject id " + string);
        boolean bl = d > d3;
        return bl;
    }

    private double getPlanetDiscoveryDate(PhtTransitMatches phtTransitMatches) {
        if (ExofopPlanetStatus.parse(phtTransitMatches.getExofopState()).equals((Object)ExofopPlanetStatus.KNOWN_PLANET)) {
            try {
                String string;
                IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheRepo.read(phtTransitMatches.getPlanetId());
                if (iPlanetensucheObjekt != null && Check.isFilled(string = iPlanetensucheObjekt.getEntdeckungsdatum())) {
                    return DateTimeUtil.convertDiscoveryDateToTimestamp(string);
                }
            }
            catch (IllegalArgumentException | SQLException exception) {
                this.logger.warn("read of exofop known planet " + phtTransitMatches.getPlanetId() + " failed", exception);
            }
        }
        return DateTimeUtil.convertToBjd(phtTransitMatches.getExofopEntryCreated());
    }

    private List<List<String>> getDataFromPhtApi(String string) throws RestClientException, InterruptedException {
        RestClientException restClientException = null;
        for (int i = 1; i < 3; ++i) {
            try {
                Thread.sleep(550L * (long)i);
                ResponseEntity<UserFindingsRawDataDto> responseEntity = this.restTemplate.getForEntity(string, UserFindingsRawDataDto.class, new Object[0]);
                UserFindingsRawDataDto userFindingsRawDataDto = (UserFindingsRawDataDto)responseEntity.getBody();
                List<List<String>> list = userFindingsRawDataDto.getData();
                return list;
            }
            catch (RestClientException restClientException2) {
                restClientException = restClientException2;
                continue;
            }
        }
        if (restClientException != null) {
            throw restClientException;
        }
        return null;
    }

    private List<List<String>> getDataFromPhtApiLongRequest(String string) throws RestClientException, InterruptedException {
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setConnectTimeout(20000);
        simpleClientHttpRequestFactory.setReadTimeout(20000);
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(simpleClientHttpRequestFactory);
        restTemplate.setMessageConverters(Arrays.asList(new MappingJackson2HttpMessageConverter()));
        ResponseEntity<UserFindingsRawDataDto> responseEntity = restTemplate.getForEntity(string, UserFindingsRawDataDto.class, new Object[0]);
        UserFindingsRawDataDto userFindingsRawDataDto = (UserFindingsRawDataDto)responseEntity.getBody();
        List<List<String>> list = userFindingsRawDataDto.getData();
        return list;
    }

    private boolean matchPlanetTransitMarks(UserTransitDto userTransitDto, double d, PhtTransitMatches phtTransitMatches) {
        double d2;
        double d3 = d + 2457000.0 + userTransitDto.getCenter();
        double d4 = phtTransitMatches.getEpochBjd() > d3 ? phtTransitMatches.getEpochBjd() - d3 : d3 - phtTransitMatches.getEpochBjd();
        if (d4 <= (d2 = phtTransitMatches.getEpochBjdError() + userTransitDto.getWidth())) {
            return true;
        }
        this.logger.debug("user marked planet transit BJD " + d3);
        if (phtTransitMatches.getPeriodDays() != null) {
            for (int i = 1; i < 200; ++i) {
                for (int j = 0; j < 2; ++j) {
                    d3 = j == 0 ? d + 2457000.0 + userTransitDto.getCenter() - phtTransitMatches.getPeriodDays() * (double)i : d + 2457000.0 + userTransitDto.getCenter() + phtTransitMatches.getPeriodDays() * (double)i;
                    d4 = phtTransitMatches.getEpochBjd() > d3 ? phtTransitMatches.getEpochBjd() - d3 : d3 - phtTransitMatches.getEpochBjd();
                    d2 = phtTransitMatches.getEpochBjdError() + userTransitDto.getWidth();
                    if (phtTransitMatches.getPeriodDaysError() != null) {
                        d2 += phtTransitMatches.getPeriodDaysError().doubleValue();
                    }
                    if (!(d4 <= d2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private double findSectorStartForSubjectId(PhtInfoDialogDto phtInfoDialogDto) throws MalformedURLException, IOException {
        return phtInfoDialogDto.getSubjects()[0].getMetadata().getSectorStart();
    }

    private double findSectorEndForSubjectId(PhtInfoDialogDto phtInfoDialogDto) {
        double d = phtInfoDialogDto.getSubjects()[0].getMetadata().getSectorEnd();
        return d;
    }

    private PhtInfoDialogDto findMetaDataForSubjectId(String string) throws IOException, JsonProcessingException, MalformedURLException, SocketTimeoutException {
        Object object;
        String string2 = "https://www.zooniverse.org/api/subjects/" + string + "?http_cache=true";
        URL uRL = new URL(string2);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(6000);
        uRLConnection.setReadTimeout(6000);
        uRLConnection.addRequestProperty("Accept", "application/vnd.api+json; version=1");
        StringBuilder stringBuilder = new StringBuilder();
        try (Object object2 = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));){
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                stringBuilder.append((String)object);
            }
        }
        object2 = new ObjectMapper();
        ((ObjectMapper)object2).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        object = ((ObjectMapper)object2).readValue(stringBuilder.toString(), PhtInfoDialogDto.class);
        return object;
    }

    @Override
    public void stopScan() {
        this.stopScan = true;
    }

    @Override
    public void resetScan() {
        try {
            this.transitMatchesRepo.resetScanResults();
        }
        catch (SQLException sQLException) {
            this.logger.error("error in reset results", sQLException);
        }
    }
}

