/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.reorganisieren;

import de.planetensuche.datenbank.dbbereinigung.KorrigiereDatenTabelleDAO;
import de.planetensuche.datenbank.dbbereinigung.KorrigiereEntdeckerTabelleDAO;
import de.planetensuche.datenbank.dbbereinigung.KorrigiereNamenTabelleDAO;
import de.planetensuche.datenbank.dbbereinigung.KorrigiereZTTabelleDAO;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.StatusGui;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JOptionPane;

public final class Aufraeumthread
extends Thread {
    private final StatusGui statusgui;
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private final boolean fehlerLoeschen;
    private final boolean stillesAufraeumen;
    private final IDatenbankverbinder datenbankverbinder;

    public Aufraeumthread(boolean bl, boolean bl2, IDatenbankverbinder iDatenbankverbinder) {
        this.fehlerLoeschen = bl;
        this.stillesAufraeumen = bl2;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.statusgui = new StatusGui();
        this.statusgui.setTitle(this.sprache.getString("db_menu_12"));
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void run() {
        this.dbAufraeumenStarten();
    }

    public boolean dbAufraeumenStarten() {
        this.logging.info("DB Reorganisation gestartet");
        long l = System.currentTimeMillis();
        try {
            this.statusgui.setFortschritt(0);
            this.statusgui.setLauftext(this.sprache.getString("db_m314"));
            KorrigiereNamenTabelleDAO korrigiereNamenTabelleDAO = new KorrigiereNamenTabelleDAO();
            KorrigiereEntdeckerTabelleDAO korrigiereEntdeckerTabelleDAO = new KorrigiereEntdeckerTabelleDAO(this.datenbankverbinder);
            KorrigiereZTTabelleDAO korrigiereZTTabelleDAO = new KorrigiereZTTabelleDAO();
            KorrigiereDatenTabelleDAO korrigiereDatenTabelleDAO = new KorrigiereDatenTabelleDAO();
            this.statusgui.setFortschritt(30);
            this.statusgui.setLauftext(this.sprache.getString("db_m435"));
            korrigiereNamenTabelleDAO.loescheNamenMitFehlerhafterDatenid(this.fehlerLoeschen);
            this.logging.debug("loescheNamenMitFehlerhafterDatenid: " + (System.currentTimeMillis() - l) + " ms");
            this.statusgui.setFortschritt(40);
            this.statusgui.setLauftext(this.sprache.getString("db_m436"));
            korrigiereEntdeckerTabelleDAO.findeUndLoescheUngenutzteEntdecker(this.fehlerLoeschen);
            this.logging.debug("loescheUngenutzteEntdecker: " + (System.currentTimeMillis() - l) + " ms");
            this.statusgui.setFortschritt(60);
            this.statusgui.setLauftext(this.sprache.getString("db_m437"));
            korrigiereEntdeckerTabelleDAO.findeUndLoescheEntdeckerMitFehlerhafterDatenid(this.fehlerLoeschen);
            this.logging.debug("loescheEntdeckerMitFehlerhafterDatenid: " + (System.currentTimeMillis() - l) + " ms");
            this.statusgui.setFortschritt(70);
            this.statusgui.setLauftext(this.sprache.getString("db_m438"));
            korrigiereZTTabelleDAO.loescheZTEintragMitFehlerhaftenIDs(this.fehlerLoeschen);
            this.logging.debug("loescheZTEintragMitFehlerhaftenIDs: " + (System.currentTimeMillis() - l) + " ms");
            this.statusgui.setFortschritt(80);
            this.statusgui.setLauftext(this.sprache.getString("db_m439"));
            korrigiereDatenTabelleDAO.loescheDatenOhneNamen(this.fehlerLoeschen);
            this.logging.debug("loescheDatenOhneNamen: " + (System.currentTimeMillis() - l) + " ms");
            korrigiereDatenTabelleDAO.korrigiereDatenWelcheAufSichSelbstReferenzieren(this.fehlerLoeschen);
            this.logging.debug("loescheDatenWelcheAufSichSelbstReferenzieren: " + (System.currentTimeMillis() - l) + " ms");
            this.logging.info("DB Reorganisation beendet");
            this.statusgui.dispose();
            if (!this.stillesAufraeumen) {
                JOptionPane.showMessageDialog(null, this.sprache.getString("db_m432"), this.sprache.getString("db_m432_titel"), 1);
            }
            return true;
        }
        catch (RuntimeException | SQLException exception) {
            this.logging.info("DB Reorganisation abgebrochen");
            this.statusgui.dispose();
            this.logging.error(exception);
            return false;
        }
    }
}

