/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.reparatur;

import de.planetensuche.datenbank.api.IDatenbankDialog;
import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.api.ISQLScript;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.reparatur.ReparaturDialog;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.File;
import javax.swing.JOptionPane;

public final class Repairthread
extends Thread {
    private final ReparaturDialog repairgui;
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private final IDatenbankDialog datenbank;
    private final IStart start;
    private final IDAOhighService daoHighService;
    private final ISQLScript sqlScriptService;

    public Repairthread(ReparaturDialog reparaturDialog, IDatenbankDialog iDatenbankDialog, ParameterDto parameterDto, IDAOhighService iDAOhighService, ISQLScript iSQLScript) {
        this.repairgui = reparaturDialog;
        this.sprache = parameterDto.getSprache();
        this.datenbank = iDatenbankDialog;
        this.start = null;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.daoHighService = iDAOhighService;
        this.sqlScriptService = iSQLScript;
    }

    public Repairthread(ReparaturDialog reparaturDialog, IStart iStart, ParameterDto parameterDto, IDAOhighService iDAOhighService, ISQLScript iSQLScript) {
        this.repairgui = reparaturDialog;
        this.sprache = parameterDto.getSprache();
        this.datenbank = null;
        this.start = iStart;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.daoHighService = iDAOhighService;
        this.sqlScriptService = iSQLScript;
    }

    @Override
    public void run() {
        try {
            boolean bl = false;
            bl = this.daoHighService.createDB(this.repairgui);
            if (bl) {
                this.repairgui.setErfolgreich(true);
            } else {
                this.repairgui.setErfolgreich(false);
            }
            this.repairgui.setText(this.sprache.getString("db_m156") + " " + Boolean.toString(bl));
            this.logging.info(this.sprache.getString("db_m156") + " " + Boolean.toString(bl));
            bl = false;
            if (this.repairgui.isErfolgreich()) {
                File file = new File("database" + File.separator + "dbmain.sql");
                bl = this.sqlScriptService.loadSQLScript(file, this.repairgui, null);
                if (bl && this.repairgui.isErfolgreich()) {
                    this.repairgui.setErfolgreich(true);
                } else {
                    this.repairgui.setErfolgreich(false);
                }
            }
            this.repairgui.setFortschritt(98);
            this.repairgui.setText(this.sprache.getString("db_m157") + " " + Boolean.toString(bl));
            this.logging.info(this.sprache.getString("db_m157") + " " + Boolean.toString(bl));
            this.repairgui.setFortschritt(99);
            this.repairgui.setText(this.sprache.getString("db_m158") + " " + Boolean.toString(bl));
            this.logging.info(this.sprache.getString("db_m158") + " " + Boolean.toString(bl));
            if (this.datenbank != null) {
                this.datenbank.updateEnde();
            } else {
                this.start.exitApp();
            }
            this.repairgui.setFortschritt(100);
            this.repairgui.setText(this.sprache.getString("db_m159") + " " + Boolean.toString(this.repairgui.isErfolgreich()));
            this.logging.info(this.sprache.getString("db_m159") + " " + Boolean.toString(this.repairgui.isErfolgreich()));
            if (this.repairgui.isErfolgreich()) {
                JOptionPane.showMessageDialog(this.repairgui, this.sprache.getString("db_m160"), this.sprache.getString("db_m160_titel"), 1);
                this.repairgui.dispose();
                this.interrupt();
            } else {
                JOptionPane.showMessageDialog(this.repairgui, this.sprache.getString("db_f33"), this.sprache.getString("db_f33_titel"), 0);
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
        }
    }
}

