/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.reparatur;

import de.planetensuche.datenbank.api.IDatenbankDialog;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.api.IReparaturDialog;
import de.planetensuche.datenbank.dbmodel.api.ISQLScript;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.reparatur.Repairthread;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class ReparaturDialog
extends Basisdialog
implements IReparaturDialog {
    private final ISprachcontainer sprache;
    private final ParameterDto parameter;
    private final IDatenbankDialog datenbank;
    private boolean erfolgreich;
    private final IDAOhighService daoHighService;
    private final ISQLScript sqlScriptService;
    private JTextArea ausgabe;
    private JProgressBar fortschritt;
    private JScrollPane jScrollPane2;
    private JLabel prozent;
    private JLabel warnung;

    public ReparaturDialog(boolean bl, ParameterDto parameterDto, IDatenbankDialog iDatenbankDialog, IDAOhighService iDAOhighService, ISQLScript iSQLScript) {
        super(BasisdialogId.DATENBANK_REPARATUR);
        this.initComponents();
        this.sprache = parameterDto.getSprache();
        this.parameter = parameterDto;
        this.datenbank = iDatenbankDialog;
        this.daoHighService = iDAOhighService;
        this.sqlScriptService = iSQLScript;
        this.getContentPane().setLayout(null);
        this.warnung.setText(this.sprache.getString("db_m161"));
        this.setTitle(this.sprache.getString("db_fenster2"));
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getGuiDesigner().addComponent(this.ausgabe, false);
        this.getGuiDesigner().addComponent(this.warnung, false);
        this.getGuiDesigner().addComponent(this.prozent, false);
        try {
            int n;
            if (bl) {
                JOptionPane.showMessageDialog(null, this.sprache.getString("db_m162"), this.sprache.getString("db_m162_titel"), 1);
                n = 0;
            } else {
                n = JOptionPane.showConfirmDialog(null, this.sprache.getString("db_m163"), this.sprache.getString("db_m163_titel"), 0);
            }
            if (n == 0) {
                this.startThread();
            } else {
                this.dispose();
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(null, this.sprache.getString("db_f16") + "\n" + exception.toString(), this.sprache.getString("db_f4_titel"), 0);
            this.dispose();
        }
    }

    private void startThread() {
        this.ausgabe.setText("");
        this.fortschritt.setValue(0);
        this.ausgabe.append(this.sprache.getString("db_m164") + " true\n");
        this.getLogger().info(this.sprache.getString("db_m164") + " true");
        Repairthread repairthread = new Repairthread(this, this.datenbank, this.parameter, this.daoHighService, this.sqlScriptService);
        repairthread.start();
    }

    @Override
    public void setFortschritt(int n) {
        this.fortschritt.setValue(n);
        this.prozent.setText(n + " %");
    }

    @Override
    public void incrementFortschritt() {
        this.fortschritt.setValue(this.getFortschritt() + 1);
        this.prozent.setText(this.getFortschritt() + " %");
    }

    @Override
    public int getFortschritt() {
        return this.fortschritt.getValue();
    }

    @Override
    public void setText(String string) {
        this.ausgabe.append(string + "\n");
    }

    public boolean isErfolgreich() {
        return this.erfolgreich;
    }

    public void setErfolgreich(boolean bl) {
        this.erfolgreich = bl;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.ausgabe = new JTextArea();
        this.fortschritt = new JProgressBar();
        this.prozent = new JLabel();
        this.warnung = new JLabel();
        this.setTitle("Datenbank reparatur");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.ausgabe.setColumns(20);
        this.ausgabe.setEditable(false);
        this.ausgabe.setRows(5);
        this.jScrollPane2.setViewportView(this.ausgabe);
        this.getContentPane().add(this.jScrollPane2);
        this.jScrollPane2.setBounds(20, 120, 310, 110);
        this.getContentPane().add(this.fortschritt);
        this.fortschritt.setBounds(20, 240, 260, 14);
        this.prozent.setText("  0 %");
        this.getContentPane().add(this.prozent);
        this.prozent.setBounds(290, 240, 40, 14);
        this.warnung.setText("<html>Die Datenbank wird jetzt neu geschrieben. Dies kann einige Sekunden bis Minuten dauern.<br>Bitte brechen Sie den Vorgang nicht ab, da sonst Daten verloren gehen koennen!</html>");
        this.getContentPane().add(this.warnung);
        this.warnung.setBounds(20, 10, 310, 100);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 361) / 2, (dimension.height - 296) / 2, 361, 296);
    }
}

