/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.tic;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.tic.VizierTicCatalogDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.datenbank.vizier.VotTableParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VizierTicCatalogQueryService {
    private final String baseUrl = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20%22IV/39/tic82%22.TIC,%20%20%20%22IV/39/tic82%22.HIP,%20%20%22IV/39/tic82%22.TYC,%20%20%22IV/39/tic82%22.UCAC4,%20%20%22IV/39/tic82%22.%222MASS%22,%20%22IV/39/tic82%22.objID,%20%20%22IV/39/tic82%22.WISEA,%20%20%22IV/39/tic82%22.GAIA,%20%20%22IV/39/tic82%22.KIC,%20%20%22IV/39/tic82%22.%22S/G%22,%20%20%22IV/39/tic82%22.Dist,%20%20%22IV/39/tic82%22.RAJ2000,%20%20%22IV/39/tic82%22.DEJ2000,%20%20%22IV/39/tic82%22.Bmag,%20%20%22IV/39/tic82%22.Vmag,%20%20%22IV/39/tic82%22.Teff,%20%20%22IV/39/tic82%22.Rad,%20%20%22IV/39/tic82%22.Mass,%20%20%22IV/39/tic82%22.Plx%20FROM%20%22IV/39/tic82%22%20WHERE";
    private final String baseUrlQueryByTicId = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20%22IV/39/tic82%22.TIC,%20%20%20%22IV/39/tic82%22.HIP,%20%20%22IV/39/tic82%22.TYC,%20%20%22IV/39/tic82%22.UCAC4,%20%20%22IV/39/tic82%22.%222MASS%22,%20%22IV/39/tic82%22.objID,%20%20%22IV/39/tic82%22.WISEA,%20%20%22IV/39/tic82%22.GAIA,%20%20%22IV/39/tic82%22.KIC,%20%20%22IV/39/tic82%22.%22S/G%22,%20%20%22IV/39/tic82%22.Dist,%20%20%22IV/39/tic82%22.RAJ2000,%20%20%22IV/39/tic82%22.DEJ2000,%20%20%22IV/39/tic82%22.Bmag,%20%20%22IV/39/tic82%22.Vmag,%20%20%22IV/39/tic82%22.Teff,%20%20%22IV/39/tic82%22.Rad,%20%20%22IV/39/tic82%22.Mass,%20%20%22IV/39/tic82%22.Plx%20FROM%20%22IV/39/tic82%22%20WHERE%20%22IV/39/tic82%22.TIC=";
    private final String baseUrlQueryByKicId = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20%22IV/39/tic82%22.TIC,%20%20%20%22IV/39/tic82%22.HIP,%20%20%22IV/39/tic82%22.TYC,%20%20%22IV/39/tic82%22.UCAC4,%20%20%22IV/39/tic82%22.%222MASS%22,%20%22IV/39/tic82%22.objID,%20%20%22IV/39/tic82%22.WISEA,%20%20%22IV/39/tic82%22.GAIA,%20%20%22IV/39/tic82%22.KIC,%20%20%22IV/39/tic82%22.%22S/G%22,%20%20%22IV/39/tic82%22.Dist,%20%20%22IV/39/tic82%22.RAJ2000,%20%20%22IV/39/tic82%22.DEJ2000,%20%20%22IV/39/tic82%22.Bmag,%20%20%22IV/39/tic82%22.Vmag,%20%20%22IV/39/tic82%22.Teff,%20%20%22IV/39/tic82%22.Rad,%20%20%22IV/39/tic82%22.Mass,%20%20%22IV/39/tic82%22.Plx%20FROM%20%22IV/39/tic82%22%20WHERE%20%22IV/39/tic82%22.KIC=";
    private final String baseUrlQueryByGaiaDr2Id = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20%22IV/39/tic82%22.TIC,%20%20%20%22IV/39/tic82%22.HIP,%20%20%22IV/39/tic82%22.TYC,%20%20%22IV/39/tic82%22.UCAC4,%20%20%22IV/39/tic82%22.%222MASS%22,%20%22IV/39/tic82%22.objID,%20%20%22IV/39/tic82%22.WISEA,%20%20%22IV/39/tic82%22.GAIA,%20%20%22IV/39/tic82%22.KIC,%20%20%22IV/39/tic82%22.%22S/G%22,%20%20%22IV/39/tic82%22.Dist,%20%20%22IV/39/tic82%22.RAJ2000,%20%20%22IV/39/tic82%22.DEJ2000,%20%20%22IV/39/tic82%22.Bmag,%20%20%22IV/39/tic82%22.Vmag,%20%20%22IV/39/tic82%22.Teff,%20%20%22IV/39/tic82%22.Rad,%20%20%22IV/39/tic82%22.Mass,%20%20%22IV/39/tic82%22.Plx%20FROM%20%22IV/39/tic82%22%20WHERE%20%22IV/39/tic82%22.GAIA=";
    private final int timeoutInMs = 20000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<VizierTicCatalogDto> findByGaiaDr2Id(long l) {
        String string = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20%22IV/39/tic82%22.TIC,%20%20%20%22IV/39/tic82%22.HIP,%20%20%22IV/39/tic82%22.TYC,%20%20%22IV/39/tic82%22.UCAC4,%20%20%22IV/39/tic82%22.%222MASS%22,%20%22IV/39/tic82%22.objID,%20%20%22IV/39/tic82%22.WISEA,%20%20%22IV/39/tic82%22.GAIA,%20%20%22IV/39/tic82%22.KIC,%20%20%22IV/39/tic82%22.%22S/G%22,%20%20%22IV/39/tic82%22.Dist,%20%20%22IV/39/tic82%22.RAJ2000,%20%20%22IV/39/tic82%22.DEJ2000,%20%20%22IV/39/tic82%22.Bmag,%20%20%22IV/39/tic82%22.Vmag,%20%20%22IV/39/tic82%22.Teff,%20%20%22IV/39/tic82%22.Rad,%20%20%22IV/39/tic82%22.Mass,%20%20%22IV/39/tic82%22.Plx%20FROM%20%22IV/39/tic82%22%20WHERE%20%22IV/39/tic82%22.GAIA=" + l;
        return this.downloadData(string, "Gaia DR2 " + l);
    }

    public Optional<VizierTicCatalogDto> findByKicId(long l) {
        String string = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20%22IV/39/tic82%22.TIC,%20%20%20%22IV/39/tic82%22.HIP,%20%20%22IV/39/tic82%22.TYC,%20%20%22IV/39/tic82%22.UCAC4,%20%20%22IV/39/tic82%22.%222MASS%22,%20%22IV/39/tic82%22.objID,%20%20%22IV/39/tic82%22.WISEA,%20%20%22IV/39/tic82%22.GAIA,%20%20%22IV/39/tic82%22.KIC,%20%20%22IV/39/tic82%22.%22S/G%22,%20%20%22IV/39/tic82%22.Dist,%20%20%22IV/39/tic82%22.RAJ2000,%20%20%22IV/39/tic82%22.DEJ2000,%20%20%22IV/39/tic82%22.Bmag,%20%20%22IV/39/tic82%22.Vmag,%20%20%22IV/39/tic82%22.Teff,%20%20%22IV/39/tic82%22.Rad,%20%20%22IV/39/tic82%22.Mass,%20%20%22IV/39/tic82%22.Plx%20FROM%20%22IV/39/tic82%22%20WHERE%20%22IV/39/tic82%22.KIC=" + l;
        return this.downloadData(string, "KIC " + l);
    }

    public Optional<VizierTicCatalogDto> findByTicId(long l) {
        String string = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20%22IV/39/tic82%22.TIC,%20%20%20%22IV/39/tic82%22.HIP,%20%20%22IV/39/tic82%22.TYC,%20%20%22IV/39/tic82%22.UCAC4,%20%20%22IV/39/tic82%22.%222MASS%22,%20%22IV/39/tic82%22.objID,%20%20%22IV/39/tic82%22.WISEA,%20%20%22IV/39/tic82%22.GAIA,%20%20%22IV/39/tic82%22.KIC,%20%20%22IV/39/tic82%22.%22S/G%22,%20%20%22IV/39/tic82%22.Dist,%20%20%22IV/39/tic82%22.RAJ2000,%20%20%22IV/39/tic82%22.DEJ2000,%20%20%22IV/39/tic82%22.Bmag,%20%20%22IV/39/tic82%22.Vmag,%20%20%22IV/39/tic82%22.Teff,%20%20%22IV/39/tic82%22.Rad,%20%20%22IV/39/tic82%22.Mass,%20%20%22IV/39/tic82%22.Plx%20FROM%20%22IV/39/tic82%22%20WHERE%20%22IV/39/tic82%22.TIC=" + l;
        return this.downloadData(string, "TIC " + l);
    }

    private Optional<VizierTicCatalogDto> downloadData(String string, String string2) {
        try {
            VizierTicCatalogDto vizierTicCatalogDto = new VizierTicCatalogDto();
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string, 20000);
            VotTableParser votTableParser = new VotTableParser();
            Map<String, String> map = votTableParser.parseKeysAndValues(list);
            this.setValueToDto(map, vizierTicCatalogDto);
            return Optional.of(vizierTicCatalogDto);
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error("query for id = " + string2, exception);
            return Optional.empty();
        }
    }

    private void setValueToDto(Map<String, String> map, VizierTicCatalogDto vizierTicCatalogDto) {
        double d;
        String string = map.get("TIC");
        if (Check.isFilled(string)) {
            vizierTicCatalogDto.setTicId(Long.parseLong(string));
        }
        if (Check.isFilled(string = map.get("HIP"))) {
            vizierTicCatalogDto.setHipId(Integer.valueOf(string));
        }
        if (Check.isFilled(string = map.get("TYC"))) {
            vizierTicCatalogDto.setTyc2Id(string);
        }
        if (Check.isFilled(string = map.get("UCAC4"))) {
            vizierTicCatalogDto.setUcac4Id(string);
        }
        if (Check.isFilled(string = map.get("2MASS"))) {
            vizierTicCatalogDto.setTwoMassId("J" + string);
        }
        if (Check.isFilled(string = map.get("objID"))) {
            vizierTicCatalogDto.setSdssDr9Id(Long.valueOf(string));
        }
        if (Check.isFilled(string = map.get("WISEA"))) {
            vizierTicCatalogDto.setWiseaId(string);
        }
        if (Check.isFilled(string = map.get("GAIA"))) {
            vizierTicCatalogDto.setGaiaDr2Id(Long.valueOf(string));
        }
        if (Check.isFilled(string = map.get("KIC"))) {
            vizierTicCatalogDto.setKicId(Integer.valueOf(string));
        }
        if (Check.isFilled(string = map.get("S/G"))) {
            vizierTicCatalogDto.setObjectCategory(string);
        }
        if (Check.isFilled(string = map.get("RAJ2000"))) {
            vizierTicCatalogDto.setRaJ2000(Double.parseDouble(string) * 24.0 / 360.0);
        }
        if (Check.isFilled(string = map.get("DEJ2000"))) {
            vizierTicCatalogDto.setDeclJ2000(Double.parseDouble(string));
        }
        if (Check.isFilled(string = map.get("Dist"))) {
            vizierTicCatalogDto.setDistanceInPc(Double.parseDouble(string));
        }
        if (Check.isFilled(string = map.get("Bmag"))) {
            vizierTicCatalogDto.setBmag(Double.parseDouble(string));
        }
        if (Check.isFilled(string = map.get("Vmag"))) {
            vizierTicCatalogDto.setVmag(Double.parseDouble(string));
        }
        if (Check.isFilled(string = map.get("Teff"))) {
            vizierTicCatalogDto.setTemperatureInKelvin(Double.parseDouble(string));
        }
        if (Check.isFilled(string = map.get("Rad"))) {
            vizierTicCatalogDto.setRadius(Double.parseDouble(string));
        }
        if (Check.isFilled(string = map.get("Mass"))) {
            vizierTicCatalogDto.setMass(Double.parseDouble(string));
        }
        if (Check.isFilled(string = map.get("Plx")) && vizierTicCatalogDto.getDistanceInPc() == null && (d = Double.parseDouble(string) / 1000.0) > 0.0) {
            vizierTicCatalogDto.setDistanceInPc(1.0 / d);
        }
    }
}

