/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.util;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class SimbadStarDownload {
    private final ILogging logging = LoggingFactory.getLoggerForClass(SimbadStarDownload.class);
    private final RestTemplate restTemplate = new RestTemplate();

    public SimbadStarDownload() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StringHttpMessageConverter(StandardCharsets.UTF_8));
        this.restTemplate.setMessageConverters(arrayList);
    }

    public Optional<String> getSptypFromSimbad(String string) {
        try {
            String string2 = "https://simbad.u-strasbg.fr/simbad/sim-id?output.format=ASCII&Ident=" + string.replace(" ", "%20");
            ResponseEntity<String> responseEntity = this.restTemplate.exchange(URI.create(string2), HttpMethod.GET, null, String.class);
            this.logging.debug("Simbad successfully queried");
            String string3 = (String)responseEntity.getBody();
            return this.extractFromResponse(string3);
        }
        catch (Exception exception) {
            if (exception.getMessage().contains("Server returned HTTP response code: 400")) {
                this.logging.debug(exception);
            } else {
                this.logging.error(exception);
            }
            return Optional.empty();
        }
    }

    Optional<String> extractFromResponse(String string) {
        for (String string2 : string.split("\n")) {
            if (!string2.startsWith("Spectral type:")) continue;
            return this.extractFromSptypLine(string2);
        }
        return Optional.empty();
    }

    Optional<String> extractFromSptypLine(String string) {
        String string2 = string.substring(14).trim().split(" ")[0].trim();
        if (!"~".equals(string2)) {
            this.logging.debug("sptyp '" + string2 + "' extracted from line '" + string + "'");
            return Optional.of(string2);
        }
        return Optional.empty();
    }
}

