/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.voting;

import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.voting.Holder;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.guidesigner.icons.IconPoolVoting;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import de.planetensuche.web.connector.voting.RemoteVotingService;
import de.planetensuche.web.connector.voting.VotingCategory;
import de.planetensuche.web.connector.voting.VotingService;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public final class VotingCategoryMouseListener
implements MouseListener {
    private final ILogging logger;
    private final ISprachcontainer sprache;
    private VotingService votingService;
    private final JTextArea objektBeschreibung;
    private JLabel votingIconExoplanet;
    private JLabel votingIconAlienWorld;
    private JLabel votingIconDeepSky;
    private JLabel votingIconSunSystem;
    private String username;
    private String objectname;
    private ObjektKategorie category;
    private boolean showExoplanetVoting;
    private boolean showAlienWorldVoting;
    private boolean showDeepSkyVoting;
    private boolean showSunSystemVoting;
    private final Basisdialog datenbankDialog;

    public VotingCategoryMouseListener(JTextArea jTextArea, Basisdialog basisdialog, String string, int n) {
        Object object;
        this.objektBeschreibung = jTextArea;
        this.datenbankDialog = basisdialog;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.logger = LoggingFactory.getLoggerForClass(VotingCategoryMouseListener.class);
        try {
            object = System.getenv("LOGNAME");
            if (object == null || ((String)object).isEmpty()) {
                object = System.getProperty("user.name");
            }
            if (object == null || ((String)object).isEmpty()) {
                object = System.getenv("USERNAME");
            }
            this.username = (String)object + "@" + InetAddress.getLocalHost().getHostName();
            this.votingService = new RemoteVotingService(Holder.VALUE, string, n);
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.error("Fehler beim Ermitteln des Rechnernamens", unknownHostException);
        }
        if (this.username != null) {
            this.showExoplanetVoting = this.votingService.isVotingAllowed(VotingCategory.EXOPLANET, this.username);
            object = IconPoolVoting.VOTE3.getImageIcon();
            this.votingIconExoplanet = this.createLabelWithIcon(VotingCategory.EXOPLANET, (ImageIcon)object);
            this.showAlienWorldVoting = this.votingService.isVotingAllowed(VotingCategory.ALIEN_HOME, this.username);
            ImageIcon imageIcon = IconPoolVoting.VOTE3.getImageIcon();
            this.votingIconAlienWorld = this.createLabelWithIcon(VotingCategory.ALIEN_HOME, imageIcon);
            this.showDeepSkyVoting = this.votingService.isVotingAllowed(VotingCategory.DEEP_SKY, this.username);
            ImageIcon imageIcon2 = IconPoolVoting.VOTE3.getImageIcon();
            this.votingIconDeepSky = this.createLabelWithIcon(VotingCategory.DEEP_SKY, imageIcon2);
            this.showSunSystemVoting = this.votingService.isVotingAllowed(VotingCategory.SUN_SYSTEM, this.username);
            this.votingIconSunSystem = this.createLabelWithIcon(VotingCategory.SUN_SYSTEM, imageIcon2);
        }
    }

    private JLabel createLabelWithIcon(VotingCategory votingCategory, ImageIcon imageIcon) {
        String string = this.sprache.getString("db_voting_voteForThis") + " " + this.sprache.getString("db_voting_category_" + votingCategory.name());
        Image image = imageIcon.getImage().getScaledInstance(50, 50, 4);
        JLabel jLabel = new JLabel(string, new ImageIcon(image), 0);
        jLabel.setToolTipText(string);
        jLabel.setVisible(false);
        jLabel.setCursor(new Cursor(12));
        jLabel.addMouseListener(this.createExoplanetMouseListener(votingCategory));
        return jLabel;
    }

    private MouseListener createExoplanetMouseListener(final VotingCategory votingCategory) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                boolean bl;
                if (VotingCategoryMouseListener.this.username != null && (bl = VotingCategoryMouseListener.this.votingService.addNewVoting(VotingCategoryMouseListener.this.objectname, votingCategory, VotingCategoryMouseListener.this.username))) {
                    if (VotingCategory.EXOPLANET.equals((Object)votingCategory)) {
                        VotingCategoryMouseListener.this.showExoplanetVoting = false;
                    } else if (VotingCategory.ALIEN_HOME.equals((Object)votingCategory)) {
                        VotingCategoryMouseListener.this.showAlienWorldVoting = false;
                    } else if (VotingCategory.DEEP_SKY.equals((Object)votingCategory)) {
                        VotingCategoryMouseListener.this.showDeepSkyVoting = false;
                    } else if (VotingCategory.SUN_SYSTEM.equals((Object)votingCategory)) {
                        VotingCategoryMouseListener.this.showSunSystemVoting = false;
                    }
                    VotingCategoryMouseListener.this.hideVotingIcons();
                    VotingCategoryMouseListener.this.datenbankDialog.showMessageOnMessageBarByKey("db_voting_voteSuccess", IconPoolDefault.INFO);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
    }

    public void changeObject(ObjektKategorie objektKategorie, String string) {
        this.category = objektKategorie;
        this.objectname = string;
        this.hideVotingIcons();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.votingIconExoplanet.isVisible() || this.votingIconAlienWorld.isVisible() || this.votingIconDeepSky.isVisible() || this.votingIconSunSystem.isVisible()) {
            return;
        }
        if (this.username != null) {
            this.objektBeschreibung.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(30, 50, 10, 10);
            gridBagConstraints.anchor = 17;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.insets = new Insets(30, 50, 10, 10);
            gridBagConstraints2.anchor = 17;
            if (this.showExoplanetVoting && ObjektKategorie.PLANETEN.equals((Object)this.category)) {
                this.objektBeschreibung.add((Component)this.votingIconExoplanet, gridBagConstraints);
                this.votingIconExoplanet.setVisible(true);
                this.votingIconExoplanet.requestFocus();
            }
            if (this.showAlienWorldVoting && ObjektKategorie.PLANETEN.equals((Object)this.category)) {
                this.objektBeschreibung.add((Component)this.votingIconAlienWorld, gridBagConstraints2);
                this.votingIconAlienWorld.setVisible(true);
                this.votingIconAlienWorld.requestFocus();
            }
            if (this.showDeepSkyVoting && (ObjektKategorie.GALAXIE_NEBEL.equals((Object)this.category) || ObjektKategorie.GALAXIENHAUFEN.equals((Object)this.category) || ObjektKategorie.STERNHAUFEN.equals((Object)this.category))) {
                this.objektBeschreibung.add((Component)this.votingIconDeepSky, gridBagConstraints);
                this.votingIconDeepSky.setVisible(true);
                this.votingIconDeepSky.requestFocus();
            }
            if (this.showSunSystemVoting && (ObjektKategorie.ASTEROIDEN.equals((Object)this.category) || ObjektKategorie.KOMETEN.equals((Object)this.category) || ObjektKategorie.MONDE.equals((Object)this.category))) {
                this.objektBeschreibung.add((Component)this.votingIconSunSystem, gridBagConstraints);
                this.votingIconSunSystem.setVisible(true);
                this.votingIconSunSystem.requestFocus();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = mouseEvent.getXOnScreen() >= this.objektBeschreibung.getX() && mouseEvent.getXOnScreen() <= this.objektBeschreibung.getX() + this.objektBeschreibung.getWidth();
        boolean bl3 = bl = mouseEvent.getYOnScreen() >= this.objektBeschreibung.getY() + 140 && mouseEvent.getYOnScreen() <= this.objektBeschreibung.getY() + this.objektBeschreibung.getHeight();
        if (bl2 && bl) {
            return;
        }
        this.hideVotingIcons();
    }

    private void hideVotingIcons() {
        if (this.votingIconExoplanet.isVisible()) {
            this.objektBeschreibung.remove(this.votingIconExoplanet);
            this.votingIconExoplanet.setVisible(false);
        }
        if (this.votingIconAlienWorld.isVisible()) {
            this.objektBeschreibung.remove(this.votingIconAlienWorld);
            this.votingIconAlienWorld.setVisible(false);
        }
        if (this.votingIconDeepSky.isVisible()) {
            this.objektBeschreibung.remove(this.votingIconDeepSky);
            this.votingIconDeepSky.setVisible(false);
        }
        if (this.votingIconSunSystem.isVisible()) {
            this.objektBeschreibung.remove(this.votingIconSunSystem);
            this.votingIconSunSystem.setVisible(false);
        }
        this.objektBeschreibung.requestFocus();
    }

    public String getUsername() {
        return this.username;
    }
}

