/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.voting;

import de.planetensuche.datenbank.voting.Holder;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.PictureChangeListener;
import de.planetensuche.guidesigner.components.PictureViewer;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.guidesigner.icons.IconPoolVoting;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import de.planetensuche.web.connector.voting.RemoteVotingService;
import de.planetensuche.web.connector.voting.VotingCategory;
import de.planetensuche.web.connector.voting.VotingService;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public final class VotingPictureMouseListener
implements MouseListener,
PictureChangeListener {
    private final ILogging logger;
    private final ISprachcontainer sprache;
    private VotingService votingService;
    private final PictureViewer pictureViewer;
    private JLabel votingIconPicture;
    private String username;
    private String pictureName;
    private String objectname;
    private boolean showPictureVoting;
    private final Basisdialog datenbankDialog;

    public VotingPictureMouseListener(PictureViewer pictureViewer, Basisdialog basisdialog, String string, int n) {
        Object object;
        this.pictureViewer = pictureViewer;
        this.datenbankDialog = basisdialog;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.logger = LoggingFactory.getLoggerForClass(VotingPictureMouseListener.class);
        try {
            object = System.getenv("LOGNAME");
            if (object == null || ((String)object).isEmpty()) {
                object = System.getProperty("user.name");
            }
            if (object == null || ((String)object).isEmpty()) {
                object = System.getenv("USERNAME");
            }
            this.username = (String)object + "@" + InetAddress.getLocalHost().getHostName();
            this.votingService = new RemoteVotingService(Holder.VALUE, string, n);
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.error("Fehler beim Ermitteln des Rechnernamens", unknownHostException);
        }
        if (this.username != null) {
            this.showPictureVoting = this.votingService.isVotingAllowed(VotingCategory.PICTURE, this.username);
            object = IconPoolVoting.VOTE3.getImageIcon();
            this.votingIconPicture = this.createLabelWithIcon(VotingCategory.PICTURE, (ImageIcon)object);
        }
    }

    @Override
    public void changePicture(String string) {
        this.pictureName = string;
    }

    private JLabel createLabelWithIcon(VotingCategory votingCategory, ImageIcon imageIcon) {
        String string = this.sprache.getString("db_voting_voteForThis") + " " + this.sprache.getString("db_voting_category_" + votingCategory.name());
        Image image = imageIcon.getImage().getScaledInstance(50, 50, 4);
        JLabel jLabel = new JLabel(string, new ImageIcon(image), 0);
        jLabel.setForeground(Color.WHITE);
        jLabel.setToolTipText(string);
        jLabel.setVisible(false);
        jLabel.addMouseListener(this.createPictureMouseListener());
        return jLabel;
    }

    private MouseListener createPictureMouseListener() {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                boolean bl;
                if (VotingPictureMouseListener.this.username != null && (bl = VotingPictureMouseListener.this.votingService.addNewPictureVoting(VotingPictureMouseListener.this.pictureName, VotingPictureMouseListener.this.objectname, VotingPictureMouseListener.this.username))) {
                    VotingPictureMouseListener.this.showPictureVoting = false;
                    VotingPictureMouseListener.this.hideVotingIcons();
                    VotingPictureMouseListener.this.datenbankDialog.showMessageOnMessageBarByKey("db_voting_voteSuccess", IconPoolDefault.INFO);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
    }

    public void changeObject(String string, String string2) {
        this.pictureName = string;
        this.objectname = string2;
        this.hideVotingIcons();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.votingIconPicture.isVisible()) {
            return;
        }
        if (this.username != null) {
            JLabel jLabel = this.pictureViewer.getPictureLabel();
            jLabel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(30, 50, 10, 10);
            gridBagConstraints.anchor = 17;
            if (this.showPictureVoting && this.pictureName != null && !this.pictureName.isEmpty()) {
                jLabel.add((Component)this.votingIconPicture, gridBagConstraints);
                this.votingIconPicture.setVisible(true);
                this.votingIconPicture.requestFocus();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = mouseEvent.getXOnScreen() >= this.pictureViewer.getX() + 80 && mouseEvent.getXOnScreen() <= this.pictureViewer.getX() + this.pictureViewer.getWidth();
        boolean bl3 = bl = mouseEvent.getYOnScreen() >= this.pictureViewer.getY() + 140 && mouseEvent.getYOnScreen() <= this.pictureViewer.getY() + this.pictureViewer.getHeight();
        if (bl2 && bl) {
            return;
        }
        this.hideVotingIcons();
    }

    private void hideVotingIcons() {
        if (this.votingIconPicture.isVisible()) {
            this.pictureViewer.getPictureLabel().remove(this.votingIconPicture);
            this.votingIconPicture.setVisible(false);
            this.pictureViewer.getPictureLabel().requestFocus();
            this.pictureViewer.getPictureLabel().repaint();
        }
    }

    public String getUsername() {
        return this.username;
    }
}

