/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.vsx;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbank.vizier.VotTableParser;
import de.planetensuche.datenbank.vsx.AavsoObjectTypeMapper;
import de.planetensuche.datenbank.vsx.VSXObjectXmlDto;
import de.planetensuche.datenbank.vsx.VSXObjectsXmlDto;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class AavsoDatabaseApiClient {
    private static final String BASE_URL_TIC_ID = "https://vsx.aavso.org/index.php?view=query.votable&ident=TIC+";
    private static final String BASE_URL_COORDS = "https://vsx.aavso.org/index.php?view=api.list&ra={0}&dec={1}&radius=0.02&tomag=20&order=9";
    private static final int TIMEOUT_IN_MS_QUERY_BY_ID = 15000;
    private static final int TIMEOUT_IN_MS_QUERY_BY_COORDS = 25000;
    private final HttpClient client;
    private final VotTableParser parser;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final AavsoObjectTypeMapper mapper;

    public AavsoDatabaseApiClient() {
        this.client = HttpClient.newBuilder().build();
        this.parser = new VotTableParser();
        this.mapper = new AavsoObjectTypeMapper();
    }

    public Optional<StarObjectType> fetchObjectType(long l, double d, double d2, long l2) {
        try {
            Object object = BASE_URL_TIC_ID + l;
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI((String)object)).GET().timeout(Duration.ofMillis(15000L)).build();
            HttpResponse<Stream<String>> httpResponse = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofLines());
            Stream<String> stream = httpResponse.body();
            Optional<StarObjectType> optional = this.extractVariableTypeFromVottable(stream, l);
            if (optional.isPresent()) {
                return optional;
            }
            if (d == 0.0 && d2 == 0.0) {
                return Optional.empty();
            }
            object = BASE_URL_COORDS.replace("{0}", "" + d).replace("{1}", "" + d2);
            httpRequest = HttpRequest.newBuilder().uri(new URI((String)object)).GET().timeout(Duration.ofMillis(25000L)).build();
            HttpResponse<String> httpResponse2 = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            return this.extractVariableTypeFromXml(httpResponse2.body(), l, l2, d, d2);
        }
        catch (HttpTimeoutException httpTimeoutException) {
            return Optional.empty();
        }
        catch (IOException | InterruptedException | URISyntaxException exception) {
            this.logger.error(exception);
            return Optional.empty();
        }
    }

    private Optional<StarObjectType> extractVariableTypeFromVottable(Stream<String> stream, long l) {
        List<String> list = stream.toList();
        Map<String, String> map = this.parser.parseKeysAndValues(list);
        String string = map.get("VarType");
        if (Check.isEmpty(string)) {
            return Optional.empty();
        }
        return this.mapper.getObjectTypeForVariableType(string, l);
    }

    Optional<StarObjectType> extractVariableTypeFromXml(String string, long l, long l2, double d, double d2) {
        try {
            if (string != null && string.contains("<VSXObject>")) {
                JAXBContext jAXBContext = JAXBContext.newInstance(VSXObjectsXmlDto.class);
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                VSXObjectsXmlDto vSXObjectsXmlDto = (VSXObjectsXmlDto)unmarshaller.unmarshal(new StringReader(string));
                if (vSXObjectsXmlDto != null && Check.isFilled(vSXObjectsXmlDto.VSXObject)) {
                    double d3 = 5.0;
                    String string2 = "";
                    String string3 = "";
                    for (VSXObjectXmlDto object : vSXObjectsXmlDto.VSXObject) {
                        double vSXObjectXmlDto = this.angularSeparation(d, d2, object.RA2000, object.Declination2000);
                        if (!(vSXObjectXmlDto < d3)) continue;
                        d3 = vSXObjectXmlDto;
                        string2 = object.Name;
                        string3 = object.VariabilityType;
                    }
                    ArrayList arrayList = new ArrayList();
                    if (l2 > 0L) {
                        for (VSXObjectXmlDto vSXObjectXmlDto : vSXObjectsXmlDto.VSXObject) {
                            if (vSXObjectXmlDto.Name.equals("Gaia DR3 " + l2)) {
                                return this.translateVariableType(vSXObjectXmlDto.VariabilityType, l);
                            }
                            if (vSXObjectXmlDto.Name.startsWith("Gaia ")) continue;
                            arrayList.add(vSXObjectXmlDto.VariabilityType);
                        }
                        return this.translateVariableType((String)arrayList.get(0), l);
                    }
                    return this.translateVariableType(vSXObjectsXmlDto.VSXObject.get((int)0).VariabilityType, l);
                }
                this.logger.warn("VSX result not parseable: " + string);
            }
        }
        catch (JAXBException jAXBException) {
            this.logger.error(string, jAXBException);
        }
        return Optional.empty();
    }

    double angularSeparation(double d, double d2, double d3, double d4) {
        System.out.println(Math.sin(d2) * Math.sin(d4));
        System.out.println(Math.cos(d2) * Math.cos(d4) * Math.cos(d - d3));
        return Math.sin(d2) * Math.sin(d4) + Math.cos(d2) * Math.cos(d4) * Math.cos(d - d3);
    }

    private Optional<StarObjectType> translateVariableType(String string, long l) {
        return Check.isEmpty(string) ? Optional.empty() : this.mapper.getObjectTypeForVariableType(string, l);
    }
}

