/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.vsx;

import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.Optional;

public class AavsoObjectTypeMapper {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<StarObjectType> getObjectTypeForVariableType(String string, long l) {
        if (string.endsWith(":")) {
            return this.getObjectTypeForVariableType(string.substring(0, string.length() - 1), l);
        }
        return switch (string) {
            case "E", "E/RS", "E/GS", "EA", "EA/SD", "EA+BY", "EA+UV", "EA+BCEP", "EA+GDOR", "EA+ROT", "EA/WD+NL", "EA/RS", "EA/WR", "EB", "EB/RS", "EW", "EW/KW", "EW/RS", "EW/DW", "EB|EW", "EC", "EC|ESD", "ED", "ESD", "ED|ESD", "CBSS", "V", "CBSS/V", "AM", "AR", "BD", "D", "DM", "EA/DM", "DS", "DW", "EL", "GS", "HW", "K", "KE", "KW", "PN", "SD", "EB/SD:", "EB/SD", "WD", "EA/WD", "ELL", "ELL:", "ELL+DSCT", "DSCTC+ELL" -> Optional.of(StarObjectType.ECLIPSING_BINARY);
            case "WR" -> Optional.of(StarObjectType.WOLF_RAYET_STAR);
            case "IBWD", "HB", "R", "RS", "DPV", "DQ", "DQ/AE", "UG/DQ+E", "N", "NA", "NB", "NC", "NL", "VY", "NL/VY", "NR", "WDP", "ZAND", "HMXB", "IMXB", "LMXB", "BHXB", "XB", "XJ", "XN", "XP", "XPR", "XBR", "ZZ/GWLIB", "GWLIB" -> Optional.of(StarObjectType.DOUBLE_STAR_REAL);
            case "CEP", "DCEP", "DCEP(B)", "DCEPS", "DCEPS(B)", "DCEP-FO", "DCEP-FU", "DSCT", "DSCTC", "DSCTr", "DSCT|EC", "UXOR+DSCT", "BL", "RR", "RRAB", "RRAB/BL", "RRC", "RRD", "SPB", "SPBe", "DWLYN", "GDOR", "DSCT+GDOR", "HADS", "HADS(B)", "ORG", "roAm", "roAp", "CW", "CWA", "CWB", "CWB(B)", "CWBS", "AHB1", "BCEPS", "ACV", "BY", "BY+UV", "BY+EP", "FKCOM", "LERI", "PSR", "SXARI", "SXARI/E", "ACEP", "BCEP", "BLAP", "BXCIR", "SXPHE", "SXPHE(B)", "V361HYA", "V1093HER", "ZZLep" -> Optional.of(StarObjectType.VARIABLE_SHORT_PERIOD);
            case "M", "PPN", "RV", "RVA", "RVB", "LPV" -> Optional.of(StarObjectType.VARIABLE_LONG_PERIOD);
            case "L", "LB", "LC", "IS", "ISA", "ISB", "RCB", "SDOR", "APER", "CTTS/ROT", "ROT", "UV", "UVN", "UXOR", "IT", "TTS", "TTS/ROT", "WTTS", "WTTS/ROT", "ACYG", "PVTEL", "PVTELI", "PVTELII", "PVTELIII", "CTTS", "DYPer", "EXOR", "FSCMa", "FUOR", "GCAS", "I", "IA", "IB", "IN", "INA", "INAT", "INB", "INS", "INSA", "INSB", "INST", "INT", "BLLAC" -> Optional.of(StarObjectType.VARIABLE_IRREGULAR);
            case "VAR", "PER", "MISC", "NSIN ELL", "PULS", "BE", "cPNB[e]", "FF", "YSO", "DIP", "CV", "X", "S", "ESD|DCEP-FO", "ESD|RRC|EC", "EA/AR/RS", "EC|RRC", "RRC|EC|ESD", "EC|DSCT|DSCTr|ESD", "EC|BCEP|DSCT|DSCTr|ESD" -> Optional.of(StarObjectType.VARIABLE_UNKNOWN_TYPE);
            case "SR", "SR:", "SRA", "SRB", "SRC", "SRD", "SRS" -> Optional.of(StarObjectType.VARIABLE_HALF_REGULAR);
            case "ZZ", "ZZA", "ZZB", "ZZO", "O", "ZZA/O" -> Optional.of(StarObjectType.WHITE_DWARF);
            case "SN I", "SN Ia", "SN Iax", "SN Ia-00cx-like", "SN Ia-02es-like", "SN Ia-06gz-like", "SN Ia-86G-like", "SN Ia-91bg-like", "SN Ia-91T-like", "SN Ia-99aa-like", "SN Ia-Ca-rich", "SN Ia-CSM", "SN Ib", "SN Ic", "SN Ic-BL" -> Optional.of(StarObjectType.SUPERNOVA_I_A);
            case "SN", "SN II", "SN IIa", "SN IIb", "SN IId", "SN II-L", "SN IIn", "SN II-P", "SN-pec" -> Optional.of(StarObjectType.SUPERNOVA_II);
            case "UG", "UGER", "UGSS", "UGSU", "UGWZ", "UGZ", "UGZ/IW", "V838MON", "UGZ+VY" -> Optional.of(StarObjectType.NOVA);
            case "CST", "EP" -> Optional.of(StarObjectType.SINGLE_STAR);
            default -> {
                this.logger.warn("no mapping found for AAVSO/VSX type '" + string + "' for star TIC " + l);
                yield Optional.of(StarObjectType.SINGLE_STAR);
            }
        };
    }
}

