/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.webseite;

import com.google.inject.Injector;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.formeln.EarthSimilarityIndexExoplanetCalculator;
import de.planetensuche.datamodel.helfer.HabitateZoneRechner;
import de.planetensuche.datenbank.PlanetTypeDetectorService;
import de.planetensuche.datenbank.SptypErmittelnService;
import de.planetensuche.datenbank.webseite.CandidateExoplanetsChartDto;
import de.planetensuche.datenbank.webseite.CandidateExoplanetsDto;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QLumin;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QNotizen;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import de.planetensuche.datenbankkern.querydsl5.QSternbilder;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class CandidateExoplanetsDataCollector {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder db;
    private final IIdCacheDAO cache;
    private final IObjektnamenRepository objektnamenRepo;
    private final IHabitableZoneRepository hzRepo;
    private final PlanetTypeDetectorService planetenTypErmittelnService;
    private final SptypErmittelnService sptypService;
    private final HabitateZoneRechner hzCalculator;
    private final EarthSimilarityIndexExoplanetCalculator esiCalculator;
    private final QDaten qDaten = QDaten.daten;
    private final QNamen qNamen = QNamen.namen1;
    private final QEntdecker qEntdecker = QEntdecker.entdecker;
    private final QZtentdecker qZtEntdecker = QZtentdecker.ztentdecker;
    private final QZt qZt = QZt.zt;
    private final QSternbilder qSternbilder = QSternbilder.sternbilder;
    private final QSpektraltyp qSptyp = QSpektraltyp.spektraltyp;
    private final QSpektraltyp2 qSptyp2 = QSpektraltyp2.spektraltyp2;
    private final QLumin qLumin = QLumin.lumin;
    private final QNotizen qNotizen = QNotizen.notizen;

    public CandidateExoplanetsDataCollector(Injector injector) {
        this.db = injector.getInstance(IDatenbankverbinder.class);
        this.cache = injector.getInstance(IIdCacheDAO.class);
        this.objektnamenRepo = injector.getInstance(IObjektnamenRepository.class);
        this.hzRepo = injector.getInstance(IHabitableZoneRepository.class);
        this.planetenTypErmittelnService = injector.getInstance(PlanetTypeDetectorService.class);
        this.sptypService = injector.getInstance(SptypErmittelnService.class);
        this.hzCalculator = new HabitateZoneRechner();
        this.esiCalculator = new EarthSimilarityIndexExoplanetCalculator();
    }

    public long countNumberOfPhtExoplanets() {
        long l = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().selectDistinct((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qZtEntdecker)).on((Predicate)this.qZtEntdecker.datenid.eq(this.qDaten.id))).leftJoin((EntityPath)this.qEntdecker)).on((Predicate)this.qEntdecker.id.eq(this.qZtEntdecker.entdeckerid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())).and(this.qDaten.entdeckungbestaetigt.isFalse()))).fetchCount();
        return l;
    }

    public long countNumberOfPhtExoplanetsWithToi() {
        long l = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().selectDistinct((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qZtEntdecker)).on((Predicate)this.qZtEntdecker.datenid.eq(this.qDaten.id))).leftJoin((EntityPath)this.qEntdecker)).on((Predicate)this.qEntdecker.id.eq(this.qZtEntdecker.entdeckerid))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qNamen.datenid.eq(this.qDaten.id))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())).and(this.qDaten.entdeckungbestaetigt.isFalse()).and(this.qNamen.namen.startsWith("TOI-")))).fetchCount();
        return l;
    }

    public Map<String, List<CandidateExoplanetsChartDto>> getChartData() {
        HashMap<String, List<CandidateExoplanetsChartDto>> hashMap = new HashMap<String, List<CandidateExoplanetsChartDto>>();
        try {
            ArrayList<CandidateExoplanetsChartDto> arrayList = new ArrayList<CandidateExoplanetsChartDto>();
            List<Tuple> list = this.fetchCandidatesByDiscoverer("G\u00fchne");
            for (Tuple object2 : list) {
                arrayList.add(this.mapToDto(object2, true));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui187"), arrayList);
            ArrayList arrayList2 = new ArrayList();
            List<Tuple> list2 = this.fetchCandidatesByDiscoverer(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase());
            for (Tuple tuple : list2) {
                arrayList2.add(this.mapToDto(tuple, false));
            }
            hashMap.put(SprachcontainerFabrik.getSprachcontainer().getString("sim_gui188"), arrayList2);
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
        return hashMap;
    }

    private List<Tuple> fetchCandidatesByDiscoverer(String string) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().selectDistinct(new Expression[]{this.qDaten.id, this.qDaten.durchmesser, this.qDaten.umlaufszeit}).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qZtEntdecker)).on((Predicate)this.qZtEntdecker.datenid.eq(this.qDaten.id))).leftJoin((EntityPath)this.qEntdecker)).on((Predicate)this.qEntdecker.id.eq(this.qZtEntdecker.entdeckerid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qEntdecker.nachname.eq(string)).and(this.qDaten.entdeckungbestaetigt.isFalse()).and(this.qDaten.durchmesser.gt(0.0)).and(this.qDaten.umlaufszeit.gt(0.0)))).fetch();
    }

    private CandidateExoplanetsChartDto mapToDto(Tuple tuple, boolean bl) {
        int n = tuple.get(this.qDaten.id);
        double d = tuple.get(this.qDaten.durchmesser) * 11.194418312950768;
        double d2 = tuple.get(this.qDaten.umlaufszeit);
        return new CandidateExoplanetsChartDto(n, d, d2, bl);
    }

    public List<CandidateExoplanetsDto> getDaten() {
        ArrayList<CandidateExoplanetsDto> arrayList = new ArrayList<CandidateExoplanetsDto>();
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.entfernung, this.qDaten.durchmesser, this.qDaten.umlaufszeit, this.qDaten.temperatur, this.qDaten.zugehoerigkeit, this.qNotizen.notiz}).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qZtEntdecker)).on((Predicate)this.qZtEntdecker.datenid.eq(this.qDaten.id))).leftJoin((EntityPath)this.qEntdecker)).on((Predicate)this.qEntdecker.id.eq(this.qZtEntdecker.entdeckerid))).leftJoin((EntityPath)this.qNotizen)).on((Predicate)this.qNotizen.datenid.eq(this.qDaten.id))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qEntdecker.nachname.eq("G\u00fchne")).and(this.qDaten.entdeckungbestaetigt.isFalse()))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.zugehoerigkeit.asc(), this.qDaten.id.asc()})).fetch();
            for (Tuple tuple : list) {
                CandidateExoplanetsDto candidateExoplanetsDto = new CandidateExoplanetsDto();
                arrayList.add(candidateExoplanetsDto);
                List<String> list2 = this.fillPlanetData(tuple, candidateExoplanetsDto);
                Optional<Tuple> optional = this.fillStarData(tuple, candidateExoplanetsDto, list2);
                if (!optional.isPresent()) continue;
                this.calcAndFillEsi(tuple, optional.get(), candidateExoplanetsDto);
            }
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
        return arrayList;
    }

    private Optional<Tuple> fillStarData(Tuple tuple, CandidateExoplanetsDto candidateExoplanetsDto, List<String> list) throws NonUniqueResultException {
        int n = tuple.get(this.qDaten.zugehoerigkeit);
        Tuple tuple2 = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qDaten.entfernung, this.qDaten.temperatur, this.qDaten.ah, this.qDaten.durchmesser, this.qSternbilder.latbezeichnung, this.qSptyp.typ, this.qSptyp2.typ, this.qLumin.typ}).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qZt)).on((Predicate)this.qZt.datenid.eq(this.qDaten.id))).leftJoin((EntityPath)this.qSternbilder)).on((Predicate)this.qSternbilder.id.eq(this.qZt.sternbildid))).leftJoin((EntityPath)this.qSptyp)).on((Predicate)this.qSptyp.id.eq(this.qDaten.spektralklasse))).leftJoin((EntityPath)this.qSptyp2)).on((Predicate)this.qSptyp2.id.eq(this.qDaten.spektralklasse2))).leftJoin((EntityPath)this.qLumin)).on((Predicate)this.qLumin.id.eq(this.qDaten.lumin))).where(this.qDaten.id.eq(n))).fetchOne();
        if (tuple2 != null) {
            if (tuple2.get(this.qDaten.entfernung) != null) {
                candidateExoplanetsDto.setSternEntfernungInLy(tuple2.get(this.qDaten.entfernung));
            }
            if (tuple2.get(this.qSternbilder.latbezeichnung) != null) {
                candidateExoplanetsDto.setSternSternbild(tuple2.get(this.qSternbilder.latbezeichnung));
            } else {
                candidateExoplanetsDto.setSternSternbild("");
            }
            String string = tuple2.get(this.qSptyp.typ);
            if (Check.isFilled(string) && !"unbekannt".equals(string)) {
                candidateExoplanetsDto.setSternSptyp(string + String.valueOf(tuple2.get(this.qSptyp2.typ)));
                String string2 = tuple2.get(this.qLumin.typ);
                if (Check.isFilled(string2) && !"unbekannt".equals(string2)) {
                    candidateExoplanetsDto.setSternSptyp(candidateExoplanetsDto.getSternSptyp() + string2);
                }
                candidateExoplanetsDto.setSternSptypDerived(false);
            } else {
                String string3 = this.sptypService.findSptyp(tuple2.get(this.qDaten.temperatur), tuple2.get(this.qDaten.ah));
                if (Check.isFilled(string3)) {
                    candidateExoplanetsDto.setSternSptyp(string3);
                    candidateExoplanetsDto.setSternSptypDerived(true);
                } else {
                    candidateExoplanetsDto.setSternSptyp("?");
                }
            }
        } else {
            this.logger.warn("keinen Stern gefunden f\u00fcr Planet " + list.get(0));
        }
        return Optional.ofNullable(tuple2);
    }

    private List<String> fillPlanetData(Tuple tuple, CandidateExoplanetsDto candidateExoplanetsDto) throws SQLException {
        int n;
        Optional<Pair<Double, Double>> optional;
        Double d;
        List<String> list = this.objektnamenRepo.getNamenByDatenId(tuple.get(this.qDaten.id), ObjektnamenSortierung.BEKANNTHEIT);
        String string = "https://exofop.ipac.caltech.edu/tess/target.php?id=" + this.getTicId(list);
        candidateExoplanetsDto.setPlanetName("<a href=\"" + string + "\">" + list.get(0) + "</a>");
        candidateExoplanetsDto.setPlanetType("");
        if (tuple.get(this.qDaten.durchmesser) != null) {
            double d2 = tuple.get(this.qDaten.durchmesser);
            candidateExoplanetsDto.setPlanetRadiusInJup(d2);
            double d3 = 11.194418312950768 * d2;
            candidateExoplanetsDto.setPlanetType(this.planetenTypErmittelnService.getType(d3));
        }
        if ((d = tuple.get(this.qDaten.umlaufszeit)) != null && d > 0.0) {
            candidateExoplanetsDto.setPlanetUmlaufszeit(d);
        }
        if (tuple.get(this.qDaten.temperatur) != null && tuple.get(this.qDaten.temperatur) >= -273.14) {
            double d4 = tuple.get(this.qDaten.temperatur);
            double d5 = d4 - 273.15;
            candidateExoplanetsDto.setPlanetTemperatur(d5);
        } else {
            candidateExoplanetsDto.setPlanetTemperatur(null);
        }
        if (tuple.get(this.qNotizen.notiz) != null) {
            candidateExoplanetsDto.setNotes(tuple.get(this.qNotizen.notiz));
        } else {
            candidateExoplanetsDto.setNotes("");
        }
        Double d6 = tuple.get(this.qDaten.entfernung);
        if ((d6 != null && d6 > 0.0 || d != null && d > 0.0) && (optional = this.hzRepo.getInnerAndOuterHZ(n = tuple.get(this.qDaten.zugehoerigkeit).intValue())).isPresent()) {
            candidateExoplanetsDto.setPlanetInHz(this.hzCalculator.isPlanetInHz(optional.get().getLeft(), optional.get().getRight(), d6, d));
        }
        return list;
    }

    private String getTicId(List<String> list) {
        for (String string : list) {
            if (!string.startsWith("TIC ")) continue;
            return string.substring(4, string.length() - 3);
        }
        return list.get(0);
    }

    private void calcAndFillEsi(Tuple tuple, Tuple tuple2, CandidateExoplanetsDto candidateExoplanetsDto) {
        Optional<Double> optional = this.esiCalculator.calcESI(tuple.get(this.qDaten.durchmesser), tuple.get(this.qDaten.entfernung), tuple.get(this.qDaten.umlaufszeit), tuple2.get(this.qDaten.ah), tuple2.get(this.qDaten.temperatur), tuple2.get(this.qDaten.durchmesser));
        if (optional.isPresent()) {
            candidateExoplanetsDto.setPlanetEsi(optional.get());
        }
    }
}

