/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.webseite;

import com.google.inject.Injector;
import de.planetensuche.datenbank.dbmodel.BeanFactory;
import de.planetensuche.datenbank.webseite.CandidateExoplanetsChartDto;
import de.planetensuche.datenbank.webseite.CandidateExoplanetsDataCollector;
import de.planetensuche.datenbank.webseite.CandidateExoplanetsDto;
import de.planetensuche.datenbank.webseite.PlanetensucheInfoCollector;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CandidateExoplanetsWebsiteGenerator {
    private final String templateFileName = "kandidaten_template";
    private final String ausgabeDateiName = "my_exoplanet_candidates";
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final CandidateExoplanetsDataCollector dataCollector;
    private final PlanetensucheInfoCollector infoCollector;
    private final ISprachcontainer i18n;

    public CandidateExoplanetsWebsiteGenerator() {
        Injector injector = BeanFactory.getInjector();
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.dataCollector = new CandidateExoplanetsDataCollector(injector);
        this.infoCollector = new PlanetensucheInfoCollector(injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generiereKandidatenWebseite() {
        String string = this.i18n.getAktuelleSprache();
        try {
            List<CandidateExoplanetsDto> list = this.dataCollector.getDaten();
            List<String> list2 = Arrays.asList("de", "en");
            for (String string2 : list2) {
                List<String> list3 = FileUtils.readLines(new File("webseite" + File.separator + "kandidaten_template_" + string2 + ".html"), StandardCharsets.UTF_8);
                ArrayList<String> arrayList = new ArrayList<String>();
                this.i18n.setAktuelleSprache(string2.equals("de") ? "deutsch" : "english");
                for (String string3 : list3) {
                    if (string3.contains("TODO TABELE")) {
                        this.writeTableHeader(arrayList);
                        this.writeTableBody(list, arrayList);
                        this.writeChart(arrayList);
                        continue;
                    }
                    if (string3.contains("TODO HINWEIS")) {
                        long l = this.dataCollector.countNumberOfPhtExoplanets();
                        long l2 = this.dataCollector.countNumberOfPhtExoplanetsWithToi();
                        arrayList.add(this.i18n.getString("webseite_m38", l, l2));
                        arrayList.add(" / ");
                        arrayList.add(list.size() + " " + this.i18n.getString("webseite_m39") + "<br><br>");
                        arrayList.add(this.i18n.getString("webseite_m8") + " " + this.infoCollector.getPlanetensucheVersion() + "<br>");
                        arrayList.add("<br><br>" + this.i18n.getString("webseite_m41", Instant.now()));
                        continue;
                    }
                    arrayList.add(string3);
                }
                FileUtils.writeLines(new File("temp" + File.separator + "my_exoplanet_candidates_" + string2 + ".html"), "utf8", arrayList, false);
            }
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
        finally {
            try {
                this.i18n.setAktuelleSprache(string);
            }
            catch (IOException iOException) {
                this.logger.error(iOException);
            }
        }
    }

    private void writeTableBody(List<CandidateExoplanetsDto> list, List<String> list2) {
        for (CandidateExoplanetsDto candidateExoplanetsDto : list) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>").append(candidateExoplanetsDto.getPlanetName()).append("</td>");
            stringBuilder.append("<td>").append(this.formatPlanetRadius(candidateExoplanetsDto.getPlanetRadiusInJup())).append("</td>");
            if (candidateExoplanetsDto.getPlanetUmlaufszeit() != null) {
                stringBuilder.append("<td>").append(this.formatNumber(candidateExoplanetsDto.getPlanetUmlaufszeit())).append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            stringBuilder.append("<td>").append(candidateExoplanetsDto.getPlanetType()).append("</td>");
            if (candidateExoplanetsDto.getPlanetTemperatur() != null) {
                stringBuilder.append("<td>").append(this.formatNumber(candidateExoplanetsDto.getPlanetTemperatur())).append(" \u00b0C").append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            if (candidateExoplanetsDto.isPlanetInHz() != null) {
                stringBuilder.append("<td>").append(this.i18n.getString(candidateExoplanetsDto.isPlanetInHz().toString())).append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            if (candidateExoplanetsDto.getPlanetEsi() != null) {
                stringBuilder.append("<td>").append(this.formatNumber(candidateExoplanetsDto.getPlanetEsi())).append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            stringBuilder.append("<td>").append(candidateExoplanetsDto.getNotes()).append("</td>");
            if (candidateExoplanetsDto.isSternSptypDerived()) {
                String string = SprachcontainerFabrik.getI18nContainer().getString("webseite_m43");
                stringBuilder.append("<td>").append(candidateExoplanetsDto.getSternSptyp()).append(" (").append(string).append(")").append("</td>");
            } else {
                stringBuilder.append("<td>").append(candidateExoplanetsDto.getSternSptyp()).append("</td>");
            }
            stringBuilder.append("<td>").append(candidateExoplanetsDto.getSternSternbild()).append("</td>");
            if (candidateExoplanetsDto.getSternEntfernungInLy() != null) {
                stringBuilder.append("<td>").append(this.formatNumber(candidateExoplanetsDto.getSternEntfernungInLy())).append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            stringBuilder.append("</tr>");
            list2.add(stringBuilder.toString());
        }
    }

    private void writeTableHeader(List<String> list) {
        list.add("<tr><th>" + this.i18n.getString("webseite_m28") + "</th><th>" + this.i18n.getString("webseite_m29") + "</th><th>" + this.i18n.getString("webseite_m30") + "</th><th>" + this.i18n.getString("webseite_m34") + "</th><th>" + this.i18n.getString("webseite_m35") + "</th><th>" + this.i18n.getString("webseite_m49") + "</th><th>ESI</th><th>" + this.i18n.getString("webseite_m36") + "</th><th>" + this.i18n.getString("webseite_m31") + "</th><th>" + this.i18n.getString("webseite_m32") + "</th><th>" + this.i18n.getString("webseite_m33") + "</th></tr>");
    }

    private String formatPlanetRadius(double d) {
        double d2 = 11.194418312950768 * d;
        return this.formatNumber(d) + " Rj / " + this.formatNumber(d2) + " Re";
    }

    private String formatNumber(double d) {
        if (d == 0.0) {
            return "";
        }
        double d2 = (double)Math.round(d * 100.0) / 100.0;
        return this.i18n.toLocalisedDouble(d2);
    }

    private void writeChart(List<String> list) throws FileNotFoundException, IOException {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        Map<String, List<CandidateExoplanetsChartDto>> map = this.dataCollector.getChartData();
        for (Map.Entry<String, List<CandidateExoplanetsChartDto>> entry : map.entrySet()) {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)(entry.getKey() + " (" + this.i18n.toLocalisedInt(entry.getValue().size()) + ")")));
            for (CandidateExoplanetsChartDto candidateExoplanetsChartDto : entry.getValue()) {
                xYSeries.add(candidateExoplanetsChartDto.planetPeriodInDays(), candidateExoplanetsChartDto.planetRadiusInEarthUnit());
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.i18n.getString("sim_gui189"), this.i18n.getString("sim_gui190"), this.i18n.getString("sim_gui183"), xYSeriesCollection, PlotOrientation.VERTICAL, true, true, false);
        ChartUtils.saveChartAsPNG(new File("temp" + File.separator + "pht_candidates_" + this.i18n.getAktuelleSprache() + ".png"), jFreeChart, 1200, 800);
        list.add("<br><br>");
        list.add("<img src=\"https://planetensuche.de/confirmed_planets/pht_candidates_" + this.i18n.getAktuelleSprache() + ".png\" width=\"1200\" height=\"800\" alt=\"\">");
        list.add("<br><br>");
    }
}

