/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.webseite;

import com.google.inject.Injector;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.formeln.EarthSimilarityIndexExoplanetCalculator;
import de.planetensuche.datamodel.helfer.HabitateZoneRechner;
import de.planetensuche.datenbank.PlanetTypeDetectorService;
import de.planetensuche.datenbank.SptypErmittelnService;
import de.planetensuche.datenbank.webseite.ConfirmedExoplanetsDto;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QLumin;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import de.planetensuche.datenbankkern.querydsl5.QSternbilder;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class ConfirmedExoplanetsDataCollector {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder db;
    private final IIdCacheDAO cache;
    private final IObjektnamenRepository objektnamenRepo;
    private final IHabitableZoneRepository hzRepo;
    private final PlanetTypeDetectorService planetenTypErmittelnService;
    private final SptypErmittelnService sptypService;
    private final HabitateZoneRechner hzCalculator;
    private final EarthSimilarityIndexExoplanetCalculator esiCalculator;
    private final QDaten qDaten = QDaten.daten;
    private final QEntdecker qEntdecker = QEntdecker.entdecker;
    private final QZtentdecker qZtEntdecker = QZtentdecker.ztentdecker;
    private final QZt qZt = QZt.zt;
    private final QSternbilder qSternbilder = QSternbilder.sternbilder;
    private final QSpektraltyp qSptyp = QSpektraltyp.spektraltyp;
    private final QSpektraltyp2 qSptyp2 = QSpektraltyp2.spektraltyp2;
    private final QLumin qLumin = QLumin.lumin;

    public ConfirmedExoplanetsDataCollector(Injector injector) {
        this.db = injector.getInstance(IDatenbankverbinder.class);
        this.cache = injector.getInstance(IIdCacheDAO.class);
        this.objektnamenRepo = injector.getInstance(IObjektnamenRepository.class);
        this.hzRepo = injector.getInstance(IHabitableZoneRepository.class);
        this.planetenTypErmittelnService = injector.getInstance(PlanetTypeDetectorService.class);
        this.sptypService = injector.getInstance(SptypErmittelnService.class);
        this.hzCalculator = new HabitateZoneRechner();
        this.esiCalculator = new EarthSimilarityIndexExoplanetCalculator();
    }

    public long countNumberOfPhtConfirmedPlanets() {
        long l = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().selectDistinct((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qZtEntdecker)).on((Predicate)this.qZtEntdecker.datenid.eq(this.qDaten.id))).leftJoin((EntityPath)this.qEntdecker)).on((Predicate)this.qEntdecker.id.eq(this.qZtEntdecker.entdeckerid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase())).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetchCount();
        return l;
    }

    public List<ConfirmedExoplanetsDto> getMyPlanets() {
        return this.getDaten("G\u00fchne");
    }

    public List<ConfirmedExoplanetsDto> getPhtPlanets() {
        return this.getDaten(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase());
    }

    private List<ConfirmedExoplanetsDto> getDaten(String string) throws NonUniqueResultException {
        ArrayList<ConfirmedExoplanetsDto> arrayList = new ArrayList<ConfirmedExoplanetsDto>();
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.entfernung, this.qDaten.durchmesser, this.qDaten.masse, this.qDaten.umlaufszeit, this.qDaten.exzentritaet, this.qDaten.temperatur, this.qDaten.zugehoerigkeit, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qZtEntdecker)).on((Predicate)this.qZtEntdecker.datenid.eq(this.qDaten.id))).leftJoin((EntityPath)this.qEntdecker)).on((Predicate)this.qEntdecker.id.eq(this.qZtEntdecker.entdeckerid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qEntdecker.nachname.eq(string)).and(this.qDaten.entdeckungbestaetigt.isTrue()))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.desc(), this.qDaten.zugehoerigkeit.asc(), this.qDaten.id.asc()})).fetch();
            for (Tuple tuple : list) {
                ConfirmedExoplanetsDto confirmedExoplanetsDto = new ConfirmedExoplanetsDto();
                arrayList.add(confirmedExoplanetsDto);
                List<String> list2 = this.fillPlanetData(tuple, confirmedExoplanetsDto);
                Optional<Tuple> optional = this.fillStarData(tuple, confirmedExoplanetsDto, list2);
                if (!optional.isPresent()) continue;
                this.calcAndFillEsi(tuple, optional.get(), confirmedExoplanetsDto);
            }
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
        return arrayList;
    }

    private Optional<Tuple> fillStarData(Tuple tuple, ConfirmedExoplanetsDto confirmedExoplanetsDto, List<String> list) throws NonUniqueResultException {
        int n = tuple.get(this.qDaten.zugehoerigkeit);
        Tuple tuple2 = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qDaten.entfernung, this.qDaten.temperatur, this.qDaten.ah, this.qDaten.durchmesser, this.qSternbilder.latbezeichnung, this.qSptyp.typ, this.qSptyp2.typ, this.qLumin.typ}).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qZt)).on((Predicate)this.qZt.datenid.eq(this.qDaten.id))).leftJoin((EntityPath)this.qSternbilder)).on((Predicate)this.qSternbilder.id.eq(this.qZt.sternbildid))).leftJoin((EntityPath)this.qSptyp)).on((Predicate)this.qSptyp.id.eq(this.qDaten.spektralklasse))).leftJoin((EntityPath)this.qSptyp2)).on((Predicate)this.qSptyp2.id.eq(this.qDaten.spektralklasse2))).leftJoin((EntityPath)this.qLumin)).on((Predicate)this.qLumin.id.eq(this.qDaten.lumin))).where(this.qDaten.id.eq(n))).fetchOne();
        if (tuple2 != null) {
            if (tuple2.get(this.qDaten.entfernung) != null) {
                confirmedExoplanetsDto.setSternEntfernungInLy(tuple2.get(this.qDaten.entfernung));
            }
            if (tuple2.get(this.qSternbilder.latbezeichnung) != null) {
                confirmedExoplanetsDto.setSternSternbild(tuple2.get(this.qSternbilder.latbezeichnung));
            } else {
                confirmedExoplanetsDto.setSternSternbild("");
            }
            String string = tuple2.get(this.qSptyp.typ);
            if (Check.isFilled(string) && !"unbekannt".equals(string)) {
                confirmedExoplanetsDto.setSternSptyp(string + String.valueOf(tuple2.get(this.qSptyp2.typ)));
                String string2 = tuple2.get(this.qLumin.typ);
                if (Check.isFilled(string2) && !"unbekannt".equals(string2)) {
                    confirmedExoplanetsDto.setSternSptyp(confirmedExoplanetsDto.getSternSptyp() + string2);
                }
                confirmedExoplanetsDto.setSternSptypDerived(false);
            } else {
                String string3 = this.sptypService.findSptyp(tuple2.get(this.qDaten.temperatur), tuple2.get(this.qDaten.ah));
                if (Check.isFilled(string3)) {
                    confirmedExoplanetsDto.setSternSptyp(string3);
                    confirmedExoplanetsDto.setSternSptypDerived(true);
                } else {
                    confirmedExoplanetsDto.setSternSptyp("?");
                }
            }
        } else {
            this.logger.warn("keinen Stern gefunden f\u00fcr Planet " + list.get(0));
        }
        return Optional.ofNullable(tuple2);
    }

    private List<String> fillPlanetData(Tuple tuple, ConfirmedExoplanetsDto confirmedExoplanetsDto) throws SQLException {
        int n;
        Optional<Pair<Double, Double>> optional;
        Double d;
        List<String> list = this.objektnamenRepo.getNamenByDatenId(tuple.get(this.qDaten.id), ObjektnamenSortierung.ALPHABETISCH);
        String string = "https://exoplanetarchive.ipac.caltech.edu/overview/TIC%20" + this.getTicId(list);
        confirmedExoplanetsDto.setPlanetNames("<a href=\"" + string + "\">" + list.toString().replace("[", "").replace("]", "") + "</a>");
        confirmedExoplanetsDto.setDiscoveryYear(tuple.get(this.qDaten.entdeckungsjahr));
        if (tuple.get(this.qDaten.durchmesser) != null) {
            double d2 = tuple.get(this.qDaten.durchmesser);
            confirmedExoplanetsDto.setPlanetRadiusInJup(d2);
            double d3 = 11.194418312950768 * d2;
            confirmedExoplanetsDto.setPlanetType(this.planetenTypErmittelnService.getType(d3));
        } else {
            confirmedExoplanetsDto.setPlanetType("");
        }
        if (tuple.get(this.qDaten.masse) != null && tuple.get(this.qDaten.masse) > 0.0) {
            confirmedExoplanetsDto.setPlanetMassInJup(tuple.get(this.qDaten.masse));
        }
        if (tuple.get(this.qDaten.exzentritaet) != null) {
            confirmedExoplanetsDto.setEccentricity(tuple.get(this.qDaten.exzentritaet));
        }
        if ((d = tuple.get(this.qDaten.umlaufszeit)) != null && d > 0.0) {
            confirmedExoplanetsDto.setPlanetUmlaufszeit(d);
        }
        if (tuple.get(this.qDaten.temperatur) != null && tuple.get(this.qDaten.temperatur) >= -273.14) {
            double d4 = tuple.get(this.qDaten.temperatur);
            double d5 = d4 - 273.15;
            confirmedExoplanetsDto.setPlanetTemperatur(d5);
        } else {
            confirmedExoplanetsDto.setPlanetTemperatur(null);
        }
        Double d6 = tuple.get(this.qDaten.entfernung);
        if ((d6 != null && d6 > 0.0 || d != null && d > 0.0) && (optional = this.hzRepo.getInnerAndOuterHZ(n = tuple.get(this.qDaten.zugehoerigkeit).intValue())).isPresent()) {
            confirmedExoplanetsDto.setPlanetInHz(this.hzCalculator.isPlanetInHz(optional.get().getLeft(), optional.get().getRight(), d6, d));
        }
        return list;
    }

    private String getTicId(List<String> list) {
        for (String string : list) {
            if (!string.startsWith("TIC ")) continue;
            return string.substring(4, string.length() - 3);
        }
        return list.get(0);
    }

    private void calcAndFillEsi(Tuple tuple, Tuple tuple2, ConfirmedExoplanetsDto confirmedExoplanetsDto) {
        Optional<Double> optional = this.esiCalculator.calcESI(tuple.get(this.qDaten.durchmesser), tuple.get(this.qDaten.entfernung), tuple.get(this.qDaten.umlaufszeit), tuple2.get(this.qDaten.ah), tuple2.get(this.qDaten.temperatur), tuple2.get(this.qDaten.durchmesser));
        if (optional.isPresent()) {
            confirmedExoplanetsDto.setPlanetEsi(optional.get());
        }
    }
}

