/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.webseite;

import com.google.inject.Injector;
import de.planetensuche.datenbank.dbmodel.BeanFactory;
import de.planetensuche.datenbank.webseite.ConfirmedExoplanetsDataCollector;
import de.planetensuche.datenbank.webseite.ConfirmedExoplanetsDto;
import de.planetensuche.datenbank.webseite.PlanetensucheInfoCollector;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ConfirmedExoplanetsWebsiteGenerator {
    private final String templateFileName = "confirmed_planets";
    private final String outputFileName = "my_confirmed_exoplanets";
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ConfirmedExoplanetsDataCollector dataCollector;
    private final PlanetensucheInfoCollector infoCollector;
    private final ISprachcontainer i18n;

    public ConfirmedExoplanetsWebsiteGenerator() {
        Injector injector = BeanFactory.getInjector();
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.dataCollector = new ConfirmedExoplanetsDataCollector(injector);
        this.infoCollector = new PlanetensucheInfoCollector(injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generiereKandidatenWebseite() {
        String string = this.i18n.getAktuelleSprache();
        try {
            List<ConfirmedExoplanetsDto> list = this.dataCollector.getMyPlanets();
            List<ConfirmedExoplanetsDto> list2 = this.dataCollector.getPhtPlanets();
            List<String> list3 = Arrays.asList("de", "en");
            for (String string2 : list3) {
                List<String> list4 = FileUtils.readLines(new File("webseite" + File.separator + "confirmed_planets_" + string2 + ".html"), StandardCharsets.UTF_8);
                ArrayList<String> arrayList = new ArrayList<String>();
                this.i18n.setAktuelleSprache(string2.equals("de") ? "deutsch" : "english");
                for (String string3 : list4) {
                    if (string3.contains("TODO TABELE 1")) {
                        this.writeTableHeader(arrayList);
                        this.writeTableBody(list, arrayList);
                        continue;
                    }
                    if (string3.contains("TODO TABELE 2")) {
                        this.writeTableHeader(arrayList);
                        this.writeTableBody(list2, arrayList);
                        continue;
                    }
                    if (string3.contains("TODO HINWEIS")) {
                        arrayList.add(this.dataCollector.countNumberOfPhtConfirmedPlanets() + " " + this.i18n.getString("webseite_m37") + " / " + list.size() + " " + this.i18n.getString("webseite_m45") + "<br><br>");
                        arrayList.add(this.i18n.getString("webseite_m8") + " " + this.infoCollector.getPlanetensucheVersion() + "<br>");
                        arrayList.add("<br><br>" + this.i18n.getString("webseite_m41", Instant.now()));
                        continue;
                    }
                    arrayList.add(string3);
                }
                String string4 = "temp" + File.separator + "my_confirmed_exoplanets_" + string2 + ".html";
                FileUtils.writeLines(new File(string4), "utf8", arrayList, false);
            }
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
        finally {
            try {
                this.i18n.setAktuelleSprache(string);
            }
            catch (IOException iOException) {
                this.logger.error(iOException);
            }
        }
    }

    private void writeTableHeader(List<String> list) {
        list.add("<tr><th>" + this.i18n.getString("webseite_m44") + "</th><th>" + this.i18n.getString("webseite_m46") + "</th><th>" + this.i18n.getString("webseite_m29") + "</th><th>" + this.i18n.getString("webseite_m47") + "</th><th>" + this.i18n.getString("webseite_m30") + "</th><th>" + this.i18n.getString("webseite_m34") + "</th><th>" + this.i18n.getString("webseite_m48") + "</th><th>" + this.i18n.getString("webseite_m35") + "</th><th>" + this.i18n.getString("webseite_m49") + "</th><th>ESI</th><th>" + this.i18n.getString("webseite_m31") + "</th><th>" + this.i18n.getString("webseite_m32") + "</th><th>" + this.i18n.getString("webseite_m33") + "</th></tr>");
    }

    private void writeTableBody(List<ConfirmedExoplanetsDto> list, List<String> list2) {
        for (ConfirmedExoplanetsDto confirmedExoplanetsDto : list) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>").append(confirmedExoplanetsDto.getPlanetNames()).append("</td>");
            stringBuilder.append("<td>").append(confirmedExoplanetsDto.getDiscoveryYear()).append("</td>");
            stringBuilder.append("<td>").append(this.formatPlanetRadius(confirmedExoplanetsDto.getPlanetRadiusInJup())).append("</td>");
            stringBuilder.append("<td>").append(this.formatPlanetMass(confirmedExoplanetsDto.getPlanetMassInJup())).append("</td>");
            if (confirmedExoplanetsDto.getPlanetUmlaufszeit() != null) {
                stringBuilder.append("<td>").append(this.formatNumber(confirmedExoplanetsDto.getPlanetUmlaufszeit())).append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            stringBuilder.append("<td>").append(confirmedExoplanetsDto.getPlanetType()).append("</td>");
            if (confirmedExoplanetsDto.getEccentricity() != null) {
                stringBuilder.append("<td>").append(this.formatNumber(confirmedExoplanetsDto.getEccentricity())).append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            if (confirmedExoplanetsDto.getPlanetTemperatur() != null) {
                stringBuilder.append("<td>").append(this.formatNumber(confirmedExoplanetsDto.getPlanetTemperatur())).append(" \u00b0C").append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            if (confirmedExoplanetsDto.isPlanetInHz() != null) {
                stringBuilder.append("<td>").append(this.i18n.getString(confirmedExoplanetsDto.isPlanetInHz().toString())).append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            if (confirmedExoplanetsDto.getPlanetEsi() != null) {
                stringBuilder.append("<td>").append(this.formatNumber(confirmedExoplanetsDto.getPlanetEsi())).append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            if (confirmedExoplanetsDto.isSternSptypDerived()) {
                String string = SprachcontainerFabrik.getI18nContainer().getString("webseite_m43");
                stringBuilder.append("<td>").append(confirmedExoplanetsDto.getSternSptyp()).append(" (").append(string).append(")").append("</td>");
            } else {
                stringBuilder.append("<td>").append(confirmedExoplanetsDto.getSternSptyp()).append("</td>");
            }
            stringBuilder.append("<td>").append(confirmedExoplanetsDto.getSternSternbild()).append("</td>");
            if (confirmedExoplanetsDto.getSternEntfernungInLy() != null) {
                stringBuilder.append("<td>").append(this.formatNumber(confirmedExoplanetsDto.getSternEntfernungInLy())).append("</td>");
            } else {
                stringBuilder.append("<td>").append("</td>");
            }
            stringBuilder.append("</tr>");
            list2.add(stringBuilder.toString());
        }
    }

    private String formatPlanetRadius(double d) {
        double d2 = 11.194418312950768 * d;
        return this.formatNumber(d) + " Rj / " + this.formatNumber(d2) + " Re";
    }

    private String formatPlanetMass(Double d) {
        if (d == null) {
            return "";
        }
        double d2 = 317.87746903247404 * d;
        return this.formatNumber(d) + " Mj / " + this.formatNumber(d2) + " Me";
    }

    private String formatNumber(double d) {
        if (d == 0.0) {
            return "";
        }
        double d2 = d > 0.0 && d < 0.1 ? (double)Math.round(d * 1000.0) / 1000.0 : (double)Math.round(d * 100.0) / 100.0;
        return this.i18n.toLocalisedDouble(d2);
    }
}

