/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.webseite;

import com.google.inject.Injector;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbank.webseite.ExoplanetenJagdtDto;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdeckungsmethode;
import de.planetensuche.datenbankkern.querydsl5.QHabitableZone;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ExoplanetenJagdtDataCollector {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final String exoplanetDetailsUrl = "https://exoplanetarchive.ipac.caltech.edu/overview/";
    private final IDatenbankverbinder db;
    private final IIdCacheDAO cache;
    private final QDaten qDaten = QDaten.daten;
    private final QDaten exoplanets = new QDaten("exoplanets");
    private final QDaten stars = new QDaten("stars");
    private final QNamen qNamen = QNamen.namen1;
    private final QEntdecker qEntdecker = QEntdecker.entdecker;
    private final QZtentdecker qZtEntdecker = QZtentdecker.ztentdecker;

    public ExoplanetenJagdtDataCollector(Injector injector) {
        this.db = injector.getInstance(IDatenbankverbinder.class);
        this.cache = injector.getInstance(IIdCacheDAO.class);
    }

    public List<ExoplanetenJagdtDto> getExoplanetenJagdtDaten() {
        ArrayList<ExoplanetenJagdtDto> arrayList = new ArrayList<ExoplanetenJagdtDto>();
        arrayList.add(new ExoplanetenJagdtDto(1995, "webseite_m7", "http://exoplanet.eu/", ""));
        arrayList.add(new ExoplanetenJagdtDto(2002, "webseite_m6", "https://planetensuche.de/ps/handbuch/en/historie.html", ""));
        arrayList.add(new ExoplanetenJagdtDto(2011, "webseite_m5", "https://exoplanetarchive.ipac.caltech.edu/", ""));
        arrayList.add(new ExoplanetenJagdtDto(2016, "webseite_m16", "https://arxiv.org/abs/1605.02825", "Timothy D. Morton"));
        arrayList.add(new ExoplanetenJagdtDto(2019, "webseite_m4", "https://www.nobelprize.org/prizes/physics/2019/summary/", "51 Pegasi b"));
        arrayList.add(new ExoplanetenJagdtDto(2021, "webseite_m27", "https://planetensuche.de/en/planet_hunters_tess.html", ""));
        arrayList.add(new ExoplanetenJagdtDto(2021, "webseite_m40", "https://planetensuche.de/en/my_exoplanet_candidates_en.html", "TIC 59490344.01"));
        arrayList.add(new ExoplanetenJagdtDto(2022, "webseite_m50", "https://www.planetensuche.de/en/my_confirmed_exoplanets_en.html", "TOI-5174 b"));
        try {
            arrayList.add(this.getErsterExoplanet());
            arrayList.add(this.getErsterExoplanetUmSonnenaehnlichenStern());
            arrayList.add(this.getErsterExoplanetErdgroesse());
            arrayList.add(this.getNaehsterExoplanet());
            arrayList.add(this.getErsterTransitPlanet());
            arrayList.add(this.getErsterMicrolensingPlanet());
            arrayList.add(this.getErsterDirektFotografierterPlanet());
            arrayList.add(this.getErsterPlanetAmateur());
            arrayList.add(this.getExoplanetZweiteErde());
            arrayList.add(this.getErsteWasserWelt());
            arrayList.add(this.getErsterExoplanetInDoppelsternSystem());
            arrayList.addAll(this.getWeltraumTeleskope());
            arrayList.add(this.getErsteExoplanetenDeepLearning());
            arrayList.add(this.getErsteExoplanetenExoMiner());
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        Collections.sort(arrayList, (exoplanetenJagdtDto, exoplanetenJagdtDto2) -> -1 * Integer.compare(exoplanetenJagdtDto.getJahr(), exoplanetenJagdtDto2.getJahr()));
        return arrayList;
    }

    private ExoplanetenJagdtDto getErsteWasserWelt() {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qNamen.namen.eq("TOI-1452 b").or(this.qNamen.namen.eq("TOI-1452.01"))))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m42", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getExoplanetZweiteErde() {
        QDaten qDaten = new QDaten("planeten");
        QDaten qDaten2 = new QDaten("sterne");
        QHabitableZone qHabitableZone = QHabitableZone.habitableZone;
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, qDaten.entdeckungsjahr}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).join((EntityPath)qHabitableZone)).on((Predicate)qHabitableZone.datenid.eq(qDaten2.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)qDaten.id.eq(this.qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(qDaten.durchmesser.between(0.08028, 0.09812000000000001)).and(qDaten.entfernung.between(qHabitableZone.innerHz, qHabitableZone.outerHz)).and(qDaten.entdeckungbestaetigt.isTrue()))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m26", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getErsterPlanetAmateur() {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).join((EntityPath)this.qZtEntdecker)).on((Predicate)this.qDaten.id.eq(this.qZtEntdecker.datenid))).join((EntityPath)this.qEntdecker)).on((Predicate)this.qZtEntdecker.entdeckerid.eq(this.qEntdecker.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qEntdecker.nachname.in(EntdeckerProjekte.EXOPLANET_EXPLORERS.getNameInDatabase(), EntdeckerProjekte.PLANET_HUNTERS.getNameInDatabase())).and(this.qDaten.entdeckungbestaetigt.isTrue()))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m25", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private List<ExoplanetenJagdtDto> getWeltraumTeleskope() throws SQLException {
        ArrayList<ExoplanetenJagdtDto> arrayList = new ArrayList<ExoplanetenJagdtDto>();
        for (EntdeckerWeltraumteleskope entdeckerWeltraumteleskope : EntdeckerWeltraumteleskope.values()) {
            Optional<ExoplanetenJagdtDto> optional = this.getErsterPlanetWeltraumteleskop(entdeckerWeltraumteleskope, 2003);
            if (!optional.isPresent()) continue;
            arrayList.add(optional.get());
        }
        return arrayList;
    }

    private Optional<ExoplanetenJagdtDto> getErsterPlanetWeltraumteleskop(EntdeckerWeltraumteleskope entdeckerWeltraumteleskope, int n) throws SQLException {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).join((EntityPath)this.qZtEntdecker)).on((Predicate)this.qDaten.id.eq(this.qZtEntdecker.datenid))).join((EntityPath)this.qEntdecker)).on((Predicate)this.qZtEntdecker.entdeckerid.eq(this.qEntdecker.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qEntdecker.nachname.eq(entdeckerWeltraumteleskope.getNameInDatabase())).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.entdeckungsjahr.goe(n)).and(this.qDaten.zugehoerigkeit.ne(this.cache.getDatenIdSonne())))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        if (tuple == null || tuple.get(this.qNamen) == null) {
            return Optional.empty();
        }
        String string = tuple.get(this.qNamen).getNamen();
        int n2 = tuple.get(this.qNamen).getDatenid();
        int n3 = tuple.get(this.qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n2, string);
        ExoplanetenJagdtDto exoplanetenJagdtDto = new ExoplanetenJagdtDto(n3, "webseite_m53", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
        exoplanetenJagdtDto.setBeschreibungParameter(entdeckerWeltraumteleskope.getNameInDatabase());
        return Optional.of(exoplanetenJagdtDto);
    }

    private ExoplanetenJagdtDto getErsterDirektFotografierterPlanet() throws SQLException {
        QEntdeckungsmethode qEntdeckungsmethode = QEntdeckungsmethode.entdeckungsmethode;
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).join((EntityPath)qEntdeckungsmethode)).on((Predicate)this.qDaten.entdeckungsmethode.eq(qEntdeckungsmethode.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(qEntdeckungsmethode.methode.eq("Direkte Abbildung")).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne(this.cache.getDatenIdSonne())))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m21", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getErsterMicrolensingPlanet() {
        QEntdeckungsmethode qEntdeckungsmethode = QEntdeckungsmethode.entdeckungsmethode;
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).join((EntityPath)qEntdeckungsmethode)).on((Predicate)this.qDaten.entdeckungsmethode.eq(qEntdeckungsmethode.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(qEntdeckungsmethode.methode.eq("Microlensing")).and(this.qDaten.entdeckungsjahr.lt(2010)).and(this.qDaten.entdeckungbestaetigt.isTrue()))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m20", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getErsterTransitPlanet() {
        QEntdeckungsmethode qEntdeckungsmethode = QEntdeckungsmethode.entdeckungsmethode;
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).join((EntityPath)qEntdeckungsmethode)).on((Predicate)this.qDaten.entdeckungsmethode.eq(qEntdeckungsmethode.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(qEntdeckungsmethode.methode.eq("Transit-Suchmethode")).and(this.qDaten.entdeckungsjahr.lt(2005)).and(this.qDaten.entdeckungbestaetigt.isTrue()))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m19", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getNaehsterExoplanet() throws SQLException {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.exoplanets.entdeckungsjahr}).from((Expression<?>)this.exoplanets)).join((EntityPath)this.stars)).on((Predicate)this.exoplanets.zugehoerigkeit.eq(this.stars.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.exoplanets.id.eq(this.qNamen.datenid))).where(this.exoplanets.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.exoplanets.entdeckungbestaetigt.isTrue()).and(this.stars.entfernung.between(1.0, 33.0)).and(this.exoplanets.zugehoerigkeit.ne(this.cache.getDatenIdSonne())))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.stars.entfernung.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.exoplanets.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m18", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getErsterExoplanetInDoppelsternSystem() throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        List<String> list = List.of(StarObjectType.DOUBLE_STAR_REAL.getTypeName(), StarObjectType.ECLIPSING_BINARY.getTypeName());
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.exoplanets.entdeckungsjahr}).from((Expression<?>)this.exoplanets)).join((EntityPath)this.stars)).on((Predicate)this.exoplanets.zugehoerigkeit.eq(this.stars.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.exoplanets.id.eq(this.qNamen.datenid))).where(this.exoplanets.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.exoplanets.entdeckungbestaetigt.isTrue()).and(this.stars.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.in(list)))))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.exoplanets.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchFirst();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.exoplanets.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m52", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getErsterExoplanetErdgroesse() {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qDaten.durchmesser.between(0.08028, 0.09812000000000001)).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.entdeckungsjahr.isNotNull()))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m17", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getErsterExoplanet() throws SQLException {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne(this.cache.getDatenIdSonne())))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchFirst();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qDaten.entdeckungsjahr);
        int n2 = tuple.get(this.qNamen).getDatenid();
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n2, string);
        return new ExoplanetenJagdtDto(n, "webseite_m13", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getErsterExoplanetUmSonnenaehnlichenStern() throws SQLException {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.exoplanets.entdeckungsjahr}).from((Expression<?>)this.exoplanets)).join((EntityPath)this.stars)).on((Predicate)this.exoplanets.zugehoerigkeit.eq(this.stars.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.exoplanets.id.eq(this.qNamen.datenid))).where(this.exoplanets.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.exoplanets.entdeckungbestaetigt.isTrue()).and(this.stars.temperatur.between(5750.0, 5950.0)).and(this.stars.durchmesser.between(0.9, 1.1)).and(this.exoplanets.zugehoerigkeit.ne(this.cache.getDatenIdSonne())))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.exoplanets.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchFirst();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.exoplanets.entdeckungsjahr);
        int n2 = tuple.get(this.qNamen).getDatenid();
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n2, string);
        return new ExoplanetenJagdtDto(n, "webseite_m15", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private String holeEntdeckerUndErzeugeZusatzinfo(int n, String string) {
        List<Entdecker> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select((Expression)this.qEntdecker).from((Expression<?>)this.qEntdecker)).leftJoin((EntityPath)this.qZtEntdecker)).on((Predicate)this.qZtEntdecker.entdeckerid.eq(this.qEntdecker.id))).leftJoin((EntityPath)this.qDaten)).on((Predicate)this.qDaten.id.eq(this.qZtEntdecker.datenid))).where(this.qDaten.id.eq(n))).orderBy((OrderSpecifier<?>)this.qEntdecker.typ.asc())).fetch();
        String string2 = this.erzeugeZusatzInfo(string, list);
        return string2;
    }

    private String erzeugeZusatzInfo(String string, List<Entdecker> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (Check.isFilled(list)) {
            stringBuilder.append(": ");
            boolean bl = true;
            for (Entdecker entdecker : list) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                if (entdecker.getVorname() != null) {
                    stringBuilder.append(entdecker.getVorname()).append(" ").append(entdecker.getNachname());
                } else {
                    stringBuilder.append(entdecker.getNachname());
                }
                bl = false;
            }
        }
        String string2 = stringBuilder.toString();
        return string2;
    }

    private ExoplanetenJagdtDto getErsteExoplanetenDeepLearning() {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qNamen.namen.eq("Kepler-90 i").or(this.qNamen.namen.eq("Kepler-80 g"))))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m54", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }

    private ExoplanetenJagdtDto getErsteExoplanetenExoMiner() {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.db.getQueryFactory().select(new Expression[]{this.qNamen, this.qDaten.entdeckungsjahr}).from((Expression<?>)this.qDaten)).join((EntityPath)this.qZtEntdecker)).on((Predicate)this.qDaten.id.eq(this.qZtEntdecker.datenid))).join((EntityPath)this.qEntdecker)).on((Predicate)this.qZtEntdecker.entdeckerid.eq(this.qEntdecker.id))).leftJoin((EntityPath)this.qNamen)).on((Predicate)this.qDaten.id.eq(this.qNamen.datenid))).where(this.qDaten.objektid.in((Collection<Integer>)this.cache.getObjekttypenidsPlaneten()).and(this.qEntdecker.nachname.eq(EntdeckerProjekte.EXO_MINER.getNameInDatabase())).and(this.qDaten.entdeckungbestaetigt.isTrue()))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qDaten.entdeckungsjahr.asc(), this.qNamen.namen.asc()})).limit(1L)).fetchOne();
        String string = tuple.get(this.qNamen).getNamen();
        int n = tuple.get(this.qNamen).getDatenid();
        int n2 = tuple.get(this.qDaten.entdeckungsjahr);
        String string2 = this.holeEntdeckerUndErzeugeZusatzinfo(n, string);
        return new ExoplanetenJagdtDto(n2, "webseite_m55", "https://exoplanetarchive.ipac.caltech.edu/overview/" + string, string2);
    }
}

