/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.webseite;

import com.google.inject.Injector;
import de.planetensuche.datenbank.dbmodel.BeanFactory;
import de.planetensuche.datenbank.webseite.ExoplanetenJagdtDataCollector;
import de.planetensuche.datenbank.webseite.ExoplanetenJagdtDto;
import de.planetensuche.datenbank.webseite.PlanetensucheInfoCollector;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ExoplanetenJagdtWebseitengenerator {
    private final String templateFileName = "template";
    private final String ausgabeDateiName = "exoplanet_hunt_history";
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ExoplanetenJagdtDataCollector exoplanetenJagdtDataCollector;
    private final PlanetensucheInfoCollector infoCollector;
    private final ISprachcontainer i18n;

    public ExoplanetenJagdtWebseitengenerator() {
        Injector injector = BeanFactory.getInjector();
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.exoplanetenJagdtDataCollector = new ExoplanetenJagdtDataCollector(injector);
        this.infoCollector = new PlanetensucheInfoCollector(injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generiereExoplanetenJagdtWebseite() {
        String string = this.i18n.getAktuelleSprache();
        try {
            List<ExoplanetenJagdtDto> list = this.exoplanetenJagdtDataCollector.getExoplanetenJagdtDaten();
            List<String> list2 = Arrays.asList("de", "en");
            for (String string2 : list2) {
                List<String> list3 = FileUtils.readLines(new File("webseite" + File.separator + "template_" + string2 + ".html"), StandardCharsets.UTF_8);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                this.i18n.setAktuelleSprache(string2.equals("de") ? "deutsch" : "english");
                for (String string3 : list3) {
                    if (string3.contains("TODO TABELE")) {
                        arrayList.add("<tr><th>" + this.i18n.getString("webseite_m1") + "</th><th>" + this.i18n.getString("webseite_m2") + " / " + this.i18n.getString("webseite_m3") + "</th><th>" + this.i18n.getString("webseite_m14") + "</th></tr>");
                        for (ExoplanetenJagdtDto exoplanetenJagdtDto : list) {
                            String string4 = exoplanetenJagdtDto.getBeschreibungParameter() == null ? this.i18n.getString(exoplanetenJagdtDto.getBeschreibungAlsKey()) : this.i18n.getString(exoplanetenJagdtDto.getBeschreibungAlsKey(), exoplanetenJagdtDto.getBeschreibungParameter());
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("<tr><td>").append(exoplanetenJagdtDto.getJahr()).append("</td>");
                            stringBuilder.append("<td><a href=\"").append(exoplanetenJagdtDto.getLink()).append("\">").append(string4).append("</a>").append("</td><td>").append(exoplanetenJagdtDto.getZusatzInfo()).append("</td></tr>");
                            arrayList.add(stringBuilder.toString());
                        }
                        continue;
                    }
                    if (string3.contains("TODO HINWEIS")) {
                        arrayList.add(this.i18n.getString("webseite_m8") + " " + this.infoCollector.getPlanetensucheVersion() + " " + this.i18n.getString("webseite_m9") + "<br>");
                        arrayList.add("<ul>");
                        arrayList.add("<li>" + this.infoCollector.getAnzahlExoplaneten() + " " + this.i18n.getString("webseite_m10") + "</li>");
                        arrayList.add("<li>" + this.infoCollector.getAnzahlExoplanetenProjekte() + " " + this.i18n.getString("webseite_m11") + "</li>");
                        arrayList.add("<li>" + this.infoCollector.getAnzahlExoplanetenEntdecker() + " " + this.i18n.getString("webseite_m12") + "</li>");
                        arrayList.add("</ul>");
                        arrayList.add("<br><br>" + this.i18n.getString("webseite_m41", Instant.now()));
                        continue;
                    }
                    arrayList.add(string3);
                }
                FileUtils.writeLines(new File("temp" + File.separator + "exoplanet_hunt_history_" + string2 + ".html"), "utf8", arrayList, false);
            }
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
        finally {
            try {
                this.i18n.setAktuelleSprache(string);
            }
            catch (IOException iOException) {
                this.logger.error(iOException);
            }
        }
    }
}

