/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.webseite;

import com.google.inject.Injector;
import de.planetensuche.datenbankkern.api.kategorien.IPlanetenRepository;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import java.io.IOException;
import java.sql.SQLException;

public class PlanetensucheInfoCollector {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final Injector injector;

    public PlanetensucheInfoCollector(Injector injector) {
        this.injector = injector;
    }

    public String getPlanetensucheVersion() {
        try {
            return KonfiguratorFabrik.getKonfigurator().read().getVersion();
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
            return iOException.getMessage();
        }
    }

    public int getAnzahlExoplaneten() {
        try {
            IPlanetenRepository iPlanetenRepository = this.injector.getInstance(IPlanetenRepository.class);
            return iPlanetenRepository.getAnzahlBestaetigteExoplaneten();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return -1;
        }
    }

    public int getAnzahlExoplanetenProjekte() {
        IEntdeckerRepository iEntdeckerRepository = this.injector.getInstance(IEntdeckerRepository.class);
        return iEntdeckerRepository.findAllDiscovererTeams().size();
    }

    public int getAnzahlExoplanetenEntdecker() {
        IEntdeckerRepository iEntdeckerRepository = this.injector.getInstance(IEntdeckerRepository.class);
        return iEntdeckerRepository.findAllExoplanetDiscovererPersons().size();
    }
}

