/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.xmlschema;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;

public final class XMLSchemaGenerator {
    private static final String CURRENT_XML_VERSION = "1.3";
    private OutputStreamWriter writer;
    private final ILogging logging;
    private final KonfigurationDTO globaleKonfig;

    public XMLSchemaGenerator(ILogging iLogging, KonfigurationDTO konfigurationDTO) {
        this.logging = iLogging;
        this.globaleKonfig = konfigurationDTO;
    }

    public static String getXmlversion() {
        return CURRENT_XML_VERSION;
    }

    public void erstelleHeader(File file) {
        try {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Charset.forName("UTF-8"));
            this.schreibeZeile("<?xml version='1.0' encoding='utf8'?>");
            this.schreibeZeile("");
            this.schreibeZeile("<!-- Planetensuche XML-Schema Version 1.3,");
            this.schreibeZeile("Autor: Gerd G\u00fchne");
            this.schreibeZeile("Homepage: https://www." + this.globaleKonfig.getHomepageHostname() + " -->");
            this.schreibeZeile("");
            this.schreibeZeile("<xsd:schema");
            this.schreibeZeile("\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
            this.schreibeZeile("\ttargetNamespace=\"https://www." + this.globaleKonfig.getHomepageHostname() + "\"");
            this.schreibeZeile("\txmlns=\"https://www." + this.globaleKonfig.getHomepageHostname() + "\">");
            this.schreibeZeile("");
        }
        catch (IOException iOException) {
            this.logging.error("erstelleHeader()(" + file.getName() + ")", iOException);
        }
    }

    private void schreibeZeile(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            this.logging.error("schreibeZeile(" + string + ")", iOException);
        }
    }

    private void erstelleObjekttypen(List<String> list) {
        this.schreibeZeile("\t\t<xsd:attribute name=\"objekttyp\">");
        this.schreibeZeile("\t\t\t<xsd:simpleType>");
        this.schreibeZeile("\t\t\t\t<xsd:restriction base=\"xsd:string\">");
        for (String string : list) {
            this.schreibeZeile("\t\t\t\t\t<xsd:enumeration value=\"" + string + "\"/>");
        }
        this.schreibeZeile("\t\t\t\t</xsd:restriction>");
        this.schreibeZeile("\t\t\t</xsd:simpleType>");
        this.schreibeZeile("\t\t</xsd:attribute>");
    }

    public void erstelleEinheiten(String string, List<String> list) {
        this.schreibeZeile("<xsd:element name=\"" + string + "\">");
        this.schreibeZeile("\t<xsd:complexType>");
        this.schreibeZeile("\t\t<xsd:attribute name=\"wert\" type=\"xsd:double\"/>");
        this.schreibeZeile("\t\t<xsd:attribute name=\"einheit\">");
        this.schreibeZeile("\t\t\t<xsd:simpleType>");
        this.schreibeZeile("\t\t\t<xsd:restriction base=\"xsd:string\">");
        for (int i = 0; i < list.size(); ++i) {
            this.schreibeZeile("\t\t\t\t<xsd:enumeration value=\"" + list.get(i) + "\"/>");
        }
        this.schreibeZeile("\t\t\t</xsd:restriction>");
        this.schreibeZeile("\t\t</xsd:simpleType>");
        this.schreibeZeile("\t\t</xsd:attribute>");
        this.schreibeZeile("\t</xsd:complexType>");
        this.schreibeZeile("</xsd:element>");
        this.schreibeZeile("");
    }

    public void erstelleEinheitenMitEinemAttribut(String string, String string2, List<String> list) {
        this.schreibeZeile("<xsd:element name=\"" + string + "\">");
        this.schreibeZeile("\t<xsd:complexType>");
        this.schreibeZeile("\t\t<xsd:attribute name=\"" + string2 + "\">");
        this.schreibeZeile("\t\t\t<xsd:simpleType>");
        this.schreibeZeile("\t\t\t\t<xsd:restriction base=\"xsd:string\">");
        for (int i = 0; i < list.size(); ++i) {
            this.schreibeZeile("\t\t\t\t\t<xsd:enumeration value=\"" + list.get(i) + "\"/>");
        }
        this.schreibeZeile("\t\t\t\t</xsd:restriction>");
        this.schreibeZeile("\t\t\t</xsd:simpleType>");
        this.schreibeZeile("\t\t</xsd:attribute>");
        this.schreibeZeile("\t</xsd:complexType>");
        this.schreibeZeile("</xsd:element>");
        this.schreibeZeile("");
    }

    public void erstelleUmlaufszeit() {
        this.schreibeZeile("<xsd:element name=\"umlaufszeit\">");
        this.schreibeZeile("\t<xsd:complexType>");
        this.schreibeZeile("\t\t<xsd:attribute name=\"wert\" type=\"xsd:double\"/>");
        this.schreibeZeile("\t\t<xsd:attribute name=\"einheit\" fixed=\"Tage\"/>");
        this.schreibeZeile("\t</xsd:complexType>");
        this.schreibeZeile("</xsd:element>");
        this.schreibeZeile("");
    }

    public void erstelleSpektraltypSterneBrZwerge(List<String> list, List<Double> list2) {
        int n;
        this.schreibeZeile("<xsd:element name=\"spektraltyp_sterne_brzwerge\">");
        this.schreibeZeile("\t<xsd:complexType>");
        this.schreibeZeile("\t\t<xsd:attribute name=\"klasse1\" use=\"required\">");
        this.schreibeZeile("\t\t\t<xsd:simpleType>");
        this.schreibeZeile("\t\t\t\t<xsd:restriction base=\"xsd:string\">");
        for (n = 0; n < list.size(); ++n) {
            this.schreibeZeile("\t\t\t\t\t<xsd:enumeration value=\"" + list.get(n) + "\"/>");
        }
        this.schreibeZeile("\t\t\t\t</xsd:restriction>");
        this.schreibeZeile("\t\t\t</xsd:simpleType>");
        this.schreibeZeile("\t\t</xsd:attribute>");
        this.schreibeZeile("\t\t<xsd:attribute name=\"klasse2\" use=\"required\">");
        this.schreibeZeile("\t\t\t<xsd:simpleType>");
        this.schreibeZeile("\t\t\t\t<xsd:restriction base=\"xsd:string\">");
        for (n = 0; n < list2.size(); ++n) {
            this.schreibeZeile("\t\t\t\t\t<xsd:enumeration value=\"" + String.valueOf(list2.get(n)) + "\"/>");
        }
        this.schreibeZeile("\t\t\t\t</xsd:restriction>");
        this.schreibeZeile("\t\t\t</xsd:simpleType>");
        this.schreibeZeile("\t\t</xsd:attribute>");
        this.schreibeZeile("\t</xsd:complexType>");
        this.schreibeZeile("</xsd:element>");
        this.schreibeZeile("");
    }

    public void erstelleElement(String string, String string2) {
        this.schreibeZeile("<xsd:element name=\"" + string + "\" type=\"xsd:" + string2 + "\"/>");
        this.schreibeZeile("");
    }

    public void erstelleElementObjekt(List<String> list) {
        this.schreibeZeile("<xsd:element name=\"objekt\">");
        this.schreibeZeile("\t<xsd:complexType>");
        this.schreibeZeile("\t\t<xsd:sequence>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"name\" maxOccurs=\"unbounded\"/>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"entfernung\" minOccurs=\"0\"/>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"durchmesser\" minOccurs=\"0\" maxOccurs=\"2\"/>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"masse\" minOccurs=\"0\"/>");
        this.schreibeZeile("\t\t\t<xsd:choice>");
        for (int i = 0; i < list.size(); ++i) {
            if ("Sternbilder".equals(list.get(i))) continue;
            this.schreibeZeile("\t\t\t\t<xsd:element ref=\"" + list.get(i).replaceAll(" ", "_").toLowerCase() + "\"/>");
        }
        this.schreibeZeile("\t\t\t</xsd:choice>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"entdecker\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"referenz\" minOccurs=\"0\"/>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"notiz\" minOccurs=\"0\"/>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"bilder\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"autor\"/>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"timestamp\"/>");
        this.schreibeZeile("\t\t</xsd:sequence>");
        this.schreibeZeile("\t</xsd:complexType>");
        this.schreibeZeile("</xsd:element>");
        this.schreibeZeile("");
    }

    public void erstelleKategorie(String string, List<String> list, List<String> list2, List<String> list3) {
        int n;
        this.schreibeZeile("<xsd:element name=\"" + string + "\">");
        this.schreibeZeile("\t<xsd:complexType>");
        this.schreibeZeile("\t\t<xsd:all>");
        if (list2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                this.schreibeZeile("\t\t\t<xsd:element ref=\"" + list2.get(n) + "\" minOccurs=\"0\"/>");
            }
        }
        if (list3 != null) {
            for (n = 0; n < list3.size(); ++n) {
                this.schreibeZeile("\t\t\t<xsd:element ref=\"" + list3.get(n) + "\"/>");
            }
        }
        this.schreibeZeile("\t\t</xsd:all>");
        this.erstelleObjekttypen(list);
        this.schreibeZeile("\t</xsd:complexType>");
        this.schreibeZeile("</xsd:element>");
        this.schreibeZeile("");
    }

    public void erstelleDokumentEnde() {
        this.schreibeZeile("");
        this.schreibeZeile("<xsd:element name=\"objektliste\">");
        this.schreibeZeile("\t<xsd:complexType>");
        this.schreibeZeile("\t\t<xsd:sequence>");
        this.schreibeZeile("\t\t\t<xsd:element ref=\"objekt\" maxOccurs=\"unbounded\" minOccurs=\"1\"/>");
        this.schreibeZeile("\t\t</xsd:sequence>");
        this.schreibeZeile("\t</xsd:complexType>");
        this.schreibeZeile("</xsd:element>");
        this.schreibeZeile("");
        this.schreibeZeile("</xsd:schema>");
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            this.logging.error(iOException);
        }
    }
}

