/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.xmlschema;

import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datenbank.xmlschema.XMLSchemaGenerator;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

public final class XmlSchemaService {
    private static final String DATENTYP_STRING = "string";
    private static final String DATENTYP_DOUBLE = "double";
    private final ILogging logging = LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
    private final XMLSchemaGenerator generator;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final IKategorienRepository kategorienRepository;

    public XmlSchemaService(IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository, IKategorienRepository iKategorienRepository, KonfigurationDTO konfigurationDTO) {
        this.generator = new XMLSchemaGenerator(this.logging, konfigurationDTO);
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.kategorienRepository = iKategorienRepository;
    }

    public boolean generiereXMLSchema() {
        System.out.println("Das XML-Schema wird jetzt generiert. Dies kann einige Sekunden dauern...\nPlease wait while creating a new XML schema. This takes some seconds...\n");
        File file = new File(new File("").getAbsolutePath() + "/database" + File.separator + "planetensuche_schema.xsd");
        try {
            if (file.exists() && !file.renameTo(new File(file.getAbsolutePath() + ".bak"))) {
                this.logging.warn("Fehler beim Umbenennen der alten XML-Schema-Datei");
            }
            this.generator.erstelleHeader(file);
            this.erstelleElementEntfernung();
            this.erstelleElementDurchmesser();
            this.erstelleElementMasse();
            this.generator.erstelleUmlaufszeit();
            this.generator.erstelleElement("exzentritaet", DATENTYP_DOUBLE);
            this.generator.erstelleElement("albedo", DATENTYP_DOUBLE);
            this.generator.erstelleElement("temperatur", DATENTYP_DOUBLE);
            this.generator.erstelleElement("geschwindigkeit", DATENTYP_DOUBLE);
            this.generator.erstelleElement("entdeckungsdatum", DATENTYP_STRING);
            this.generator.erstelleElement("entdecker", DATENTYP_STRING);
            this.generator.erstelleElement("entdeckungBestaetigt", "boolean");
            this.generator.erstelleElement("ra", DATENTYP_DOUBLE);
            this.generator.erstelleElement("decl", DATENTYP_DOUBLE);
            this.generator.erstelleElement("sh", DATENTYP_DOUBLE);
            this.generator.erstelleElement("flaechenhelligkeit", DATENTYP_DOUBLE);
            this.generator.erstelleElement("ah", DATENTYP_DOUBLE);
            this.generator.erstelleElement("B-V", DATENTYP_DOUBLE);
            this.generator.erstelleElement("metallizitaet", DATENTYP_DOUBLE);
            this.generator.erstelleElement("sternentstehung", DATENTYP_DOUBLE);
            this.generator.erstelleElement("rotverschiebung", DATENTYP_DOUBLE);
            this.generator.erstelleElement("alter", DATENTYP_DOUBLE);
            this.generator.erstelleElement("referenz", DATENTYP_STRING);
            this.generator.erstelleElement("name", DATENTYP_STRING);
            this.generator.erstelleElement("bilder", DATENTYP_STRING);
            this.generator.erstelleElement("notiz", DATENTYP_STRING);
            this.generator.erstelleElement("autor", DATENTYP_STRING);
            this.generator.erstelleElement("timestamp", DATENTYP_STRING);
            this.generator.erstelleElement("ruwe", DATENTYP_DOUBLE);
            this.generator.erstelleElement("astro_ex_noise_sig", DATENTYP_DOUBLE);
            this.generator.erstelleElement("rv_error", DATENTYP_DOUBLE);
            this.generator.erstelleElement("gaia_non_single", DATENTYP_STRING);
            List<String> list = this.entdeckungsmethodenRepository.getEntdeckungsmethoden();
            this.generator.erstelleEinheitenMitEinemAttribut("entdeckungsmethode", "methode", list);
            IDatenbankService iDatenbankService = BeanFactory.getInstance();
            list = iDatenbankService.getSternbilderNamen(SternbildSprache.LATEINISCH);
            this.generator.erstelleEinheitenMitEinemAttribut("sternbild", "bezeichnung", list);
            List<String> list2 = iDatenbankService.getSpektraltypen(ObjektKategorie.STERNE.getKategorienName());
            list2.remove("unbekannt");
            list2.addAll(iDatenbankService.getSpektraltypen(ObjektKategorie.BR_ZWERGE.getKategorienName()));
            List<Double> list3 = iDatenbankService.getSpektraltypen2(true);
            this.generator.erstelleSpektraltypSterneBrZwerge(list2, list3);
            list = iDatenbankService.getLeuchtkraftklassen();
            this.generator.erstelleEinheitenMitEinemAttribut("leuchtkraftklasse", "klasse", list);
            list = iDatenbankService.getSpektraltypen(ObjektKategorie.ASTEROIDEN.getKategorienName());
            this.generator.erstelleEinheitenMitEinemAttribut("spektraltyp_asteroiden", "typ", list);
            list = iDatenbankService.getSternhaufenformen("");
            list.remove("unbekannt");
            this.generator.erstelleEinheitenMitEinemAttribut("sternhaufenform", "form", list);
            list = iDatenbankService.getNebelformen("");
            this.generator.erstelleEinheitenMitEinemAttribut("nebelform", "form", list);
            list = iDatenbankService.getGalaxienarten();
            this.generator.erstelleEinheitenMitEinemAttribut("galaxienart", "art", list);
            list = iDatenbankService.getGalaxienformen();
            this.generator.erstelleEinheitenMitEinemAttribut("galaxienform", "form", list);
            list = new ArrayList<String>(8);
            list.add("umlaufszeit");
            list.add("exzentritaet");
            list.add("albedo");
            list.add("sh");
            list.add("temperatur");
            list.add("geschwindigkeit");
            list.add("entdeckungsdatum");
            list.add("entdeckungsmethode");
            list.add("entdeckungBestaetigt");
            List<String> list4 = iDatenbankService.getObjekttypen(ObjektKategorie.PLANETEN.getKategorienName());
            this.generator.erstelleKategorie("planeten", list4, list, null);
            list = new ArrayList<String>(7);
            list.add("umlaufszeit");
            list.add("exzentritaet");
            list.add("albedo");
            list.add("sh");
            list.add("temperatur");
            list.add("geschwindigkeit");
            list.add("entdeckungsdatum");
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.MONDE.getKategorienName());
            this.generator.erstelleKategorie("monde", list4, list, null);
            list = new ArrayList<String>(7);
            list.add("umlaufszeit");
            list.add("exzentritaet");
            list.add("albedo");
            list.add("sh");
            list.add("temperatur");
            list.add("geschwindigkeit");
            list.add("entdeckungsdatum");
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add("spektraltyp_asteroiden");
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.ASTEROIDEN.getKategorienName());
            this.generator.erstelleKategorie("asteroiden", list4, list, arrayList);
            list = new ArrayList<String>(7);
            list.add("umlaufszeit");
            list.add("exzentritaet");
            list.add("albedo");
            list.add("sh");
            list.add("temperatur");
            list.add("geschwindigkeit");
            list.add("entdeckungsdatum");
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.KOMETEN.getKategorienName());
            this.generator.erstelleKategorie("kometen", list4, list, null);
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.METEOR.getKategorienName());
            this.generator.erstelleKategorie("meteoriten_und_krater", list4, null, null);
            list = new ArrayList<String>(11);
            list.add("ra");
            list.add("decl");
            list.add("umlaufszeit");
            list.add("exzentritaet");
            list.add("albedo");
            list.add("sh");
            list.add("temperatur");
            list.add("geschwindigkeit");
            list.add("alter");
            list.add("entdeckungsdatum");
            list.add("entdeckungsmethode");
            list.add("entdeckungBestaetigt");
            arrayList = new ArrayList(2);
            arrayList.add("sternbild");
            arrayList.add("spektraltyp_sterne_brzwerge");
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.BR_ZWERGE.getKategorienName());
            this.generator.erstelleKategorie("braune_zwerge", list4, list, arrayList);
            list = new ArrayList<String>(9);
            list.add("ra");
            list.add("decl");
            list.add("ah");
            list.add("sh");
            list.add("temperatur");
            list.add("geschwindigkeit");
            list.add("metallizitaet");
            list.add("B-V");
            list.add("alter");
            list.add("ruwe");
            list.add("astro_ex_noise_sig");
            list.add("rv_error");
            list.add("gaia_non_single");
            arrayList = new ArrayList(3);
            arrayList.add("sternbild");
            arrayList.add("spektraltyp_sterne_brzwerge");
            arrayList.add("leuchtkraftklasse");
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.STERNE.getKategorienName());
            this.generator.erstelleKategorie("sterne", list4, list, arrayList);
            list = new ArrayList<String>(10);
            list.add("ra");
            list.add("decl");
            list.add("sh");
            list.add("ah");
            list.add("flaechenhelligkeit");
            list.add("metallizitaet");
            list.add("B-V");
            list.add("geschwindigkeit");
            list.add("alter");
            list.add("entdeckungsdatum");
            arrayList = new ArrayList(2);
            arrayList.add("sternbild");
            arrayList.add("sternhaufenform");
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.STERNHAUFEN.getKategorienName());
            this.generator.erstelleKategorie("sternhaufen", list4, list, arrayList);
            list = new ArrayList<String>(15);
            list.add("nebelform");
            list.add("galaxienart");
            list.add("galaxienform");
            list.add("ra");
            list.add("decl");
            list.add("sh");
            list.add("ah");
            list.add("flaechenhelligkeit");
            list.add("metallizitaet");
            list.add("B-V");
            list.add("geschwindigkeit");
            list.add("alter");
            list.add("sternentstehung");
            list.add("rotverschiebung");
            list.add("entdeckungsdatum");
            arrayList = new ArrayList(1);
            arrayList.add("sternbild");
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.GALAXIE_NEBEL.getKategorienName());
            this.generator.erstelleKategorie("galaxien_und_nebel", list4, list, arrayList);
            list = new ArrayList<String>(6);
            list.add("ra");
            list.add("decl");
            list.add("sh");
            list.add("flaechenhelligkeit");
            list.add("rotverschiebung");
            list.add("entdeckungsdatum");
            arrayList = new ArrayList(1);
            arrayList.add("sternbild");
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.GALAXIENHAUFEN.getKategorienName());
            this.generator.erstelleKategorie("galaxienhaufen", list4, list, arrayList);
            list = new ArrayList<String>(6);
            list.add("ra");
            list.add("decl");
            list.add("sh");
            list.add("flaechenhelligkeit");
            list.add("entdeckungsdatum");
            list.add("sternbild");
            list4 = iDatenbankService.getObjekttypen(ObjektKategorie.SONSTIGES.getKategorienName());
            this.generator.erstelleKategorie("sonstiges", list4, list, null);
            List<String> list5 = this.kategorienRepository.getKategorien();
            this.generator.erstelleElementObjekt(list5);
            this.generator.erstelleDokumentEnde();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(file);
            schemaFactory.newSchema(streamSource);
            System.out.println("XML-Schema erfolgreich erstellt...\nXML schema successfuly created...");
            return true;
        }
        catch (Exception exception) {
            this.logging.error(exception);
            System.out.println("Erstellen des XML-Schemas wegen Fehler abgebrochen:");
            System.out.println("Creating of XML schema aborted because this error occurs:");
            return false;
        }
    }

    private void erstelleElementMasse() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("Kg");
        arrayList.add("Jupitermassen");
        arrayList.add("Sonnenmassen");
        this.generator.erstelleEinheiten("masse", arrayList);
    }

    private void erstelleElementDurchmesser() {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        arrayList.add("Km");
        arrayList.add("Jupiterdurchmesser");
        arrayList.add("Sonnendurchmesser");
        arrayList.add("'");
        arrayList.add("Ly");
        this.generator.erstelleEinheiten("durchmesser", arrayList);
    }

    private void erstelleElementEntfernung() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add("Km");
        arrayList.add("AE");
        arrayList.add("Ly");
        arrayList.add("Pc");
        this.generator.erstelleEinheiten("entfernung", arrayList);
    }
}

