/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.api.repos;

public enum EntdeckerTyp {
    PERSON(0),
    PROJECT(1),
    SPACE_TELESCOPE(2);

    private final Integer type;

    private EntdeckerTyp(Integer n2) {
        this.type = n2;
    }

    public Integer getType() {
        return this.type;
    }

    public static EntdeckerTyp valueOf(Integer n) {
        if (n == null) {
            return PERSON;
        }
        for (EntdeckerTyp entdeckerTyp : EntdeckerTyp.values()) {
            if (!n.equals(entdeckerTyp.type)) continue;
            return entdeckerTyp;
        }
        throw new IllegalArgumentException("unbekannter EntdeckerTyp '" + n + "'");
    }

    public TeleskopTyp getTeleskopTyp() {
        if (this == SPACE_TELESCOPE) {
            return TeleskopTyp.SPACE;
        }
        return TeleskopTyp.GROUND;
    }

    public static enum TeleskopTyp {
        GROUND,
        SPACE;

    }
}

