/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ISternbild;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankfassadeBasis;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.ISternkartenBasisDao;
import de.planetensuche.datenbankkern.api.cache.ISternbildSpracheCache;
import de.planetensuche.datenbankkern.api.kategorien.IGalaxienUndNebelRepository;
import de.planetensuche.datenbankkern.api.kategorien.IPlanetenRepository;
import de.planetensuche.datenbankkern.api.kategorien.ISterneRepository;
import de.planetensuche.datenbankkern.api.kategorien.ISternhaufenRepository;
import de.planetensuche.datenbankkern.api.repos.IAutorRepository;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.datenbankkern.helfer.DatenbankQuery;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.DatenbankSchemaGenerator;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.Sternbilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public final class Datenbankfassade
extends DatenbankQuery
implements IDatenbankService,
PlanetensucheObjektPrueferDAO,
ISternkartenBasisDao,
IDatenbankfassadeBasis {
    private List<String> objekttypenAlle;
    private final IDatenbankverbinder datenbankverbinder;
    private final ISternbildSpracheCache sternbildSpracheCache;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final IKategorienRepository kategorienRepository;
    private final ISternbilderRepository sternbilderRepository;
    private final ISterneRepository sterneRepository;
    private final IGalaxienUndNebelRepository galaxienUndNebelRepository;
    private final IPlanetenRepository planetenRepository;
    private final ISternhaufenRepository sternhaufenRepository;
    private final IAutorRepository autorRepository;

    @Inject
    public Datenbankfassade(IDatenbankverbinder iDatenbankverbinder, ISternbildSpracheCache iSternbildSpracheCache, IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository, IObjektnamenRepository iObjektnamenRepository, IKategorienRepository iKategorienRepository, ISternbilderRepository iSternbilderRepository, ISterneRepository iSterneRepository, IGalaxienUndNebelRepository iGalaxienUndNebelRepository, IPlanetenRepository iPlanetenRepository, ISternhaufenRepository iSternhaufenRepository, IAutorRepository iAutorRepository) throws ClassNotFoundException, SQLException {
        super(iDatenbankverbinder);
        this.datenbankverbinder = iDatenbankverbinder;
        this.sternbildSpracheCache = iSternbildSpracheCache;
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.kategorienRepository = iKategorienRepository;
        this.sternbilderRepository = iSternbilderRepository;
        this.sterneRepository = iSterneRepository;
        this.galaxienUndNebelRepository = iGalaxienUndNebelRepository;
        this.planetenRepository = iPlanetenRepository;
        this.sternhaufenRepository = iSternhaufenRepository;
        this.autorRepository = iAutorRepository;
    }

    @Override
    public List<String> getObjekttypen(String string) throws SQLException {
        try {
            if (string.isEmpty()) {
                if (this.objekttypenAlle == null) {
                    String string2 = "SELECT OT.typ FROM objekttypen AS OT ORDER BY OT.typ;";
                    this.objekttypenAlle = this.getListeMitStrings(string2, "typ");
                }
                return Collections.unmodifiableList(this.objekttypenAlle);
            }
            String string3 = "SELECT OT.typ FROM objekttypen AS OT, kategorie AS K WHERE OT.kategorieid=K.id AND K.id=(SELECT id FROM kategorie WHERE Name='" + string + "') ORDER BY OT.typ;";
            return this.getListeMitStrings(string3, "typ");
        }
        catch (SQLException sQLException) {
            throw new SQLException("Fehler in getObjekttypen(" + string + ")", sQLException);
        }
    }

    @Override
    public boolean dropAllTables() throws SQLException {
        DatenbankSchemaGenerator datenbankSchemaGenerator = new DatenbankSchemaGenerator(this.datenbankverbinder);
        datenbankSchemaGenerator.entferneAlleTabellen();
        return true;
    }

    @Override
    public boolean createAllTables() throws SQLException {
        DatenbankSchemaGenerator datenbankSchemaGenerator = new DatenbankSchemaGenerator(this.datenbankverbinder);
        datenbankSchemaGenerator.erstelleAlleTabellen();
        datenbankSchemaGenerator.erstelleIndexes();
        return true;
    }

    @Override
    public List<String> getEntdeckungsmethoden() throws SQLException {
        return this.entdeckungsmethodenRepository.getEntdeckungsmethoden();
    }

    @Override
    public int isObjektInDatenbank(List<String> list) throws SQLException {
        int n = 0;
        for (String string : list) {
            if (this.objektnamenRepository.readDatenid(string) == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean isObjectInDB(Integer n) throws SQLException {
        QDaten qDaten = QDaten.daten;
        Daten daten = (Daten)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.id.eq(n))).fetchOne();
        return daten != null;
    }

    @Override
    public List<String> getKategorien() throws SQLException {
        return this.kategorienRepository.getKategorien();
    }

    @Override
    public List<Integer> getAllDatenids() throws SQLException {
        QDaten qDaten = QDaten.daten;
        List<Integer> list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).fetch();
        return list;
    }

    @Override
    public String getSternbildLateinisch(String string) throws SQLException {
        return this.sternbilderRepository.getSternbildLateinisch(string);
    }

    @Override
    public void setSternbildsprache(SternbildSprache sternbildSprache) {
        this.sternbildSpracheCache.setSternbildSprache(sternbildSprache);
    }

    @Override
    public List<String> getSpektraltypen(String string) throws SQLException {
        return this.sterneRepository.getSpektraltypen(string);
    }

    @Override
    public List<Double> getSpektraltypen2(boolean bl) throws SQLException {
        return this.sterneRepository.getSpektraltypen2(bl);
    }

    @Override
    public List<String> getLeuchtkraftklassen() throws SQLException {
        return this.sterneRepository.getLeuchtkraftklassen();
    }

    @Override
    public Integer getIDFuerSpektraltyp(String string, String string2) throws SQLException {
        return this.sterneRepository.getIDFuerSpektraltyp(string, string2);
    }

    @Override
    public Integer getIDFuerSpektraltyp2(double d) throws SQLException {
        return this.sterneRepository.getIDFuerSpektraltyp2(d);
    }

    @Override
    public Integer getIDFuerLeuchtkraftklasse(String string) throws SQLException {
        return this.sterneRepository.getIDFuerLeuchtkraftklasse(string);
    }

    @Override
    public List<Integer> getObjekttypenidsPlaneten() throws SQLException {
        return this.planetenRepository.getObjekttypenidsPlaneten();
    }

    @Override
    public List<String> getSternbilderNamen(SternbildSprache sternbildSprache) throws SQLException {
        return this.sternbilderRepository.getSternbilderNamen(sternbildSprache);
    }

    @Override
    public String getSternbildGenitiv(String string) throws SQLException {
        return this.sternbilderRepository.getSternbildGenitiv(string);
    }

    @Override
    public List<String> getGalaxienformen() throws SQLException {
        return this.galaxienUndNebelRepository.getGalaxienformen();
    }

    @Override
    public List<String> getNebelformen(String string) throws SQLException {
        return this.galaxienUndNebelRepository.getNebelformen(string);
    }

    @Override
    public List<String> getGalaxienarten() throws SQLException {
        return this.galaxienUndNebelRepository.getGalaxienarten();
    }

    @Override
    public List<String> getSternhaufenformen(String string) throws SQLException {
        return this.sternhaufenRepository.getSternhaufenformen(string);
    }

    @Override
    public SternbildSprache getSternbildsprache() {
        return this.sternbildSpracheCache.getSternbildSprache();
    }

    @Override
    public boolean getAllDataSternbild(ISternbild iSternbild, String string) throws SQLException {
        ISternbild iSternbild2 = this.sternbilderRepository.getSternbild(string);
        iSternbild.setBilder(iSternbild2.getBilder());
        iSternbild.setObjekteImSternbild(iSternbild2.getObjekteImSternbild());
        iSternbild.setSternbildBisDECL(iSternbild2.getSternbildBisDECL());
        iSternbild.setSternbildBisRA(iSternbild2.getSternbildBisRA());
        iSternbild.setSternbildCode(iSternbild2.getSternbildCode());
        iSternbild.setSternbildDTBezeichnung(iSternbild2.getSternbildDTBezeichnung());
        iSternbild.setSternbildENGBezeichnung(iSternbild2.getSternbildENGBezeichnung());
        iSternbild.setSternbildGenitiv(iSternbild2.getSternbildGenitiv());
        iSternbild.setSternbildLATBezeichnung(iSternbild2.getSternbildLATBezeichnung());
        iSternbild.setSternbildVonDECL(iSternbild2.getSternbildVonDECL());
        iSternbild.setSternbildVonRA(iSternbild2.getSternbildVonRA());
        return true;
    }

    @Override
    public List<String> getAutoren() throws SQLException {
        return this.autorRepository.getAutoren();
    }

    @Override
    public List<Integer> getDatenIdsFuerAutor(String string) throws SQLException {
        return this.autorRepository.getDatenIdsFuerAutor(string);
    }

    @Override
    public boolean getSternbildDatenMinimal(ISternbild iSternbild, String string) throws SQLException {
        Integer n = this.sternbilderRepository.getIdVonNamen(string);
        if (n == null) {
            return false;
        }
        Sternbilder sternbilder = this.sternbilderRepository.read(n);
        iSternbild.setObjekteImSternbild(new ArrayList<String>());
        iSternbild.setBilder(new ArrayList<String>());
        iSternbild.setSternbildBisDECL(sternbilder.getBisdecl());
        iSternbild.setSternbildBisRA(sternbilder.getBisra());
        iSternbild.setSternbildCode(sternbilder.getLatabk());
        iSternbild.setSternbildDTBezeichnung(sternbilder.getDtbezeichnung());
        iSternbild.setSternbildENGBezeichnung(sternbilder.getEngbezeichnung());
        iSternbild.setSternbildGenitiv(sternbilder.getLatgenitiv());
        iSternbild.setSternbildLATBezeichnung(sternbilder.getLatbezeichnung());
        iSternbild.setSternbildVonDECL(sternbilder.getVondecl());
        iSternbild.setSternbildVonRA(sternbilder.getVonra());
        return true;
    }
}

