/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl;

import com.google.inject.Inject;
import com.querydsl.core.QueryException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.DatabaseUpdaterComparator;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Dbversion;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QDbversion;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LogLevel;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Datenbankmigrator {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Datenbankmigrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final QDbversion qDbversion = QDbversion.dbversion1;
    private final List<DatabaseUpdater> migratorStrategies;

    @Inject
    public Datenbankmigrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.migratorStrategies = new ArrayList<DatabaseUpdater>();
        try {
            for (int i = 2; i < 1000; ++i) {
                Class<?> clazz = Class.forName("de.planetensuche.datenbankkern.impl.migration.Version" + i + "Migrator");
                Object obj = clazz.getDeclaredConstructor(IDatenbankverbinder.class).newInstance(this.datenbankverbinder);
                this.migratorStrategies.add((DatabaseUpdater)obj);
            }
            throw new IllegalStateException("mehr DB-Migrations-Klassen als Schleifendurchl\u00e4ufe!");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            LOGGER.error("", exception);
        }
        if (this.migratorStrategies.size() < 25) {
            throw new IllegalStateException("erwartete DB-Migrations-Klassen nicht im Klassenpfad gefunden");
        }
    }

    public void migriere() throws SQLException {
        int n = this.getDatenbankVersion();
        LOGGER.info("Datenbank Schema Version vor Migration: " + n);
        if (this.isDatabaseEmpty()) {
            LoggingFactory.getLoggerForClass(MigrationHelper.class).setLevel(LogLevel.OFF);
        }
        Collections.sort(this.migratorStrategies, new DatabaseUpdaterComparator());
        for (DatabaseUpdater databaseUpdater : this.migratorStrategies) {
            if (databaseUpdater.updateToVersion() <= n) continue;
            try {
                databaseUpdater.update();
                n = databaseUpdater.updateToVersion();
                this.erhoeheDatenbankVersion(n);
            }
            catch (Exception exception) {
                throw new SQLException("exception while migrating to DB version " + databaseUpdater.updateToVersion(), exception);
            }
        }
        LOGGER.info("Datenbank Schema Version nach Migration: " + n);
    }

    public int getDatenbankVersion() throws SQLException {
        int n;
        try {
            Dbversion dbversion = (Dbversion)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDbversion).fetchOne();
            if (dbversion == null) {
                ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qDbversion).set((Path)this.qDbversion.dbversion, (Object)2)).execute();
                n = 2;
            } else {
                n = dbversion.getDbversion();
            }
        }
        catch (QueryException queryException) {
            this.datenbankverbinder.query("CREATE TABLE dbversion (id IDENTITY, dbversion INTEGER);");
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qDbversion).set((Path)this.qDbversion.dbversion, (Object)1)).execute();
            n = 1;
        }
        return n;
    }

    private void erhoeheDatenbankVersion(int n) throws SQLException {
        ((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qDbversion).set((Path)this.qDbversion.dbversion, (Object)n)).execute();
    }

    private boolean isDatabaseEmpty() {
        QDaten qDaten = QDaten.daten;
        return ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.count()).from((Expression<?>)qDaten)).fetchCount() < 100L;
    }
}

