/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl;

import com.querydsl.sql.Configuration;
import com.querydsl.sql.HSQLDBTemplates;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

public final class Datenbankverbinder
implements IDatenbankverbinder {
    private final ILogging logger;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private String datenbankNameUndPfad;
    private boolean inFileDb;
    private DataSource connectionPool;
    private Connection connectionForNativeQueries;
    private SQLQueryFactory queryFactory;

    public Datenbankverbinder() {
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
    }

    @Override
    public SQLUpdateClause getNewSqlUpdateClause(RelationalPath<?> relationalPath) throws SQLException {
        return this.queryFactory.update(relationalPath);
    }

    @Override
    public SQLInsertClause getNewSqlInsertClause(RelationalPath<?> relationalPath) throws SQLException {
        return this.queryFactory.insert(relationalPath);
    }

    @Override
    public SQLDeleteClause getNewSqlDeleteClause(RelationalPath<?> relationalPath) throws SQLException {
        return this.queryFactory.delete(relationalPath);
    }

    @Override
    public synchronized void open(boolean bl, String string) throws ClassNotFoundException, SQLException {
        if (string == null) {
            throw new IllegalArgumentException("dbNameUndPfad ist null!");
        }
        this.datenbankNameUndPfad = string;
        this.inFileDb = bl;
        this.shutdown.set(false);
        this.logger.debug("DB Verbindung herstellen zu '" + this.datenbankNameUndPfad + "'");
        this.createConnectionPool();
        HSQLDBTemplates hSQLDBTemplates = new HSQLDBTemplates();
        Configuration configuration = new Configuration(hSQLDBTemplates);
        this.queryFactory = new SQLQueryFactory(configuration, this.connectionPool);
        this.connectionForNativeQueries = this.createNativeConnection();
        this.setOptimierungenFuerAlleVerbindungen();
        this.logger.trace("DB Einstellung beendet");
        this.logger.debug("DB startup beendet");
    }

    private void createConnectionPool() {
        this.logger.trace("oeffne 10 Verbindungen zur DB...");
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName("org.hsqldb.jdbc.JDBCDriver");
        basicDataSource.setUsername("sa");
        if (this.inFileDb) {
            basicDataSource.setUrl("jdbc:hsqldb:file:" + this.datenbankNameUndPfad);
            this.logger.debug("use file mode for hsqldb");
        } else {
            basicDataSource.setUrl("jdbc:hsqldb:mem:" + this.datenbankNameUndPfad);
        }
        basicDataSource.setMaxTotal(10);
        basicDataSource.setInitialSize(4);
        basicDataSource.setAccessToUnderlyingConnectionAllowed(false);
        basicDataSource.setTestOnBorrow(true);
        basicDataSource.setAutoCommitOnReturn(true);
        this.connectionPool = basicDataSource;
        this.logger.trace("connection pooler bereit");
    }

    private Connection createNativeConnection() throws ClassNotFoundException, SQLException {
        Connection connection = this.inFileDb ? DriverManager.getConnection("jdbc:hsqldb:file:" + this.datenbankNameUndPfad, "sa", "") : DriverManager.getConnection("jdbc:hsqldb:mem:" + this.datenbankNameUndPfad, "sa", "");
        if (!connection.isValid(1)) {
            throw new IllegalStateException("could not create native connection! file-db? " + this.inFileDb);
        }
        connection.setReadOnly(false);
        connection.setAutoCommit(true);
        return connection;
    }

    @Override
    public SQLQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    private void setOptimierungenFuerAlleVerbindungen() throws SQLException {
        this.query("SET FILES LOG FALSE");
        this.query("SET DATABASE EVENT LOG LEVEL 0");
        this.query("SET DATABASE EVENT LOG SQL LEVEL 0");
        this.query("SET FILES WRITE DELAY FALSE");
        this.query("SET DATABASE DEFAULT ISOLATION LEVEL READ COMMITTED");
        this.query("SET FILES CACHE SIZE 800000");
        this.query("SET FILES CACHE ROWS 1200000");
        this.query("SET DATABASE SQL TDC DELETE TRUE");
        this.query("SET DATABASE TRANSACTION CONTROL LOCKS");
        this.query("SET FILES NIO TRUE");
    }

    @Override
    public void logExecutionPlan(String string) {
        try {
            Connection connection = this.getOpenConnection();
            try (Statement statement = connection.createStatement();){
                Object object = string;
                if (!((String)object).startsWith("EXPLAIN PLAN FOR ")) {
                    object = "EXPLAIN PLAN FOR " + (String)object;
                }
                ResultSet resultSet = statement.executeQuery((String)object);
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    this.logger.info(string2);
                    System.out.println(string2);
                }
            }
        }
        catch (SQLException sQLException) {
            this.logger.error("Fehler beim Ausf\u00fchren des Ausf\u00fchrungsplans f\u00fcr Query '" + string + "'", sQLException);
        }
    }

    @Override
    public synchronized void query(String string) throws SQLException {
        Connection connection;
        if (this.shutdown.get()) {
            throw new SQLWarning("Datenbank wird heruntergefahren, Statement wird ignoriert: '" + string + "'");
        }
        Object object = string;
        if (!((String)object).endsWith(";")) {
            object = (String)object + ";";
        }
        if ((connection = this.getOpenConnection()).isClosed()) {
            throw new IllegalStateException("native connection is closed");
        }
        try (Statement statement = connection.createStatement();){
            statement.execute((String)object);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.connectionPool == null) {
            return;
        }
        this.logger.debug("Datenbank wird heruntergefahren...");
        this.shutdown.set(true);
        try {
            this.wait(600L);
        }
        catch (InterruptedException interruptedException) {
            this.logger.debug("shutdown()", interruptedException);
        }
        Connection connection = this.getOpenConnection();
        try (Statement statement = connection.createStatement();){
            statement.execute("SHUTDOWN;");
        }
        ((BasicDataSource)this.connectionPool).close();
        this.connectionForNativeQueries.commit();
        this.connectionForNativeQueries.close();
    }

    @Override
    public Connection getOpenConnection() {
        if (this.connectionForNativeQueries == null) {
            throw new IllegalArgumentException("connection is closed");
        }
        return this.connectionForNativeQueries;
    }
}

