/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl;

import com.google.common.io.Files;
import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.IStandarddatenImporter;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;

public final class StandarddatenImporter
implements IStandarddatenImporter {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public StandarddatenImporter(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void importiereInitialDaten() throws IOException {
        String string = new File("").getAbsolutePath();
        File file = new File(string + "/../Datenbankkern/dbmain.sql");
        if (!file.exists()) {
            file = new File(string + "/database/dbmain.sql");
        }
        if (!file.exists()) {
            this.logger.fatal(file.getAbsolutePath() + " nicht gefunden!");
            return;
        }
        this.logger.debug("found inital data in file " + file.getAbsolutePath());
        List<String> list = Files.readLines(file, Charset.forName("UTF-8"));
        int n = 0;
        int n2 = 0;
        for (String string2 : list) {
            String string3 = string2;
            if (!string3.startsWith("INSERT INTO ")) continue;
            try {
                this.datenbankverbinder.query(string3);
                ++n;
            }
            catch (SQLException sQLException) {
                this.logger.error(string3, sQLException);
                ++n2;
            }
        }
        this.logger.debug("finish inital data import with " + n + " success and " + n2 + " failed rows");
    }
}

