/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.cache;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class IdCacheDAO
implements IIdCacheDAO {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private List<Integer> objekttypenidsAsteroiden;
    private List<Integer> objekttypenidsMonde;
    private List<Integer> objekttypenidsSterne;
    private List<Integer> objekttypenidsSternhaufen;
    private List<Integer> objekttypenidsGalaxienundnebel;
    private List<Integer> objekttypenidsGalaxienhaufen;
    private List<Integer> objekttypenidsSonstiges;
    private List<Integer> objekttypenidsKometen;
    private List<Integer> objekttypenidsBraunezwerge;
    private List<Integer> objekttypenidsPlaneten;
    private int datenidSonne = -1;
    private final IObjektnamenRepository objektnamenRepository;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public IdCacheDAO(IObjektnamenRepository iObjektnamenRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.objektnamenRepository = iObjektnamenRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public List<Integer> getObjekttypenidsAsteroiden() {
        this.objekttypenidsAsteroiden = this.getObjekttypenIds(ObjektKategorie.ASTEROIDEN, this.objekttypenidsAsteroiden);
        return this.objekttypenidsAsteroiden;
    }

    @Override
    public List<Integer> getObjekttypenidsBraunezwerge() {
        this.objekttypenidsBraunezwerge = this.getObjekttypenIds(ObjektKategorie.BR_ZWERGE, this.objekttypenidsBraunezwerge);
        return this.objekttypenidsBraunezwerge;
    }

    @Override
    public List<Integer> getObjekttypenidsGalaxienundnebel() {
        this.objekttypenidsGalaxienundnebel = this.getObjekttypenIds(ObjektKategorie.GALAXIE_NEBEL, this.objekttypenidsGalaxienundnebel);
        return this.objekttypenidsGalaxienundnebel;
    }

    @Override
    public List<Integer> getObjekttypenidsKometen() {
        this.objekttypenidsKometen = this.getObjekttypenIds(ObjektKategorie.KOMETEN, this.objekttypenidsKometen);
        return this.objekttypenidsKometen;
    }

    @Override
    public List<Integer> getObjekttypenidsMonde() {
        this.objekttypenidsMonde = this.getObjekttypenIds(ObjektKategorie.MONDE, this.objekttypenidsMonde);
        return this.objekttypenidsMonde;
    }

    @Override
    public List<Integer> getObjekttypenidsSterne() {
        this.objekttypenidsSterne = this.getObjekttypenIds(ObjektKategorie.STERNE, this.objekttypenidsSterne);
        return this.objekttypenidsSterne;
    }

    @Override
    public List<Integer> getObjekttypenidsSternhaufen() {
        this.objekttypenidsSternhaufen = this.getObjekttypenIds(ObjektKategorie.STERNHAUFEN, this.objekttypenidsSternhaufen);
        return this.objekttypenidsSternhaufen;
    }

    @Override
    public List<Integer> getObjekttypenidsPlaneten() {
        this.objekttypenidsPlaneten = this.getObjekttypenIds(ObjektKategorie.PLANETEN, this.objekttypenidsPlaneten);
        return this.objekttypenidsPlaneten;
    }

    private List<Integer> getObjekttypenIds(ObjektKategorie objektKategorie, List<Integer> list) {
        if (list != null && !list.isEmpty()) {
            return list;
        }
        List<Integer> list2 = Collections.emptyList();
        try {
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            QKategorie qKategorie = QKategorie.kategorie;
            List list3 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(objektKategorie.getKategorienName()))))).fetch();
            list2 = Collections.unmodifiableList(list3);
        }
        catch (Exception exception) {
            this.logger.error(exception);
        }
        return list2;
    }

    @Override
    public int getDatenIdSonne() throws SQLException {
        Integer n;
        if (this.datenidSonne == -1 && (n = this.objektnamenRepository.getIDFuerNamen("Sonne", true)) != null) {
            this.datenidSonne = n;
        }
        return this.datenidSonne;
    }

    @Override
    public List<Integer> getObjekttypenidsGalaxienhaufen() {
        this.objekttypenidsGalaxienhaufen = this.getObjekttypenIds(ObjektKategorie.GALAXIENHAUFEN, this.objekttypenidsGalaxienhaufen);
        return this.objekttypenidsGalaxienhaufen;
    }

    @Override
    public List<Integer> getObjekttypenidsSonstiges() {
        this.objekttypenidsSonstiges = this.getObjekttypenIds(ObjektKategorie.SONSTIGES, this.objekttypenidsSonstiges);
        return this.objekttypenidsSonstiges;
    }
}

