/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.kategorien.IGalaxienUndNebelRepository;
import de.planetensuche.datenbankkern.querydsl5.QGalaxienart;
import de.planetensuche.datenbankkern.querydsl5.QGalaxienform;
import de.planetensuche.datenbankkern.querydsl5.QNebelform;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import java.sql.SQLException;
import java.util.List;

public final class GalaxienUndNebelRepository
implements IGalaxienUndNebelRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final QGalaxienform qGalaxienform = QGalaxienform.galaxienform;
    private final QGalaxienart qGalaxienart = QGalaxienart.galaxienart;
    private final QNebelform qNebelform = QNebelform.nebelform;

    @Inject
    public GalaxienUndNebelRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public List<String> getGalaxienformen() throws SQLException {
        return ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qGalaxienform.form).from((Expression<?>)this.qGalaxienform)).fetch();
    }

    @Override
    public List<String> getGalaxienarten() throws SQLException {
        return ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qGalaxienart.art).from((Expression<?>)this.qGalaxienart)).fetch();
    }

    @Override
    public List<String> getNebelformen(String string) throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        if (string == null || "".equals(string)) {
            return ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNebelform.form).from((Expression<?>)this.qNebelform)).fetch();
        }
        List<String> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNebelform.form).from((Expression<?>)this.qNebelform)).where(this.qNebelform.oid.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(string))))).fetch();
        return list;
    }

    @Override
    public Integer getIDFuerGalaxienform(String string) throws SQLException {
        return (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qGalaxienform.id).from((Expression<?>)this.qGalaxienform)).where(this.qGalaxienform.form.eq(string))).fetchOne();
    }

    @Override
    public Integer getIDFuerGalaxienart(String string) throws SQLException {
        return (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qGalaxienart.id).from((Expression<?>)this.qGalaxienart)).where(this.qGalaxienart.art.eq(string))).fetchFirst();
    }

    @Override
    public Integer getIDFuerNebelform(String string) throws SQLException {
        return (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNebelform.id).from((Expression<?>)this.qNebelform)).where(this.qNebelform.form.eq(string))).fetchFirst();
    }
}

