/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.kategorien.ExoplanetOverviewDto;
import de.planetensuche.datenbankkern.api.kategorien.IPlanetenRepository;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;

public final class PlanetenRepository
implements IPlanetenRepository {
    private final ILogging logger;
    private final IDatenbankverbinder datenbankverbinder;
    private final QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
    private final QKategorie qKategorie = QKategorie.kategorie;
    private final IObjektnamenRepository objektnamenRepository;
    private final IIdCacheDAO idCache;

    @Inject
    public PlanetenRepository(IDatenbankverbinder iDatenbankverbinder, IObjektnamenRepository iObjektnamenRepository, IIdCacheDAO iIdCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.objektnamenRepository = iObjektnamenRepository;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.idCache = iIdCacheDAO;
    }

    @Override
    public List<Integer> getObjekttypenidsPlaneten() {
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.kategorieid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq("Planeten"))))).fetch();
    }

    @Override
    public List<ExoplanetOverviewDto> getExoplanetenProJahr(Integer n, boolean bl, Optional<String> optional) throws SQLException {
        ArrayList<ExoplanetOverviewDto> arrayList = new ArrayList<ExoplanetOverviewDto>();
        List<Integer> list = this.getObjekttypenidsPlaneten();
        QDaten qDaten = QDaten.daten;
        if (n == null) {
            List list2;
            Integer n2 = this.objektnamenRepository.readDatenid("Sonne");
            BooleanExpression booleanExpression = qDaten.entdeckungsdatum.eq("").or(qDaten.entdeckungsdatum.isEmpty()).or(qDaten.entdeckungsdatum.isNull()).and(qDaten.objektid.in((Collection<Integer>)list)).and(qDaten.zugehoerigkeit.ne(n2).or(qDaten.zugehoerigkeit.isNull()));
            if (bl) {
                booleanExpression = booleanExpression.and(qDaten.entdeckungbestaetigt.isTrue());
            }
            if (optional.isEmpty()) {
                list2 = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.entdeckungbestaetigt}).from((Expression<?>)qDaten)).where(booleanExpression)).orderBy((OrderSpecifier<?>)qDaten.id.asc())).fetch();
            } else {
                QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
                Object object = QEntdecker.entdecker;
                list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.entdeckungbestaetigt}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qZtentdecker.datenid.eq(qDaten.id))).leftJoin((EntityPath)object)).on((Predicate)((QEntdecker)object).id.eq(qZtentdecker.entdeckerid))).where(booleanExpression.and(((QEntdecker)object).nachname.eq(optional.get())))).orderBy((OrderSpecifier<?>)qDaten.id.asc())).fetch();
            }
            for (Object object : list2) {
                ExoplanetOverviewDto exoplanetOverviewDto = this.createOverviewDto((Tuple)object);
                arrayList.add(exoplanetOverviewDto);
            }
        } else {
            List list3;
            BooleanExpression booleanExpression = qDaten.entdeckungsjahr.eq(n).and(qDaten.objektid.in((Collection<Integer>)list));
            if (bl) {
                booleanExpression = booleanExpression.and(qDaten.entdeckungbestaetigt.isTrue());
            }
            if (optional.isEmpty()) {
                list3 = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.entdeckungbestaetigt, qDaten.entdeckungsdatum}).from((Expression<?>)qDaten)).where(booleanExpression)).orderBy((OrderSpecifier<?>)qDaten.entdeckungsdatum.asc())).fetch();
            } else {
                QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
                Object object = QEntdecker.entdecker;
                list3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.entdeckungbestaetigt, qDaten.entdeckungsdatum}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qZtentdecker.datenid.eq(qDaten.id))).leftJoin((EntityPath)object)).on((Predicate)((QEntdecker)object).id.eq(qZtentdecker.entdeckerid))).where(booleanExpression.and(((QEntdecker)object).nachname.eq(optional.get())))).orderBy((OrderSpecifier<?>)qDaten.entdeckungsdatum.asc())).fetch();
            }
            for (Object object : list3) {
                ExoplanetOverviewDto exoplanetOverviewDto = this.createOverviewDto((Tuple)object);
                arrayList.add(exoplanetOverviewDto);
            }
        }
        return arrayList;
    }

    private ExoplanetOverviewDto createOverviewDto(Tuple tuple) throws SQLException {
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QDaten qDaten = QDaten.daten;
        int n = tuple.get(qDaten.id);
        List<String> list = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.ALPHABETISCH);
        StringBuilder stringBuilder = new StringBuilder();
        for (String charSequence2 : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(charSequence2);
        }
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker).from((Expression<?>)qEntdecker)).join((EntityPath)qZtentdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qZtentdecker.datenid.eq(n))).fetch();
        StringBuilder stringBuilder2 = new StringBuilder();
        Object object = list2.iterator();
        while (object.hasNext()) {
            Entdecker entdecker = (Entdecker)object.next();
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("; ");
            }
            if (EntdeckerTyp.PERSON.getType().equals(entdecker.getTyp()) || entdecker.getTyp() == null) {
                stringBuilder2.append(entdecker.getVorname()).append(" ").append(entdecker.getNachname());
                continue;
            }
            stringBuilder2.append(entdecker.getNachname());
        }
        object = new ExoplanetOverviewDto();
        ((ExoplanetOverviewDto)object).setPlanetName(stringBuilder.toString());
        ((ExoplanetOverviewDto)object).setConfirmed(tuple.get(qDaten.entdeckungbestaetigt));
        ((ExoplanetOverviewDto)object).setDiscoveryDate(tuple.get(qDaten.entdeckungsdatum));
        ((ExoplanetOverviewDto)object).setDiscoverer(stringBuilder2.toString());
        return object;
    }

    @Override
    public List<ExoplanetOverviewDto> listUnconfirmed() throws SQLException {
        QDaten qDaten = QDaten.daten;
        ArrayList<ExoplanetOverviewDto> arrayList = new ArrayList<ExoplanetOverviewDto>();
        List<Integer> list = this.getObjekttypenidsPlaneten();
        Integer n = this.objektnamenRepository.readDatenid("Sonne");
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.entdeckungbestaetigt, qDaten.entdeckungsdatum}).from((Expression<?>)qDaten)).where(qDaten.entdeckungbestaetigt.isFalse().and(qDaten.objektid.in((Collection<Integer>)list)).and(qDaten.zugehoerigkeit.ne(n)))).orderBy((OrderSpecifier<?>)qDaten.id.asc())).fetch();
        for (Tuple tuple : list2) {
            int n2 = tuple.get(qDaten.id);
            String string = this.objektnamenRepository.getNamenByDatenId(n2, ObjektnamenSortierung.BEKANNTHEIT).get(0);
            ExoplanetOverviewDto exoplanetOverviewDto = new ExoplanetOverviewDto();
            exoplanetOverviewDto.setPlanetName(string);
            exoplanetOverviewDto.setDiscoveryDate(tuple.get(qDaten.entdeckungsdatum));
            exoplanetOverviewDto.setConfirmed(tuple.get(qDaten.entdeckungbestaetigt));
            arrayList.add(exoplanetOverviewDto);
        }
        return arrayList;
    }

    @Override
    public int getAnzahlBestaetigteExoplaneten() throws SQLException {
        QDaten qDaten = QDaten.daten;
        Integer n = this.objektnamenRepository.readDatenid("Sonne");
        long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.zugehoerigkeit.ne(n)))).fetchCount();
        return (int)l;
    }

    @Override
    public List<String> findExoplanetenEntdecker() throws SQLException {
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QDaten qDaten = QDaten.daten;
        Integer n = this.objektnamenRepository.readDatenid("Sonne");
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qZtentdecker.datenid.eq(qDaten.id))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qDaten.objektid.in((Collection<Integer>)this.getObjekttypenidsPlaneten()).and(qDaten.zugehoerigkeit.ne(n)))).orderBy((OrderSpecifier<?>)qEntdecker.nachname.asc())).fetch();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (Entdecker entdecker : list) {
            if (entdecker == null || entdecker.getNachname() == null) continue;
            if (EntdeckerTyp.PERSON.getType().equals(entdecker.getTyp()) || entdecker.getTyp() == null) {
                treeSet.add(entdecker.getNachname() + ", " + entdecker.getVorname());
                continue;
            }
            treeSet.add(entdecker.getNachname());
        }
        return new ArrayList<String>(treeSet);
    }

    @Override
    public List<ExoplanetOverviewDto> getExoplanetsByDiscovererLastName(String string) {
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QDaten qDaten = QDaten.daten;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.entdeckungbestaetigt}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qZtentdecker)).on((Predicate)qZtentdecker.datenid.eq(qDaten.id))).leftJoin((EntityPath)qEntdecker)).on((Predicate)qEntdecker.id.eq(qZtentdecker.entdeckerid))).where(qEntdecker.nachname.eq(string))).orderBy((OrderSpecifier<?>)qDaten.id.asc())).fetch();
        ArrayList<ExoplanetOverviewDto> arrayList = new ArrayList<ExoplanetOverviewDto>();
        for (Tuple tuple : list) {
            try {
                ExoplanetOverviewDto exoplanetOverviewDto = this.createOverviewDto(tuple);
                arrayList.add(exoplanetOverviewDto);
            }
            catch (SQLException sQLException) {
                this.logger.error("error while fetch exoplanets for discoverer " + string, sQLException);
            }
        }
        return arrayList;
    }

    @Override
    public List<Integer> getDatenIdsConfirmedExoplanets() {
        try {
            QDaten qDaten = QDaten.daten;
            return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.zugehoerigkeit.ne(this.idCache.getDatenIdSonne())))).fetch();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            throw new IllegalStateException("no star with name 'sun' found");
        }
    }
}

