/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.kategorien;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.kategorien.ISterneRepository;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QLumin;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import java.sql.SQLException;
import java.util.List;

public final class SterneRepository
implements ISterneRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
    private final QSpektraltyp2 qSpektraltyp2 = QSpektraltyp2.spektraltyp2;
    private final QLumin qLeuchtkraftklassen = QLumin.lumin;
    private final QKategorie qKategorie = QKategorie.kategorie;

    @Inject
    public SterneRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public List<String> getSpektraltypen(String string) throws SQLException {
        if (string == null || string.isEmpty()) {
            return ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSpektraltyp.typ).from((Expression<?>)this.qSpektraltyp)).fetch();
        }
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSpektraltyp.typ).from((Expression<?>)this.qSpektraltyp)).where(this.qSpektraltyp.kid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(string))))).fetch();
    }

    @Override
    public List<Double> getSpektraltypen2(boolean bl) throws SQLException {
        List<Double> list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSpektraltyp2.typ).from((Expression<?>)this.qSpektraltyp2)).fetch();
        if (!bl) {
            list.remove(0.25);
            for (double d = 10.0; d < 13.5; d += 0.5) {
                list.remove(d);
            }
        }
        return list;
    }

    @Override
    public List<String> getLeuchtkraftklassen() throws SQLException {
        return ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qLeuchtkraftklassen.typ).from((Expression<?>)this.qLeuchtkraftklassen)).fetch();
    }

    @Override
    public Integer getIDFuerSpektraltyp(String string, String string2) throws SQLException {
        return (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSpektraltyp.id).from((Expression<?>)this.qSpektraltyp)).where(this.qSpektraltyp.typ.eq(string).and(this.qSpektraltyp.kid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(string2)))))).fetchFirst();
    }

    @Override
    public Integer getIDFuerSpektraltyp2(double d) throws SQLException {
        return (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSpektraltyp2.id).from((Expression<?>)this.qSpektraltyp2)).where(this.qSpektraltyp2.typ.eq(d))).fetchFirst();
    }

    @Override
    public Integer getIDFuerLeuchtkraftklasse(String string) throws SQLException {
        return (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qLeuchtkraftklassen.id).from((Expression<?>)this.qLeuchtkraftklassen)).where(this.qLeuchtkraftklassen.typ.eq(string))).fetchFirst();
    }
}

