/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QLumin;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QNotizen;
import de.planetensuche.datenbankkern.querydsl5.QObjektalter;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.datenbankkern.querydsl5.Ztentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class MigrationHelper {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(MigrationHelper.class);
    private final IDatenbankverbinder datenbankverbinder;

    public MigrationHelper(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    public void insertDiscoverer(Entdecker entdecker) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Integer n = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).executeWithKey(qEntdecker.id);
        entdecker.setId(n);
    }

    public void addPlanetsToDiscoverer(String string, String string2, List<String> list) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq(string2).and(qEntdecker.vorname.eq(string)))).fetchOne();
        if (entdecker == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("exoplanet hunter");
            entdecker.setNachname(string2);
            entdecker.setVorname(string);
            entdecker.setTyp(EntdeckerTyp.PERSON.getType());
            this.insertDiscoverer(entdecker);
        }
        this.linkDiscovererAndExoplanets(list, entdecker);
    }

    public void addPlanetsToDiscovererProject(EntdeckerProjekte entdeckerProjekte, String string, List<String> list) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq(entdeckerProjekte.getNameInDatabase()).and(qEntdecker.typ.eq(EntdeckerTyp.PROJECT.getType())))).fetchOne();
        if (entdecker == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet(string);
            entdecker.setNachname(entdeckerProjekte.getNameInDatabase());
            entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
            this.insertDiscoverer(entdecker);
        }
        this.linkDiscovererAndExoplanets(list, entdecker);
    }

    public void addPlanetsToSpaceTelescope(EntdeckerWeltraumteleskope entdeckerWeltraumteleskope, String string, List<String> list) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq(entdeckerWeltraumteleskope.getNameInDatabase()).and(qEntdecker.typ.eq(EntdeckerTyp.SPACE_TELESCOPE.getType())))).fetchOne();
        if (entdecker == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet(string);
            entdecker.setNachname(entdeckerWeltraumteleskope.getNameInDatabase());
            entdecker.setTyp(EntdeckerTyp.SPACE_TELESCOPE.getType());
            this.insertDiscoverer(entdecker);
        }
        this.linkDiscovererAndExoplanets(list, entdecker);
    }

    private void linkDiscovererAndExoplanets(List<String> list, Entdecker entdecker) throws SQLException {
        if (Check.isEmpty(list)) {
            return;
        }
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        for (String string : list) {
            QNamen qNamen = QNamen.namen1;
            Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchFirst();
            if (n == null) continue;
            Ztentdecker ztentdecker = new Ztentdecker();
            ztentdecker.setDatenid(n);
            ztentdecker.setEntdeckerid(entdecker.getId());
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(ztentdecker)).execute();
        }
    }

    int createPlanetensucheObjekt(List<String> list, String string) throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(string))).fetchFirst();
        Daten daten = new Daten();
        daten.setObjektid(n);
        daten.setAutor("Gerd G\u00fchne");
        daten.setStamp(new Timestamp(System.currentTimeMillis()));
        Integer n2 = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qDaten).populate(daten)).executeWithKey(qDaten.id);
        for (String string2 : list) {
            Namen namen = new Namen();
            namen.setDatenid(n2);
            namen.setNamen(string2);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        }
        return n2;
    }

    void renameName(String string, String string2) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.namen, string2)).where((Predicate)qNamen.namen.eq(string))).execute();
    }

    void deleteName(String string) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        Long l = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.id.count()).from((Expression<?>)qNamen)).where(qNamen.datenid.eq((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))))).fetchCount();
        if (l == 0L) {
            return;
        }
        if (l < 2L) {
            throw new IllegalArgumentException("Could not delete objekt name '" + string + "' because the object have only this one!");
        }
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.eq(string))).execute();
    }

    void deleteNamen(List<String> list2) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        List list3 = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qNamen).where(qNamen.namen.in(list2))).fetch();
        HashMap<Integer, List> hashMap = new HashMap<Integer, List>();
        for (Namen namen : list3) {
            hashMap.putIfAbsent(namen.getDatenid(), new ArrayList());
            List list4 = (List)hashMap.get(namen.getDatenid());
            list4.add(namen.getNamen());
        }
        hashMap.forEach((n, list) -> {
            Long l = (Long)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.id.count()).from((Expression<?>)qNamen)).where(qNamen.datenid.eq((Integer)n))).fetchOne();
            if (l == (long)list.size()) {
                throw new IllegalArgumentException("Could not delete objekt names '" + list.toString() + "' because the object have only this ones!");
            }
        });
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.namen.in(list2))).execute();
    }

    boolean existsName(String string) {
        QNamen qNamen = QNamen.namen1;
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchFirst() != null;
    }

    Daten readPlanetensucheObject(String string) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchFirst();
        if (n == null) {
            return null;
        }
        Daten daten = (Daten)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten).from((Expression<?>)qDaten)).where(qDaten.id.eq(n))).fetchFirst();
        return daten;
    }

    void setzeAufUnbestaetigt(String string) {
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        try {
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).set((Path)qDaten.entdeckungbestaetigt, (Object)false)).where((Predicate)qDaten.id.eq((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))))).execute();
        }
        catch (IllegalArgumentException | SQLException exception) {
            LOGGER.error("Fehler beim Aktualisieren der Exoplaneten", exception);
        }
    }

    void addNamen(String string, String string2) throws SQLException {
        if (string.equalsIgnoreCase(string2)) {
            return;
        }
        QNamen qNamen = QNamen.namen1;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchFirst();
        if (n == null) {
            LOGGER.warn("keine datenid f\u00fcr namen '" + string + "' gefunden!");
            return;
        }
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.id).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string2))).fetchFirst();
        if (n2 != null) {
            return;
        }
        Namen namen = new Namen();
        namen.setDatenid(n);
        namen.setNamen(string2);
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qNamen).populate(namen)).execute();
        QDaten qDaten = QDaten.daten;
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).set((Path)qDaten.stamp, Timestamp.from(Instant.now()))).where((Predicate)qDaten.id.eq(n))).execute();
    }

    public void deletePlanetensucheObject(String string) throws SQLException {
        this.deletePlanetensucheObjects(List.of(string));
    }

    public void deletePlanetensucheObjects(List<String> list) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.in(list))).fetch();
        if (list2 != null) {
            for (Integer n : list2) {
                if (n == null) continue;
                this.deletePlanetensucheObject(n);
            }
        }
    }

    public void deletePlanetensucheObject(Integer n) {
        try {
            QNotizen qNotizen = QNotizen.notizen;
            QZt qZt = QZt.zt;
            QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
            QObjektalter qObjektalter = QObjektalter.objektalter;
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.zugehoerigkeit.eq(n))).fetch();
            if (Check.isFilled(list)) {
                throw new SQLIntegrityConstraintViolationException("datenid " + n + " hat noch " + list.size() + " Kindobjekte und kann nicht gel\u00f6scht werden");
            }
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qZt).where((Predicate)qZt.datenid.eq(n))).execute();
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qZtentdecker).where((Predicate)qZtentdecker.datenid.eq(n))).execute();
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qObjektalter).where((Predicate)qObjektalter.datenid.eq(n))).execute();
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNotizen).where((Predicate)qNotizen.datenid.eq(n))).execute();
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.datenid.eq(n))).execute();
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qDaten).where((Predicate)qDaten.id.eq(n))).execute();
        }
        catch (IllegalArgumentException | SQLException exception) {
            LOGGER.error("Fehler beim L\u00f6schen alter Datens\u00e4tze", exception);
        }
    }

    void updateMkSystem(String string, String string2, double d, String string3) throws SQLException {
        Daten daten = this.readPlanetensucheObject(string);
        if (daten == null) {
            return;
        }
        QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
        QSpektraltyp2 qSpektraltyp2 = QSpektraltyp2.spektraltyp2;
        QKategorie qKategorie = QKategorie.kategorie;
        QLumin qLumin = QLumin.lumin;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qSpektraltyp.id).from((Expression<?>)qSpektraltyp)).where(qSpektraltyp.typ.eq(string2).and(qSpektraltyp.kid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName())))))).fetchOne();
        daten.setSpektralklasse(n);
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qSpektraltyp2.id).from((Expression<?>)qSpektraltyp2)).where(qSpektraltyp2.typ.eq(d))).fetchOne();
        daten.setSpektralklasse2(n2);
        Integer n3 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qLumin.id).from((Expression<?>)qLumin)).where(qLumin.typ.eq(string3))).fetchOne();
        daten.setLumin(n3);
        QDaten qDaten = QDaten.daten;
        daten.setStamp(Timestamp.from(Instant.now()));
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).populate(daten)).where((Predicate)qDaten.id.eq(daten.getId()))).execute();
    }

    void updatePlanetensucheObjekt(Daten daten) throws SQLException {
        QDaten qDaten = QDaten.daten;
        daten.setStamp(Timestamp.from(Instant.now()));
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).populate(daten)).where((Predicate)qDaten.id.eq(daten.getId()))).execute();
    }

    void moveChildObjectsToNewParent(String string, String string2) throws SQLException {
        QNamen qNamen = QNamen.namen1;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))).fetchFirst();
        if (n == null) {
            LOGGER.warn("keine datenid f\u00fcr namen '" + string + "' gefunden!");
            return;
        }
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string2))).fetchFirst();
        if (n2 == null) {
            LOGGER.warn("keine datenid f\u00fcr namen '" + string2 + "' gefunden!");
            return;
        }
        this.moveChildObjectsToNewParent(n, n2);
    }

    void moveChildObjectsToNewParent(Integer n, Integer n2) throws SQLException {
        if (n.intValue() == n2.intValue()) {
            throw new IllegalArgumentException("old and new parent object is the same!");
        }
        QDaten qDaten = QDaten.daten;
        List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.zugehoerigkeit.eq(n))).fetch();
        if (Check.isFilled(list)) {
            for (Daten daten : list) {
                ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qDaten).set((Path)qDaten.zugehoerigkeit, n2)).where((Predicate)qDaten.id.eq(daten.getId()))).execute();
            }
        }
    }

    void setStarObjectType(String string, StarObjectType starObjectType) throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq(starObjectType.getTypeName()))).fetchOne();
        Daten daten = this.readPlanetensucheObject(string);
        if (daten == null) {
            LOGGER.warn("no star found in database for name '" + string + "'!");
            return;
        }
        daten.setObjektid(n);
        this.updatePlanetensucheObjekt(daten);
    }

    void setBrownDwarfObjectType(String string) throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Brauner Zwerg"))).fetchOne();
        if (n == null) {
            throw new IllegalStateException("no object type for brown dwarf found!");
        }
        Daten daten = this.readPlanetensucheObject(string);
        if (daten == null) {
            LOGGER.warn("no planet found in database for name '" + string + "'!");
            return;
        }
        daten.setObjektid(n);
        this.updatePlanetensucheObjekt(daten);
    }
}

